/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.applet;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.CellSetReader;
import com.runqian.report.cellset.Field;
import com.runqian.report.control.SaveAsExcel;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.view.applet.Page;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class AppletReport
extends JApplet
implements ActionListener {
    private String appRoot;
    private String fileName;
    private String reportParamsId;
    private String fontFace;
    private String fontSize;
    private String pageMarkColor;
    private String buttonForeColor;
    private String buttonBackColor;
    private String functionBarColor;
    private String mouseOnLinkColor;
    private String canModify;
    private String lookAndFeel;
    private JLabel currPageLabel;
    private JLabel totalPageLabel;
    private JButton firstPageButton = new JButton();
    private JButton prevPageButton = new JButton();
    private JButton nextPageButton = new JButton();
    private JButton lastPageButton = new JButton();
    private JButton excelButton = new JButton();
    private JButton printButton = new JButton();
    private JScrollPane jsp;
    private PageBuilder pb;
    private ArrayList pages;
    private int currPageNo = 1;
    private boolean editable = false;

    public void init() {
        try {
            this.initParameters();
            try {
                if (this.lookAndFeel.equalsIgnoreCase("windows")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } else {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initApplet();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            e.printStackTrace();
        }
    }

    private void initApplet() throws Exception {
        if (this.appRoot.equals("")) {
            throw new Exception("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u6839\u8def\u5f84!");
        }
        if (this.fileName.equals("")) {
            throw new Exception("\u6ca1\u6709\u6307\u5b9a\u62a5\u8868\u6587\u4ef6!");
        }
        String dataServer = String.valueOf(this.appRoot) + "/servlet/com.runqian.report.view.DataServlet?fileName=" + this.fileName;
        if (this.reportParamsId != null) {
            dataServer = String.valueOf(dataServer) + "&reportParamsId=" + this.reportParamsId;
        }
        URL url = new URL(dataServer);
        CellSet cellSet = new CellSetReader(url.openStream()).read();
        this.createPageBuilder(cellSet);
        this.pages = new ArrayList(this.pb.getPageCount());
        Color onLinkColor = this.transColor(this.mouseOnLinkColor);
        int i = 0;
        while (i < this.pb.getPageCount()) {
            Page page = new Page(this.pb.getPage(i + 1), this, this.editable, this.appRoot, onLinkColor);
            this.pages.add(page);
            ++i;
        }
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.jsp = new JScrollPane(20, 30);
        pane.add(this.jsp);
        this.addFunctionBar();
        this.setCurrentPage(1);
    }

    private void createPageBuilder(CellSet cellSet) throws Exception {
        CellSetParser parser = new CellSetParser(cellSet);
        PageFormat pf = parser.getPageFormat();
        int width = (int)pf.getImageableWidth() - 2;
        int height = (int)pf.getImageableHeight() - 2;
        Field pageHeader = parser.getPageHeader();
        Field pageFooter = parser.getPageFooter();
        if (pageHeader != null) {
            height -= parser.getFieldScanHeight(pageHeader);
        }
        if (pageFooter != null) {
            height -= parser.getFieldScanHeight(pageFooter);
        }
        this.pb = new PageBuilder(cellSet, width, height);
    }

    private void addFunctionBar() throws Exception {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Color barColor = this.transColor(this.functionBarColor);
        panel.setBackground(barColor);
        int col = 0;
        Font font = new Font(this.fontFace, 0, Integer.parseInt(this.fontSize));
        this.currPageLabel = new JLabel();
        this.currPageLabel.setFont(font);
        panel.add((Component)this.currPageLabel, this.createGBC(col++));
        this.totalPageLabel = new JLabel("\u5171" + this.pb.getPageCount() + "\u9875");
        this.totalPageLabel.setFont(font);
        panel.add((Component)this.totalPageLabel, this.createGBC(col++));
        Color markColor = this.transColor(this.pageMarkColor);
        this.currPageLabel.setForeground(markColor);
        this.totalPageLabel.setForeground(markColor);
        this.addButton(panel, this.firstPageButton, "\u6700\u524d\u9875", col++, font);
        this.addButton(panel, this.prevPageButton, "\u4e0a\u4e00\u9875", col++, font);
        this.addButton(panel, this.nextPageButton, "\u4e0b\u4e00\u9875", col++, font);
        this.addButton(panel, this.lastPageButton, "\u6700\u540e\u9875", col++, font);
        this.addButton(panel, this.excelButton, "\u5b58\u4e3aExcel", col++, font);
        this.addButton(panel, this.printButton, "\u6253  \u5370", col++, font);
        GridBagConstraints gbc = this.createGBC(col);
        gbc.weightx = 1.0;
        JPanel restPanel = new JPanel();
        restPanel.setBackground(barColor);
        panel.add((Component)restPanel, gbc);
        this.getContentPane().add((Component)panel, "North");
    }

    private void setCurrentPage(int pageNo) {
        Page currPage = (Page)this.pages.get(pageNo - 1);
        if (!currPage.isCreated) {
            currPage.create();
        }
        this.jsp.getViewport().setView(currPage);
        this.currPageNo = pageNo;
        this.currPageLabel.setText("\u7b2c" + pageNo + "\u9875");
        if (pageNo == 1) {
            this.firstPageButton.setEnabled(false);
            this.prevPageButton.setEnabled(false);
            if (this.pb.getPageCount() > 1) {
                this.nextPageButton.setEnabled(true);
                this.lastPageButton.setEnabled(true);
            } else {
                this.nextPageButton.setEnabled(false);
                this.lastPageButton.setEnabled(false);
            }
        } else {
            this.firstPageButton.setEnabled(true);
            this.prevPageButton.setEnabled(true);
            if (pageNo == this.pb.getPageCount()) {
                this.nextPageButton.setEnabled(false);
                this.lastPageButton.setEnabled(false);
            } else {
                this.nextPageButton.setEnabled(true);
                this.lastPageButton.setEnabled(true);
            }
        }
    }

    private GridBagConstraints createGBC(int col) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(3, 3, 3, 3);
        return gbc;
    }

    private void addButton(JPanel panel, JButton button, String text, int col, Font font) throws Exception {
        button.setText(text);
        button.setFont(font);
        Insets insets = new Insets(2, 3, 2, 3);
        button.setMargin(insets);
        button.setForeground(this.transColor(this.buttonForeColor));
        button.setBackground(this.transColor(this.buttonBackColor));
        button.addActionListener(this);
        panel.add((Component)button, this.createGBC(col));
    }

    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source.equals(this.firstPageButton)) {
            this.setCurrentPage(1);
        } else if (source.equals(this.lastPageButton)) {
            this.setCurrentPage(this.pb.getPageCount());
        } else if (source.equals(this.prevPageButton)) {
            int pageNo = this.currPageNo - 1;
            if (pageNo < 1) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.nextPageButton)) {
            int pageNo = this.currPageNo + 1;
            if (pageNo > this.pb.getPageCount()) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.excelButton)) {
            try {
                String sessionId = new SaveAsExcel(this.pb, this.appRoot, "").post();
                String xlsName = this.fileName;
                int pos = xlsName.lastIndexOf(".");
                if (pos > 0) {
                    xlsName = xlsName.substring(0, pos);
                }
                URL url = new URL(String.valueOf(this.appRoot) + "/servlet/com.runqian.report.control.SaveAsExcelServlet?sessionId=" + sessionId + "&fileName=" + xlsName);
                this.getAppletContext().showDocument(url);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
                ex.printStackTrace();
            }
        } else if (source.equals(this.printButton)) {
            // empty if block
        }
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", "");
        this.fileName = this.getParameter("fileName", "");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        this.fontFace = this.getParameter("fontFace", "\u5b8b\u4f53");
        this.fontSize = this.getParameter("fontSize", "12");
        this.pageMarkColor = this.getParameter("pageMarkColor", "0,0,0");
        this.buttonForeColor = this.getParameter("buttonForeColor", "0,0,0");
        this.buttonBackColor = this.getParameter("buttonBackColor", "196,196,196");
        this.functionBarColor = this.getParameter("functionBarColor", "0x1E,0x90,0xFF");
        this.lookAndFeel = this.getParameter("lookAndFeel", "Metal");
        this.mouseOnLinkColor = this.getParameter("mouseOnLinkColor", "255,0,0");
        this.canModify = this.getParameter("canModify", "no");
        if (this.canModify.equalsIgnoreCase("yes")) {
            this.editable = true;
        }
    }

    private String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    private Color transColor(String sColor) throws Exception {
        StringTokenizer st = new StringTokenizer(sColor, ",");
        if (st.countTokens() != 3) {
            throw new Exception("\u989c\u8272\u503c" + sColor + "\u4e0d\u6b63\u786e! \u8bf7\u6309r,g,b\u7684\u683c\u5f0f\u8f93\u5165.");
        }
        String sRed = st.nextToken();
        String sGreen = st.nextToken();
        String sBlue = st.nextToken();
        int red = this.string2Int(sRed);
        int green = this.string2Int(sGreen);
        int blue = this.string2Int(sBlue);
        return new Color(red, green, blue);
    }

    private int string2Int(String s) {
        if (s == null) {
            return 0;
        }
        s = s.trim().toLowerCase();
        try {
            if (s.startsWith("0x")) {
                s = s.substring(2);
                return Integer.valueOf(s, 16);
            }
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

