/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.applet;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.CellSetReader;
import com.runqian.report.control.PrintFrame;
import com.runqian.report.pager.PageBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.net.URL;
import java.util.Date;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class HtmlPrintApplet
extends JApplet {
    private String appRoot;
    private String dataServlet;
    private String fileName;
    private String srcType;
    private PageBuilder pb;
    private String canModify;
    private String swidth;
    private String sheight;
    private String reportParamsId;
    private String connection;
    private String cachedId;
    private String userUnitName;

    public void init() {
        try {
            this.initParameters();
            if (this.appRoot.equals("")) {
                throw new Exception("\u6ca1\u6709\u6307\u5b9a\u5e94\u7528\u6839\u8def\u5f84!");
            }
            if (this.fileName.equals("")) {
                throw new Exception("\u6ca1\u6709\u6307\u5b9a\u62a5\u8868\u6587\u4ef6!");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            e.printStackTrace();
        }
    }

    public void print(boolean needPreview, boolean needSelectPrinter) throws Exception {
        JFrame frame = new JFrame("\u6253\u5370\u63d0\u793a");
        frame.setSize(300, 100);
        frame.setLocation(250, 250);
        frame.setVisible(true);
        frame.getContentPane().setLayout(new BorderLayout());
        JLabel label = new JLabel("\u6b63\u5728\u751f\u6210\u6253\u5370\u9875\u9762, \u8bf7\u7a0d\u5019......");
        label.setForeground(Color.red);
        label.setHorizontalAlignment(0);
        label.setFont(new Font("\u5b8b\u4f53", 0, 12));
        frame.getContentPane().add(label);
        frame.show();
        String dataServer = String.valueOf(this.appRoot) + this.dataServlet + "?fileName=" + this.fileName + "&srcType=" + this.srcType;
        if (this.reportParamsId != null) {
            dataServer = String.valueOf(dataServer) + "&reportParamsId=" + this.reportParamsId;
        }
        if (this.connection != null) {
            dataServer = String.valueOf(dataServer) + "&connection=" + this.connection;
        }
        if (this.cachedId != null) {
            dataServer = String.valueOf(dataServer) + "&cachedId=" + this.cachedId;
        }
        dataServer = String.valueOf(dataServer) + "&time=" + new Date().getTime();
        URL url = new URL(dataServer);
        CellSet cellSet = new CellSetReader(url.openStream()).read();
        boolean editable = false;
        if (!this.canModify.equalsIgnoreCase("no")) {
            editable = true;
        }
        PrintFrame f = new PrintFrame(cellSet, this.userUnitName, editable);
        if (needPreview) {
            f.show();
        } else {
            label.setText("\u6b63\u5728\u53d1\u9001\u5230\u6253\u5370\u673a......");
            f.setModal(false);
            f.setLocation(-1000, -1000);
            f.show();
            f.directPrint(needSelectPrinter);
        }
        frame.hide();
        frame.dispose();
    }

    public void print() throws Exception {
        this.print(true, false);
    }

    private void createPageBuilder(CellSet cellSet) throws Exception {
        CellSetParser parser = new CellSetParser(cellSet);
        PageFormat pf = parser.getPageFormat();
        int width = this.swidth.equals("0") ? (int)pf.getImageableWidth() - 2 : Integer.parseInt(this.swidth);
        int height = this.sheight.equals("0") ? (int)pf.getImageableHeight() - 2 : Integer.parseInt(this.sheight);
        this.pb = new PageBuilder(cellSet, width, height, 0, false);
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", "");
        this.dataServlet = this.getParameter("dataServlet", "");
        this.fileName = this.getParameter("fileName", "");
        this.srcType = this.getParameter("srcType", "file");
        this.canModify = this.getParameter("canModify", "no");
        this.swidth = this.getParameter("swidth", "0");
        this.sheight = this.getParameter("sheight", "0");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        this.connection = this.getParameter("connection", null);
        this.cachedId = this.getParameter("cachedId", null);
        this.userUnitName = this.getParameter("unitName", "");
    }

    private String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }
}

