/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.applet;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.CellSetReader;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.PrintPage;
import com.runqian.report.control.SaveAsExcel;
import com.runqian.report.pager.PageBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class PrintReport
extends JApplet
implements ActionListener {
    private CellSet cellSet;
    private int columns = 0;
    private PageBuilder pb;
    private PageFormat pf;
    private JScrollPane dispPane;
    private JPanel dispPanel;
    private JPanel hidePanel;
    private JLabel pageMarkLabel;
    private JComboBox gotoPageBox;
    private JButton firstPageButton = new JButton();
    private JButton prevPageButton = new JButton();
    private JButton nextPageButton = new JButton();
    private JButton lastPageButton = new JButton();
    private JComboBox ratioBox;
    private JButton zoomoutButton = new JButton();
    private JButton zoominButton = new JButton();
    private JButton refreshButton = new JButton();
    private JButton pageSetupButton = new JButton();
    private JButton printButton = new JButton();
    private JButton excelButton = new JButton();
    private JTextField columnsField;
    private Book printBook;
    private int currPageNo = 1;
    private int pageCounts;
    public double currScale = 1.0;
    private String appRoot;
    private String dataServlet;
    private String postServlet;
    private String excelServlet;
    private boolean editable;
    private String srcType;
    private String fileName;
    private String reportParamsId;
    private String connection;

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initParameters();
        String dataServer = String.valueOf(this.appRoot) + this.dataServlet + "?fileName=" + this.fileName + "&srcType=" + this.srcType;
        if (this.reportParamsId != null) {
            dataServer = String.valueOf(dataServer) + "&reportParamsId=" + this.reportParamsId;
        }
        if (this.connection != null) {
            dataServer = String.valueOf(dataServer) + "&connection=" + this.connection;
        }
        try {
            URL url = new URL(dataServer);
            this.cellSet = new CellSetReader(url.openStream()).read();
            CellSetParser parser = new CellSetParser(this.cellSet);
            this.pf = parser.getPageFormat();
            this.createPageBuilder();
            this.columns = this.pb.getColumns();
            this.dispPane = new JScrollPane(20, 30);
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            this.hidePanel = new JPanel();
            pane.add(this.hidePanel);
            pane.add(this.dispPane);
            this.addFunctionBar();
            this.initPrintWindow();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void createPageBuilder() throws Exception {
        int width = (int)this.pf.getImageableWidth() - 2;
        int height = (int)this.pf.getImageableHeight() - 2;
        this.pb = new PageBuilder(this.cellSet, width, height, this.columns);
    }

    private void initPrintWindow() {
        this.hidePanel.removeAll();
        this.gotoPageBox.removeAllItems();
        this.printBook = new Book();
        this.pageCounts = 0;
        int pageNo = 1;
        while (true) {
            PrintPage page = new PrintPage(this.pb, this.pf, pageNo, this.editable);
            try {
                page.create();
            }
            catch (Exception e) {
                break;
            }
            this.hidePanel.add(page);
            this.printBook.append(page, this.pf);
            this.gotoPageBox.addItem(String.valueOf(pageNo));
            ++pageNo;
            ++this.pageCounts;
        }
        this.setCurrentPage(1);
        this.ratioBox.setSelectedIndex(3);
    }

    private void addFunctionBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        this.pageMarkLabel = new JLabel();
        this.pageMarkLabel.setFont(font);
        panel.add((Component)this.pageMarkLabel, this.createGBC(row++));
        JPanel gotoPanel = new JPanel();
        JLabel label1 = new JLabel("\u5230\u7b2c");
        label1.setFont(font);
        gotoPanel.add(label1);
        this.gotoPageBox = new JComboBox();
        this.gotoPageBox.setFont(font);
        this.gotoPageBox.setPreferredSize(new Dimension(40, 20));
        this.gotoPageBox.addActionListener(this);
        gotoPanel.add(this.gotoPageBox);
        JLabel label2 = new JLabel("\u9875");
        label2.setFont(font);
        gotoPanel.add(label2);
        panel.add((Component)gotoPanel, this.createGBC(row++));
        this.addButton(panel, this.firstPageButton, "\u6700\u524d\u9875", row++, font);
        this.addButton(panel, this.prevPageButton, "\u4e0a\u4e00\u9875", row++, font);
        this.addButton(panel, this.nextPageButton, "\u4e0b\u4e00\u9875", row++, font);
        this.addButton(panel, this.lastPageButton, "\u6700\u540e\u9875", row++, font);
        this.addButton(panel, this.zoominButton, "\u653e  \u5927", row++, font);
        this.addButton(panel, this.zoomoutButton, "\u7f29  \u5c0f", row++, font);
        this.addButton(panel, this.refreshButton, "\u5237\u65b0\u663e\u793a", row++, font);
        JPanel ratioPanel = new JPanel();
        JLabel label3 = new JLabel("\u6bd4\u4f8b");
        label3.setFont(font);
        ratioPanel.add(label3);
        this.ratioBox = new JComboBox<String>(new String[]{"\u6574\u9875", "50%", "75%", "100%", "150%", "200%"});
        this.ratioBox.setFont(font);
        this.ratioBox.setPreferredSize(new Dimension(55, 20));
        this.ratioBox.addActionListener(this);
        ratioPanel.add(this.ratioBox);
        panel.add((Component)ratioPanel, this.createGBC(row++));
        JPanel fenlanPanel = new JPanel();
        JLabel label4 = new JLabel("\u5206\u680f:");
        label4.setFont(font);
        fenlanPanel.add(label4);
        this.columnsField = new JTextField(String.valueOf(this.columns));
        this.columnsField.setFont(font);
        this.columnsField.setPreferredSize(new Dimension(50, 20));
        this.columnsField.setHorizontalAlignment(0);
        this.columnsField.addActionListener(this);
        fenlanPanel.add(this.columnsField);
        panel.add((Component)fenlanPanel, this.createGBC(row++));
        this.addButton(panel, this.excelButton, "\u5b58\u4e3aExcel", row++, font);
        this.addButton(panel, this.pageSetupButton, "\u9875\u9762\u8bbe\u7f6e", row++, font);
        this.addButton(panel, this.printButton, "\u6253  \u5370", row++, font);
        GridBagConstraints gbc = this.createGBC(row);
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
        this.getContentPane().add((Component)panel, "East");
    }

    private void addButton(JPanel panel, JButton button, String text, int row, Font font) {
        button.setText(text);
        button.setFont(font);
        button.setPreferredSize(new Dimension(85, 25));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.addActionListener(this);
        panel.add((Component)button, this.createGBC(row));
    }

    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source.equals(this.gotoPageBox)) {
            int pageNo = Integer.parseInt(this.gotoPageBox.getSelectedItem().toString());
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.firstPageButton)) {
            this.setCurrentPage(1);
        } else if (source.equals(this.lastPageButton)) {
            this.setCurrentPage(this.pageCounts);
        } else if (source.equals(this.prevPageButton)) {
            int pageNo = this.currPageNo - 1;
            if (pageNo < 1) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.nextPageButton)) {
            int pageNo = this.currPageNo + 1;
            if (pageNo > this.pageCounts) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.zoominButton)) {
            this.hideEditor();
            this.currScale *= 1.5;
            this.changeDisplayScale();
        } else if (source.equals(this.zoomoutButton)) {
            this.hideEditor();
            this.currScale *= 0.667;
            this.changeDisplayScale();
        } else if (source.equals(this.refreshButton)) {
            this.dispPane.repaint();
        } else if (source.equals(this.ratioBox)) {
            this.hideEditor();
            String selectedRatio = this.ratioBox.getSelectedItem().toString();
            if (selectedRatio.equals("\u6574\u9875")) {
                Rectangle r = this.dispPane.getViewport().getViewRect();
                int pfWidth = (int)this.pf.getWidth();
                int pfHeight = (int)this.pf.getHeight();
                double hScale = (double)r.width * 1.0 / (double)pfWidth;
                double vScale = (double)r.height * 1.0 / (double)pfHeight;
                this.currScale = Math.min(hScale, vScale);
                this.changeDisplayScale();
            } else {
                this.currScale = Double.parseDouble(selectedRatio.substring(0, selectedRatio.length() - 1)) / 100.0;
                this.changeDisplayScale();
            }
        } else if (source.equals(this.columnsField)) {
            int newColumns = 1;
            try {
                newColumns = Integer.parseInt(this.columnsField.getText());
            }
            catch (Exception ex) {
                this.columnsField.setText(String.valueOf(this.columns));
                return;
            }
            if (newColumns > 5) {
                newColumns = 5;
                this.columnsField.setText(String.valueOf(newColumns));
            }
            if (newColumns != this.columns) {
                this.columns = newColumns;
                try {
                    this.createPageBuilder();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
                this.initPrintWindow();
            }
        } else if (source.equals(this.excelButton)) {
            try {
                String sessionId = new SaveAsExcel(this.pb, this.appRoot, this.postServlet).post();
                URL url = new URL(String.valueOf(this.appRoot) + this.excelServlet + "?sessionId=" + sessionId + "&fileName=" + this.fileName);
                this.getAppletContext().showDocument(url);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
                ex.printStackTrace();
            }
        } else if (source.equals(this.pageSetupButton)) {
            int imageWidth = (int)this.pf.getImageableWidth();
            int imageHeight = (int)this.pf.getImageableHeight();
            this.pf = PrinterJob.getPrinterJob().pageDialog(this.pf);
            if (imageWidth != (int)this.pf.getImageableWidth() || imageHeight != (int)this.pf.getImageableHeight()) {
                this.columns = Integer.parseInt(this.columnsField.getText());
                try {
                    this.createPageBuilder();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
                this.initPrintWindow();
            }
        } else if (source.equals(this.printButton)) {
            this.print();
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintPage.setScale(1.0);
        job.setPageable(this.printBook);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void changeDisplayScale() {
        PrintPage.setScale(this.currScale);
        this.dispPanel.setPreferredSize(new Dimension((int)(this.pf.getWidth() * this.currScale), (int)(this.pf.getHeight() * this.currScale)));
        this.dispPane.getViewport().setView(this.dispPanel);
    }

    private void setCurrentPage(int pageNo) {
        try {
            PrintPage oldPage = (PrintPage)this.printBook.getPrintable(this.currPageNo - 1);
            if (oldPage != null) {
                this.hidePanel.add(oldPage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PrintPage currPage = (PrintPage)this.printBook.getPrintable(pageNo - 1);
        this.dispPanel = new JPanel();
        this.dispPanel.add(currPage);
        this.dispPane.getViewport().setView(this.dispPanel);
        this.repaint();
        this.currPageNo = pageNo;
        this.pageMarkLabel.setText("\u9875\u7801: " + pageNo + "/" + this.pageCounts);
        if (pageNo == 1) {
            this.firstPageButton.setEnabled(false);
            this.prevPageButton.setEnabled(false);
        } else {
            this.firstPageButton.setEnabled(true);
            this.prevPageButton.setEnabled(true);
        }
        if (pageNo == this.pageCounts) {
            this.lastPageButton.setEnabled(false);
            this.nextPageButton.setEnabled(false);
        } else {
            this.lastPageButton.setEnabled(true);
            this.nextPageButton.setEnabled(true);
        }
    }

    private PrintPage getCurrentPage() {
        JPanel panel = (JPanel)this.dispPane.getViewport().getView();
        return (PrintPage)panel.getComponent(0);
    }

    private GridBagConstraints createGBC(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 5, 0, 5);
        return gbc;
    }

    private void hideEditor() {
        if (!this.editable) {
            return;
        }
        PrintPage page = this.getCurrentPage();
        this.hideEditor(page);
    }

    private void hideEditor(Container c) {
        Component[] child = c.getComponents();
        if (child.length == 0) {
            return;
        }
        int i = 0;
        while (i < child.length) {
            if (child[i] instanceof ContentPanel) {
                ContentPanel cp = (ContentPanel)child[i];
                cp.submitEditor();
                if (cp.editor != null) {
                    cp.editor.setVisible(false);
                    cp.m_activeCell = null;
                }
            } else {
                this.hideEditor((Container)child[i]);
            }
            ++i;
        }
    }

    public void destroy() {
        this.cellSet = null;
        this.pb = null;
        int i = 0;
        while (i < this.printBook.getNumberOfPages()) {
            ((PrintPage)this.printBook.getPrintable(i)).dispose();
            ++i;
        }
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", "");
        this.dataServlet = this.getParameter("dataServlet", "");
        this.postServlet = this.getParameter("postServlet", "");
        this.excelServlet = this.getParameter("excelServlet", "");
        this.fileName = this.getParameter("fileName", "");
        this.srcType = this.getParameter("srcType", "file");
        String tmp = this.getParameter("canModify", "no");
        this.editable = tmp.equalsIgnoreCase("yes");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        this.connection = this.getParameter("connection", null);
        tmp = this.getParameter("columns", "0");
        try {
            this.columns = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }
}

