/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.excel;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.view.excel.ExcelColor;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class ExcelCell {
    private CellSet cs;
    private int row;
    private int col;
    private HSSFWorkbook wb;
    private ArrayList styles;
    private ArrayList fonts;
    private Hashtable formats;

    public ExcelCell(CellSet cs, int row, int col, HSSFWorkbook wb, ArrayList fonts, ArrayList styles, Hashtable formats) {
        this.cs = cs;
        this.row = row;
        this.col = col;
        this.wb = wb;
        this.fonts = fonts;
        this.styles = styles;
        this.formats = formats;
    }

    HSSFCellStyle getStyle() {
        short format;
        short backColor;
        short borderBottomColor;
        short borderTopColor;
        short borderRightColor;
        short borderLeftColor;
        short borderBottom;
        short borderTop;
        short borderRight;
        short borderLeft;
        boolean wordwrap;
        short valign;
        int align;
        block33: {
            align = 2;
            valign = 1;
            wordwrap = false;
            borderLeft = 0;
            borderRight = 0;
            borderTop = 0;
            borderBottom = 0;
            borderLeftColor = 8;
            borderRightColor = 8;
            borderTopColor = 8;
            borderBottomColor = 8;
            backColor = 9;
            format = 0;
            int i = 0;
            while (i < CellPropertyDefine.prop_keys.length) {
                int key = CellPropertyDefine.prop_keys[i];
                Object pvalue = this.cs.getPropertyValue(this.row, this.col, key);
                if (pvalue != null) {
                    switch (key) {
                        case 4201: {
                            int i_align = (Integer)pvalue;
                            if (i_align == CellPropertyDefine.CA_LEFT) {
                                align = 1;
                            }
                            if (i_align == CellPropertyDefine.CA_CENTER) {
                                align = 2;
                            }
                            if (i_align != CellPropertyDefine.CA_RIGHT) break;
                            align = 3;
                            break;
                        }
                        case 4202: {
                            int i_valign = (Integer)pvalue;
                            if (i_valign == CellPropertyDefine.CVA_TOP) {
                                valign = 0;
                            }
                            if (i_valign == CellPropertyDefine.CVA_MIDDLE) {
                                valign = 1;
                            }
                            if (i_valign != CellPropertyDefine.CVA_BOTTOM) break;
                            valign = 2;
                            break;
                        }
                        case 4107: {
                            if (!((Boolean)pvalue).booleanValue()) break;
                            wordwrap = true;
                            break;
                        }
                        case 4401: {
                            borderLeft = this.getBorderStyle(pvalue, this.cs.getPropertyValue(this.row, this.col, 4402));
                            break;
                        }
                        case 4403: {
                            borderLeftColor = this.getColor(pvalue);
                            break;
                        }
                        case 4407: {
                            borderTop = this.getBorderStyle(pvalue, this.cs.getPropertyValue(this.row, this.col, 4408));
                            break;
                        }
                        case 4409: {
                            borderTopColor = this.getColor(pvalue);
                            break;
                        }
                        case 4404: {
                            borderRight = this.getBorderStyle(pvalue, this.cs.getPropertyValue(this.row, this.col, 4405));
                            break;
                        }
                        case 4406: {
                            borderRightColor = this.getColor(pvalue);
                            break;
                        }
                        case 4410: {
                            borderBottom = this.getBorderStyle(pvalue, this.cs.getPropertyValue(this.row, this.col, 4411));
                            break;
                        }
                        case 4412: {
                            borderBottomColor = this.getColor(pvalue);
                            break;
                        }
                        case 4413: {
                            backColor = this.getColor(pvalue);
                        }
                    }
                }
                ++i;
            }
            String s = this.getText();
            if (!(s = s.trim()).startsWith("0") || s.startsWith("0.")) {
                try {
                    double d = Double.parseDouble(s);
                    if (d <= 9.9999999999999E13) {
                        String fmt = (String)this.cs.getPropertyValue(this.row, this.col, 4104);
                        if (fmt != null && fmt.trim().length() > 0) {
                            format = this.getFormat(fmt.trim());
                        }
                        fmt = "#";
                        if (d > 9.9999999999E10) {
                            int pos = s.indexOf(".");
                            if (pos > 0) {
                                fmt = String.valueOf(fmt) + ".";
                                s = s.trim();
                                int m = pos;
                                while (m < s.length() - 1) {
                                    fmt = String.valueOf(fmt) + "0";
                                    ++m;
                                }
                            }
                            format = this.getFormat(fmt);
                        }
                    }
                }
                catch (Throwable e) {
                    String s1 = this.getValue();
                    s1 = s1.trim();
                    if (s1.equals(s)) break block33;
                    try {
                        double d = Double.parseDouble(s1);
                        String fmt = (String)this.cs.getPropertyValue(this.row, this.col, 4104);
                        if (fmt != null && fmt.trim().length() > 0) {
                            format = this.getFormat(fmt.trim());
                        }
                    }
                    catch (Throwable d) {
                        // empty catch block
                    }
                }
            }
        }
        HSSFFont font = this.getFont();
        int i = 0;
        while (i < this.styles.size()) {
            HSSFFont f;
            HSSFCellStyle style = (HSSFCellStyle)this.styles.get(i);
            if (style.getAlignment() == align && style.getVerticalAlignment() == valign && style.getWrapText() == wordwrap && style.getBorderLeft() == borderLeft && style.getBorderRight() == borderRight && style.getBorderTop() == borderTop && style.getBorderBottom() == borderBottom && style.getLeftBorderColor() == borderLeftColor && style.getRightBorderColor() == borderRightColor && style.getTopBorderColor() == borderTopColor && style.getBottomBorderColor() == borderBottomColor && style.getFillForegroundColor() == backColor && style.getDataFormat() == format && (f = this.wb.getFontAt(style.getFontIndex())).getFontName().equals(font.getFontName()) && f.getFontHeightInPoints() == font.getFontHeightInPoints() && f.getColor() == font.getColor() && f.getBoldweight() == font.getBoldweight() && f.getItalic() == font.getItalic() && f.getUnderline() == font.getUnderline()) {
                return style;
            }
            ++i;
        }
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setAlignment((short)align);
        style.setVerticalAlignment(valign);
        style.setWrapText(wordwrap);
        style.setBorderLeft(borderLeft);
        style.setBorderRight(borderRight);
        style.setBorderTop(borderTop);
        style.setBorderBottom(borderBottom);
        style.setLeftBorderColor(borderLeftColor);
        style.setRightBorderColor(borderRightColor);
        style.setTopBorderColor(borderTopColor);
        style.setBottomBorderColor(borderBottomColor);
        style.setFillPattern((short)1);
        style.setFillForegroundColor(backColor);
        style.setDataFormat(format);
        style.setShrinkToFit(true);
        style.setFont(font);
        this.styles.add(style);
        return style;
    }

    boolean isVisible() {
        Object obj = this.cs.getPropertyValue(this.row, this.col, 4106);
        if (obj == null) {
            return true;
        }
        return (Boolean)obj;
    }

    String getText() {
        String text = (String)this.cs.getPropertyValue(this.row, this.col, 4105);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getValue();
    }

    String getValue() {
        Object obj = this.cs.getPropertyValue(this.row, this.col, 4102);
        if (obj == null) {
            return "";
        }
        String text = "";
        if (obj instanceof byte[]) {
            try {
                text = new String((byte[])obj, "GBK");
            }
            catch (Exception exception) {}
        } else {
            text = obj.toString();
        }
        return text;
    }

    private short getBorderStyle(Object borderStyle, Object borderWidth) {
        int value;
        float width = 1.0f;
        if (borderWidth != null) {
            width = Float.parseFloat(borderWidth.toString());
        }
        if ((value = Integer.parseInt(borderStyle.toString())) == CellPropertyDefine.CBS_DASHED) {
            if ((double)width > 1.0) {
                return 8;
            }
            return 3;
        }
        if (value == CellPropertyDefine.CBS_DOTTED) {
            if ((double)width > 1.0) {
                return 10;
            }
            return 9;
        }
        if (value == CellPropertyDefine.CBS_DOUBLE) {
            return 6;
        }
        if (value == CellPropertyDefine.CBS_NONE) {
            return 0;
        }
        if (value == CellPropertyDefine.CBS_SOLID) {
            if ((double)width < 0.75) {
                return 4;
            }
            if ((double)width <= 1.0) {
                return 1;
            }
            if ((double)width <= 1.5) {
                return 2;
            }
            if ((double)width <= 2.0) {
                return 5;
            }
            return 5;
        }
        return 1;
    }

    private short getColor(Object c) {
        return ExcelColor.transColor(Integer.parseInt(c.toString()));
    }

    private HSSFFont getFont() {
        HSSFFont font;
        Object tmpObj = this.cs.getPropertyValue(this.row, this.col, 4301);
        String fontName = "\u5b8b\u4f53";
        if (tmpObj != null) {
            fontName = tmpObj.toString();
        }
        tmpObj = this.cs.getPropertyValue(this.row, this.col, 4302);
        short fontSize = 12;
        if (tmpObj != null) {
            fontSize = Short.parseShort(tmpObj.toString());
        }
        tmpObj = this.cs.getPropertyValue(this.row, this.col, 4303);
        new HSSFColor.BLACK();
        short fontColor = 8;
        if (tmpObj != null) {
            fontColor = this.getColor(tmpObj);
        }
        tmpObj = this.cs.getPropertyValue(this.row, this.col, 4304);
        short fontBold = 400;
        if (tmpObj != null && ((Boolean)tmpObj).booleanValue()) {
            fontBold = 700;
        }
        tmpObj = this.cs.getPropertyValue(this.row, this.col, 4305);
        boolean fontItalic = false;
        if (tmpObj != null) {
            fontItalic = (Boolean)tmpObj;
        }
        tmpObj = this.cs.getPropertyValue(this.row, this.col, 4306);
        byte fontUnderline = 0;
        if (tmpObj != null && ((Boolean)tmpObj).booleanValue()) {
            fontUnderline = 1;
        }
        int i = 0;
        while (i < this.fonts.size()) {
            font = (HSSFFont)this.fonts.get(i);
            if (font.getFontName().equalsIgnoreCase(fontName) && font.getFontHeightInPoints() == fontSize && font.getColor() == fontColor && font.getBoldweight() == fontBold && font.getItalic() == fontItalic && font.getUnderline() == fontUnderline) {
                return font;
            }
            ++i;
        }
        font = this.wb.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        font.setColor(fontColor);
        font.setBoldweight(fontBold);
        font.setItalic(fontItalic);
        font.setUnderline(fontUnderline);
        this.fonts.add(font);
        return font;
    }

    private short getFormat(String fmt) {
        if (this.formats.containsKey(fmt)) {
            String s = (String)this.formats.get(fmt);
            return Short.parseShort(s);
        }
        short format = this.wb.createDataFormat().getFormat(fmt);
        this.formats.put(fmt, String.valueOf(format));
        return format;
    }
}

