/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.excel;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.poi.hssf.util.HSSFColor;

public class ExcelColor {
    private static Hashtable colorMap = new Hashtable();
    private static Hashtable indexHash;

    static {
        new HSSFColor();
        indexHash = HSSFColor.getIndexHash();
    }

    private static short addColor2Map(int argbColor) {
        Color c = new Color(argbColor, true);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int index = 0;
        double min = Double.MAX_VALUE;
        Iterator it = indexHash.keySet().iterator();
        while (it.hasNext()) {
            Integer obj = (Integer)it.next();
            int key = obj;
            short[] rgb = ((HSSFColor)indexHash.get(obj)).getTriplet();
            double tmp = Math.pow(r - rgb[0], 2.0) + Math.pow(g - rgb[1], 2.0) + Math.pow(b - rgb[2], 2.0);
            if (!(tmp < min)) continue;
            min = tmp;
            index = key;
            if (min == 0.0) break;
        }
        colorMap.put(String.valueOf(argbColor), String.valueOf(index));
        return (short)index;
    }

    public static short transColor(int argb) {
        Object obj = colorMap.get(String.valueOf(argb));
        if (obj == null) {
            return ExcelColor.addColor2Map(argb);
        }
        return Short.valueOf((String)obj);
    }

    public static Integer getColorInReport(short index, Color defaultColor) {
        if (index < 8) {
            index = (short)(index + 8);
        }
        HSSFColor c = null;
        Integer key = Integer.valueOf(String.valueOf(index));
        c = (HSSFColor)indexHash.get(key);
        if (c == null) {
            return new Integer(defaultColor.getRGB());
        }
        short[] rgb = c.getTriplet();
        int color = new Color(rgb[0], rgb[1], rgb[2]).getRGB();
        return new Integer(color);
    }
}

