/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.excel;

import com.runqian.base.util.LLObject;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.view.excel.ExcelCell;
import java.awt.Image;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.apache.poi.hssf.record.ImageRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;

public class ExcelReport {
    private HSSFWorkbook wb;
    private PageBuilder pb;
    private ArrayList pages = new ArrayList();
    private int picIndex = 1;
    private int dispRatio = -1;

    public ExcelReport() {
        this.wb = new HSSFWorkbook();
    }

    public ExcelReport(PageBuilder pb) throws Exception {
        this.wb = new HSSFWorkbook();
        this.pb = pb;
        this.initPages();
    }

    public ExcelReport(CellSet cs, int pageWidth, int pageHeight, int columns) throws Exception {
        this.wb = new HSSFWorkbook();
        this.pb = new PageBuilder(cs, pageWidth, pageHeight, columns);
        this.initPages();
    }

    public ExcelReport(CellSet cs, int pageWidth, int pageHeight, int columns, String pwd) throws Exception {
        this.wb = new HSSFWorkbook();
        if (pwd != null && pwd.trim().length() > 0) {
            this.wb.setFilePassword(pwd.trim());
        }
        this.pb = new PageBuilder(cs, pageWidth, pageHeight, columns);
        this.initPages();
    }

    public ExcelReport(CellSet cs) throws Exception {
        this(cs, 0, 0, 0);
    }

    public ExcelReport(CellSet cs, int pageWidth) throws Exception {
        this(cs, pageWidth, 0, 0);
    }

    public ExcelReport(CellSet cs, int pageWidth, int pageHeight) throws Exception {
        this(cs, pageWidth, pageHeight, 0);
    }

    public void setDispRatio(int ratio) {
        this.dispRatio = ratio;
    }

    public void createWorkbook() throws Exception {
        block18: {
            int pagerStyle;
            CellSetParser parser;
            ArrayList styles;
            ArrayList fonts;
            Hashtable formats;
            block17: {
                formats = new Hashtable();
                fonts = new ArrayList();
                styles = new ArrayList();
                parser = new CellSetParser((CellSet)this.pages.get(0));
                pagerStyle = parser.getPagerStyle();
                if (pagerStyle != CellPropertyDefine.CPS_PAPER) break block17;
                int page = 0;
                while (page < this.pages.size()) {
                    HSSFSheet sheet = this.wb.createSheet("page " + (page + 1));
                    CellSet cellset = (CellSet)this.pages.get(page);
                    int[] rowCols = this.createAPage(sheet, cellset, fonts, styles, (short)0, (short)0, formats);
                    this.setRepeatRowsCols(this.wb, page, cellset);
                    if (this.setUserUnitName(sheet, rowCols[0] + 1)) {
                        rowCols[0] = rowCols[0] + 1;
                    }
                    this.wb.setPrintArea(page, 0, rowCols[1], 0, rowCols[0]);
                    ++page;
                }
                break block18;
            }
            if (pagerStyle != CellPropertyDefine.CPS_ROWS) break block18;
            int layoutRow = parser.getLayoutRows();
            int layoutCol = parser.getLayoutCols();
            int layoutIndex = parser.getLayoutIndex();
            int pageCount = (int)Math.ceil((double)this.pages.size() * 1.0 / (double)(layoutRow * layoutCol));
            int page = 0;
            while (page < pageCount) {
                int thisPageRows = -1;
                int thisPageCols = -1;
                HSSFSheet sheet = this.wb.createSheet("page " + (page + 1));
                int startPage = page * layoutRow * layoutCol;
                CellSet[] css = new CellSet[layoutRow * layoutCol];
                int i = 0;
                while (i < css.length) {
                    CellSet cs = null;
                    try {
                        cs = (CellSet)this.pages.get(startPage + i);
                    }
                    catch (Exception e) {
                        break;
                    }
                    css[i] = cs;
                    ++i;
                }
                short areaRows = this.lookupMaxRows(css);
                short areaCols = this.lookupMaxCols(css);
                short firstRow = 0;
                int i2 = 1;
                while (i2 <= layoutRow) {
                    if (i2 > 1) {
                        firstRow = (short)(firstRow + (areaRows + 1));
                    }
                    short firstCol = 0;
                    int j = 1;
                    while (j <= layoutCol) {
                        if (j > 1) {
                            firstCol = (short)(firstCol + (areaCols + 1));
                        }
                        int index = 0;
                        if (layoutIndex == CellPropertyDefine.CPLI_ROW) {
                            index = (i2 - 1) * layoutCol + (j - 1);
                        } else if (layoutIndex == CellPropertyDefine.CPLI_COL) {
                            index = (j - 1) * layoutRow + (i2 - 1);
                        }
                        if (css[index] != null) {
                            int[] rowCols = this.createAPage(sheet, css[index], fonts, styles, firstRow, firstCol, formats);
                            if (rowCols[0] > thisPageRows) {
                                thisPageRows = rowCols[0];
                            }
                            if (rowCols[1] > thisPageCols) {
                                thisPageCols = rowCols[1];
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
                if (this.setUserUnitName(sheet, thisPageRows + 1)) {
                    ++thisPageRows;
                }
                this.wb.setPrintArea(page, 0, thisPageCols, 0, thisPageRows);
                ++page;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] createAPage(HSSFSheet sheet, CellSet cellset, ArrayList fonts, ArrayList styles, short firstRow, short firstCol, Hashtable formats) {
        ExcelCell cell = null;
        CellSetParser parser = new CellSetParser(cellset);
        int rowCount = parser.getRowCount();
        int colCount = parser.getColCount();
        int startRow = 1;
        int endRow = rowCount - 1;
        Field pageHeader = parser.getPageHeader();
        Field pageFooter = parser.getPageFooter();
        if (pageHeader != null) {
            startRow = pageHeader.getEndRow() + 1;
        }
        if (pageFooter != null) {
            endRow = pageFooter.getStartRow() - 1;
        }
        short currCol = firstCol;
        int col = 1;
        while (col < colCount) {
            short colWidth = (short)parser.getColWidth(col);
            colWidth = (short)((double)colWidth * 46.44);
            if (!parser.isColVisible(col)) {
                colWidth = 0;
            }
            short s = currCol;
            currCol = (short)(s + 1);
            sheet.setColumnWidth(s, colWidth);
            ++col;
        }
        short currRow = firstRow;
        int row = startRow;
        while (row <= endRow) {
            HSSFRow hssfRow = sheet.createRow((int)currRow);
            short rowHeight = (short)parser.getRowHeight(row);
            rowHeight = (short)((double)rowHeight * 20.64);
            if (!parser.isRowVisible(row)) {
                rowHeight = 0;
            }
            hssfRow.setHeight(rowHeight);
            currCol = firstCol;
            int col2 = 1;
            while (col2 < colCount) {
                block39: {
                    block36: {
                        Object obj;
                        block40: {
                            HSSFCell hssfCell;
                            block37: {
                                block38: {
                                    cell = new ExcelCell(cellset, row, col2, this.wb, fonts, styles, formats);
                                    hssfCell = hssfRow.createCell(currCol);
                                    hssfCell.setCellStyle(cell.getStyle());
                                    if (!parser.isMerged(row, col2)) break block37;
                                    if (parser.isMergedFirstCell(row, col2)) break block38;
                                    currCol = (short)(currCol + 1);
                                    break block39;
                                }
                                int colSpan = parser.getColSpan(row, col2, true);
                                int rowSpan = parser.getRowSpan(row, col2, true);
                                sheet.addMergedRegion(new Region((int)currRow, currCol, currRow + rowSpan - 1, (short)(currCol + colSpan - 1)));
                            }
                            if (!cell.isVisible()) break block36;
                            obj = parser.getPropertyValue(row, col2, 4101);
                            int dataType = Integer.parseInt(obj.toString());
                            if (dataType != CellPropertyDefine.CDT_TEXT) break block40;
                            hssfCell.setEncoding((short)1);
                            String s = cell.getText();
                            s = s.trim();
                            if (s.startsWith("0") && !s.startsWith("0.")) {
                                hssfCell.setCellValue(s);
                                break block36;
                            } else {
                                try {
                                    double d = Double.parseDouble(s);
                                    if (d <= 9.9999999999999E13) {
                                        hssfCell.setCellType(0);
                                        hssfCell.setCellValue(d);
                                        break block36;
                                    }
                                    hssfCell.setCellValue(s);
                                }
                                catch (Throwable e) {
                                    String s1 = cell.getValue().trim();
                                    if (s1.equals(s)) {
                                        hssfCell.setCellValue(s);
                                        break block36;
                                    }
                                    try {
                                        double d = Double.parseDouble(s1);
                                        String fmt = (String)parser.getPropertyValue(row, col2, 4104);
                                        if (fmt != null && fmt.trim().length() > 0) {
                                            hssfCell.setCellType(0);
                                            hssfCell.setCellValue(d);
                                            break block36;
                                        } else {
                                            hssfCell.setCellValue(s);
                                        }
                                        break block36;
                                    }
                                    catch (Throwable e1) {
                                        hssfCell.setCellValue(s);
                                    }
                                }
                            }
                            break block36;
                        }
                        obj = parser.getPropertyValue(row, col2, 4102);
                        if (obj != null && obj instanceof byte[]) {
                            Image image = new ImageIcon((byte[])obj).getImage();
                            int colSpan = parser.getColSpan(row, col2, true);
                            int rowSpan = parser.getRowSpan(row, col2, true);
                            ImageRecord record = new ImageRecord(image, this.picIndex++, (int)currRow, (int)currCol, currRow + rowSpan - 1, currCol + colSpan - 1);
                            sheet.insertImageRecords(record);
                        }
                    }
                    currCol = (short)(currCol + 1);
                }
                ++col2;
            }
            if (currRow == 0) {
                HSSFCell endCell = hssfRow.createCell(currCol);
                endCell.setCellValue(" ");
            }
            if (currRow == -1) break;
            currRow = (short)(currRow + 1);
            ++row;
        }
        if (this.dispRatio < 0) {
            sheet.setZoom(3, 4);
        } else {
            sheet.setZoom(this.dispRatio, 100);
        }
        HSSFPrintSetup hps = sheet.getPrintSetup();
        hps.setHResolution((short)600);
        int paper = CellPropertyDefine.CPS_A4;
        try {
            paper = (Integer)parser.getPropertyValue(0, 0, 1201);
        }
        catch (Exception rowHeight) {
            // empty catch block
        }
        int pageSize = 9;
        if (paper == CellPropertyDefine.CPS_A5) {
            pageSize = 11;
        } else if (paper == CellPropertyDefine.CPS_A2) {
            pageSize = 66;
        } else if (paper == CellPropertyDefine.CPS_A3) {
            pageSize = 8;
        } else if (paper == CellPropertyDefine.CPS_B4) {
            pageSize = 32;
        } else if (paper == CellPropertyDefine.CPS_B5) {
            pageSize = 34;
        }
        hps.setPaperSize((short)pageSize);
        int orientation = CellPropertyDefine.CPO_PORTRAIT;
        try {
            orientation = (Integer)parser.getPropertyValue(0, 0, 1202);
        }
        catch (Exception hssfCell) {
            // empty catch block
        }
        if (orientation == CellPropertyDefine.CPO_LANDSCAPE) {
            hps.setLandscape(true);
        } else {
            hps.setLandscape(false);
        }
        this.setMargin(parser, sheet, 1208, (short)3);
        this.setMargin(parser, sheet, 1205, (short)0);
        this.setMargin(parser, sheet, 1206, (short)1);
        this.setMargin(parser, sheet, 1207, (short)2);
        int[] rowCols = new int[]{currRow - 1, currCol - 1};
        return rowCols;
    }

    private void initPages() {
        try {
            int i = 0;
            while (i < this.pb.getPageCount()) {
                this.pages.add(this.pb.getPage(i + 1));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPage(CellSet cs) {
        this.pages.add(cs);
    }

    public void out(OutputStream os) throws Exception {
        this.createWorkbook();
        this.wb.write(os);
    }

    private short lookupMaxRows(CellSet[] css) {
        short rows = 0;
        int i = 0;
        while (i < css.length) {
            if (css[i] != null) {
                CellSetParser parser = new CellSetParser(css[i]);
                int startRow = 1;
                int endRow = parser.getRowCount() - 1;
                Field pageHeader = parser.getPageHeader();
                Field pageFooter = parser.getPageFooter();
                if (pageHeader != null) {
                    startRow = pageHeader.getEndRow() + 1;
                }
                if (pageFooter != null) {
                    endRow = pageFooter.getStartRow() - 1;
                }
                short tmpRows = 0;
                int row = startRow;
                while (row <= endRow) {
                    if (parser.isRowVisible(row)) {
                        tmpRows = (short)(tmpRows + 1);
                    }
                    ++row;
                }
                if (tmpRows > rows) {
                    rows = tmpRows;
                }
            }
            ++i;
        }
        return rows;
    }

    private short lookupMaxCols(CellSet[] css) {
        short cols = 0;
        int i = 0;
        while (i < css.length) {
            if (css[i] != null) {
                CellSetParser parser = new CellSetParser(css[i]);
                short tmpCols = 0;
                int col = 1;
                while (col < parser.getColCount()) {
                    if (parser.isColVisible(col)) {
                        tmpCols = (short)(tmpCols + 1);
                    }
                    ++col;
                }
                if (tmpCols > cols) {
                    cols = tmpCols;
                }
            }
            ++i;
        }
        return cols;
    }

    private void setMargin(CellSetParser parser, HSSFSheet sheet, int key, short location) {
        int margin = 19;
        try {
            margin = (Integer)parser.getPropertyValue(0, 0, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double margin1 = (double)margin / 25.4;
        sheet.setMargin(location, margin1);
    }

    private void setRepeatRowsCols(HSSFWorkbook wb, int page, CellSet cellset) {
        CellSetParser csp = new CellSetParser(cellset);
        int startRow = -1;
        int startCol = -1;
        int endRow = -1;
        int endCol = -1;
        Field left = csp.getLeftHeader();
        if (left != null) {
            startCol = left.getStartColumn() - 1;
            endCol = left.getEndColumn() - 1;
        }
        Field title = csp.getTitleField();
        Field top = csp.getTopHeader();
        if (title != null && top != null) {
            startRow = 0;
            endRow = top.getEndRow() - title.getStartRow();
        } else if (title == null && top != null) {
            startRow = 0;
            endRow = top.getEndRow() - top.getStartRow();
        } else if (title != null && top == null) {
            startRow = 0;
            endRow = title.getEndRow() - title.getStartRow();
        }
        wb.setRepeatingRowsAndColumns(page, startCol, endCol, startRow, endRow);
    }

    private boolean setUserUnitName(HSSFSheet sheet, int row) throws Exception {
        LLObject llo = LLObject.get();
        if (llo == null) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u8bc1\u4e66\u6587\u4ef6!");
        }
        if (llo.check() > 0) {
            return false;
        }
        String s = llo.getCustName();
        HSSFRow r = sheet.createRow(row);
        HSSFCell cell = r.createCell((short)0);
        cell.setEncoding((short)1);
        cell.setCellValue(s);
        return true;
    }
}

