/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.html;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.view.html.HtmlColor;
import com.runqian.report.view.html.HtmlEncoder;

public class HtmlCell {
    private CellSet cs;
    private int row;
    private int col;
    private String appmap;
    private boolean isParamCell = false;
    private float scale = 1.0f;
    private boolean inNS = false;

    public HtmlCell(CellSet cs, int row, int col, String appmap, float scale) {
        this.cs = cs;
        this.row = row;
        this.col = col;
        this.appmap = appmap;
        this.scale = scale;
    }

    void setIsParamCell(boolean isParamCell) {
        this.isParamCell = isParamCell;
    }

    void setInNS(boolean b) {
        this.inNS = b;
    }

    public String getStyle() {
        CellSetParser parser = new CellSetParser(this.cs);
        StringBuffer sb = new StringBuffer(500);
        int i = 0;
        while (i < CellPropertyDefine.prop_keys.length) {
            int key = CellPropertyDefine.prop_keys[i];
            Object pvalue = this.cs.getPropertyValue(this.row, this.col, key);
            if (!(pvalue == null || this.row == 0 && key != 2101 || this.col == 0 && this.row != 0 && key != 3101)) {
                switch (key) {
                    case 4201: {
                        sb.append("text-align:");
                        int align = (Integer)pvalue;
                        if (align == CellPropertyDefine.CA_LEFT) {
                            sb.append("left;");
                        }
                        if (align == CellPropertyDefine.CA_CENTER) {
                            sb.append("center;");
                        }
                        if (align != CellPropertyDefine.CA_RIGHT) break;
                        sb.append("right;");
                        break;
                    }
                    case 4202: {
                        sb.append("vertical-align:");
                        int valign = (Integer)pvalue;
                        if (valign == CellPropertyDefine.CVA_TOP) {
                            sb.append("top;");
                        }
                        if (valign == CellPropertyDefine.CVA_MIDDLE) {
                            sb.append("middle;");
                        }
                        if (valign != CellPropertyDefine.CVA_BOTTOM) break;
                        sb.append("bottom;");
                        break;
                    }
                    case 4203: {
                        int cellindent = Math.round((float)Integer.parseInt(pvalue.toString()) * this.scale);
                        int xalign = (Integer)this.cs.getPropertyValue(this.row, this.col, 4201);
                        if (xalign == CellPropertyDefine.CA_CENTER) {
                            sb.append("padding-left:").append(cellindent).append("px;");
                            sb.append("padding-right:").append(cellindent).append("px;");
                            break;
                        }
                        if (xalign == CellPropertyDefine.CA_LEFT) {
                            sb.append("padding-left:").append(cellindent).append("px;");
                            break;
                        }
                        if (xalign != CellPropertyDefine.CA_RIGHT) break;
                        sb.append("padding-right:").append(cellindent).append("px;");
                        break;
                    }
                    case 4301: {
                        if (!this.isValidString(pvalue)) break;
                        sb.append("font-family:").append(pvalue.toString()).append(";");
                        break;
                    }
                    case 4302: {
                        int fontsize = (int)((float)Integer.parseInt(pvalue.toString()) * this.scale);
                        sb.append("font-size:").append(fontsize).append("px;");
                        break;
                    }
                    case 4303: {
                        String color = new HtmlColor(Integer.parseInt(pvalue.toString())).toString();
                        sb.append("color:").append(color).append(";");
                        break;
                    }
                    case 4304: {
                        String bold = (Boolean)pvalue != false ? "bold" : "normal";
                        sb.append("font-weight:").append(bold).append(";");
                        break;
                    }
                    case 4305: {
                        String italic = (Boolean)pvalue != false ? "italic" : "normal";
                        sb.append("font-style:").append(italic).append(";");
                        break;
                    }
                    case 4306: {
                        String ul = (Boolean)pvalue != false ? "underline" : "none";
                        sb.append("text-decoration:").append(ul).append(";");
                        break;
                    }
                    case 4401: {
                        if (this.isParamCell) break;
                        sb.append("border-left-style:").append(this.getBorderStyle(pvalue)).append(";");
                        break;
                    }
                    case 4402: {
                        if (this.isParamCell) break;
                        sb.append("border-left-width:").append(this.getBorderWidth(pvalue.toString())).append("px;");
                        break;
                    }
                    case 4403: {
                        if (this.isParamCell) break;
                        String lbColor = new HtmlColor(Integer.parseInt(pvalue.toString())).toString();
                        sb.append("border-left-color:").append(lbColor).append(";");
                        break;
                    }
                    case 4407: {
                        if (this.isParamCell) break;
                        sb.append("border-top-style:").append(this.getBorderStyle(pvalue)).append(";");
                        break;
                    }
                    case 4408: {
                        if (this.isParamCell) break;
                        sb.append("border-top-width:").append(this.getBorderWidth(pvalue.toString())).append("px;");
                        break;
                    }
                    case 4409: {
                        if (this.isParamCell) break;
                        String tbColor = new HtmlColor(Integer.parseInt(pvalue.toString())).toString();
                        sb.append("border-top-color:").append(tbColor).append(";");
                        break;
                    }
                    case 4404: {
                        if (this.isParamCell) break;
                        if (parser.isMerged(this.row, this.col)) {
                            pvalue = this.cs.getPropertyValue(this.row, parser.getMergedEndCol(this.row, this.col), key);
                        }
                        sb.append("border-right-style:").append(this.getBorderStyle(pvalue)).append(";");
                        break;
                    }
                    case 4405: {
                        if (this.isParamCell) break;
                        if (parser.isMerged(this.row, this.col)) {
                            pvalue = this.cs.getPropertyValue(this.row, parser.getMergedEndCol(this.row, this.col), key);
                        }
                        sb.append("border-right-width:").append(this.getBorderWidth(pvalue.toString())).append("px;");
                        break;
                    }
                    case 4406: {
                        if (this.isParamCell) break;
                        if (parser.isMerged(this.row, this.col)) {
                            pvalue = this.cs.getPropertyValue(this.row, parser.getMergedEndCol(this.row, this.col), key);
                        }
                        String rbColor = new HtmlColor(Integer.parseInt(pvalue.toString())).toString();
                        sb.append("border-right-color:").append(rbColor).append(";");
                        break;
                    }
                    case 4410: {
                        if (this.isParamCell) break;
                        if (parser.isMerged(this.row, this.col)) {
                            pvalue = this.cs.getPropertyValue(parser.getMergedEndRow(this.row, this.col), this.col, key);
                        }
                        sb.append("border-bottom-style:").append(this.getBorderStyle(pvalue)).append(";");
                        break;
                    }
                    case 4411: {
                        if (this.isParamCell) break;
                        if (parser.isMerged(this.row, this.col)) {
                            pvalue = this.cs.getPropertyValue(parser.getMergedEndRow(this.row, this.col), this.col, key);
                        }
                        sb.append("border-bottom-width:").append(this.getBorderWidth(pvalue.toString())).append("px;");
                        break;
                    }
                    case 4412: {
                        if (this.isParamCell) break;
                        if (parser.isMerged(this.row, this.col)) {
                            pvalue = this.cs.getPropertyValue(parser.getMergedEndRow(this.row, this.col), this.col, key);
                        }
                        String bbColor = new HtmlColor(Integer.parseInt(pvalue.toString())).toString();
                        sb.append("border-bottom-color:").append(bbColor).append(";");
                        break;
                    }
                    case 4413: {
                        String bkColor = new HtmlColor(Integer.parseInt(pvalue.toString())).toString();
                        sb.append("background-color:").append(bkColor).append(";");
                        break;
                    }
                    case 2101: {
                        int w = parser.getColWidth(this.col, this.scale);
                        if (this.row == 0 && this.col == 0) {
                            w = 0;
                            int k = 1;
                            while (k < parser.getColCount()) {
                                if (parser.isColVisible(k)) {
                                    w += parser.getColWidth(k, this.scale);
                                }
                                ++k;
                            }
                        } else if (!this.inNS) {
                            int ww;
                            int indent = 0;
                            int k = 1;
                            while (k < this.cs.getRow()) {
                                int n = (Integer)this.cs.getPropertyValue(k, this.col, 4203);
                                n = Math.round((float)n * this.scale);
                                int cellAlign = (Integer)this.cs.getPropertyValue(k, this.col, 4201);
                                if (cellAlign == CellPropertyDefine.CA_CENTER) {
                                    n *= 2;
                                }
                                if (n > indent) {
                                    indent = n;
                                }
                                ++k;
                            }
                            if (indent > 0 && (ww = w - indent) > 0) {
                                w = ww;
                            }
                        }
                        sb.append("width:").append(w).append("px;");
                        break;
                    }
                    case 3101: {
                        int h = parser.getRowHeight(this.row, this.scale);
                        sb.append("height:").append(h).append("px;");
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    boolean isVisible() {
        Object obj = this.cs.getPropertyValue(this.row, this.col, 4106);
        if (obj == null) {
            return true;
        }
        return (Boolean)obj;
    }

    String getLink() {
        Object obj = this.cs.getPropertyValue(this.row, this.col, 4701);
        if (obj == null) {
            return null;
        }
        String link = obj.toString();
        if (link.trim().length() == 0) {
            return null;
        }
        if (link.indexOf(":") > 0) {
            return link;
        }
        if (!link.startsWith("/")) {
            link = "/" + link;
        }
        link = String.valueOf(this.appmap) + link;
        return link;
    }

    String getText() {
        Integer type = (Integer)this.cs.getPropertyValue(this.row, this.col, 4101);
        if (type.intValue() == CellPropertyDefine.CDT_HTML.intValue()) {
            return this.getValue();
        }
        String text = (String)this.cs.getPropertyValue(this.row, this.col, 4105);
        if (text == null || text.length() == 0) {
            text = this.getValue();
        }
        return HtmlEncoder.encode(text);
    }

    String getValue() {
        Object obj = this.cs.getPropertyValue(this.row, this.col, 4102);
        if (obj == null) {
            return "";
        }
        String text = obj.toString();
        if (obj instanceof byte[]) {
            try {
                text = new String((byte[])obj, "GBK");
            }
            catch (Exception e) {
                text = new String((byte[])obj);
            }
        }
        if (text.trim().length() == 0) {
            text = "";
        }
        return text;
    }

    private boolean isValidString(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.toString().length() != 0;
    }

    private String getBorderWidth(String w) {
        double dw = Double.parseDouble(w);
        long iw = Math.round(dw);
        return String.valueOf(iw);
    }

    private String getBorderStyle(Object prop) {
        if (prop.toString().equals(CellPropertyDefine.CBS_SOLID.toString())) {
            return "solid";
        }
        if (prop.toString().equals(CellPropertyDefine.CBS_NONE.toString())) {
            return "none";
        }
        if (prop.toString().equals(CellPropertyDefine.CBS_DOUBLE.toString())) {
            return "double";
        }
        if (prop.toString().equals(CellPropertyDefine.CBS_DOTTED.toString())) {
            return "dotted";
        }
        if (prop.toString().equals(CellPropertyDefine.CBS_DASHED.toString())) {
            return "dashed";
        }
        return "solid";
    }
}

