/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.html;

import com.runqian.base.module.DataSetConfig;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Segment;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.DBTypes;
import com.runqian.base.util.LLObject;
import com.runqian.base.util.Sentence;
import com.runqian.base.util.StringUtils;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.dataset.SQLDataSetFactory;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.input.ExcelNotation;
import com.runqian.report.input.InputUtils;
import com.runqian.report.input.UpdateProp;
import com.runqian.report.usermodel.Env;
import com.runqian.report.usermodel.ReportDefine;
import com.runqian.report.view.ParamsPool;
import com.runqian.report.view.ReportCalculator;
import com.runqian.report.view.ServletMappings;
import com.runqian.report.view.html.GraphPool;
import com.runqian.report.view.html.HtmlCell;
import com.runqian.report.view.html.Tree;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.swing.ImageIcon;

public class HtmlReport {
    private CellSet cellset;
    private String name;
    private String appmap;
    private String appRoot = null;
    private boolean inNS = false;
    private HttpServletRequest request;
    private File picFileDir = null;
    private String htmlFileName;
    private boolean isInput;
    private HashSet keyCells;
    private HashSet updatableCells;
    private Hashtable styles = new Hashtable();
    private static int generateCounts = 0;
    private float scale = 1.0f;
    boolean isSub = false;
    private String paramsId;
    private Writer pw;

    public HtmlReport(CellSet cs, String sName, String appmap, HttpServletRequest request, boolean isInput) throws Exception {
        this.cellset = cs;
        this.appmap = appmap;
        this.request = request;
        this.name = sName;
        this.isInput = isInput;
        if (isInput) {
            InputUtils.resolvePropertyRef(cs, 4801, 4802, "\u66f4\u65b0\u8bbe\u7f6e\u5f15\u7528");
            this.keyCells = InputUtils.getKeyCells(cs);
            this.updatableCells = InputUtils.getUpdatableCells(cs);
            InputUtils.resolvePropertyRef(this.cellset, 4803, 4808, "\u6570\u636e\u6709\u6548\u6027\u5f15\u7528");
        }
    }

    public HtmlReport(CellSet cs, String sName, String appmap, HttpServletRequest request) throws Exception {
        this(cs, sName, appmap, request, false);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    void setIsSub(boolean b) {
        this.isSub = b;
    }

    public void setPrintWriter(Writer pw) {
        this.pw = pw;
    }

    public void setParamsId(String paramsId) {
        this.paramsId = paramsId;
    }

    public void setAppRoot(String approot) {
        this.appRoot = approot;
    }

    public void setInNS(boolean b) {
        this.inNS = b;
    }

    public String generateHtml() throws Exception {
        HtmlCell cell = null;
        if (this.request != null) {
            this.appRoot = String.valueOf(this.request.getScheme()) + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
        } else {
            this.htmlFileName = this.name;
            this.name = "report1";
        }
        StringBuffer sb = new StringBuffer(1000);
        this.append(sb, "<table id=\"" + this.name + "\" cellSpacing=0 cellPadding=0");
        cell = new HtmlCell(this.cellset, 0, 0, this.appmap, this.scale);
        this.append(sb, " style=\"" + cell.getStyle());
        this.append(sb, "border-collapse:collapse\">\n");
        CellSetParser parser = new CellSetParser(this.cellset);
        boolean drillable = (Boolean)parser.getPropertyValue(0, 0, 1109);
        if (this.isInput) {
            drillable = false;
        }
        if (this.request != null && this.request.getHeader("user-agent").toLowerCase().indexOf("msie") < 0) {
            this.inNS = true;
        }
        int rowCount = parser.getRowCount();
        int colCount = parser.getColCount();
        int startRow = 1;
        int endRow = rowCount - 1;
        Field pageHeader = parser.getPageHeader();
        Field pageFooter = parser.getPageFooter();
        if (pageHeader != null) {
            startRow = pageHeader.getEndRow() + 1;
        }
        if (pageFooter != null) {
            endRow = pageFooter.getStartRow() - 1;
        }
        this.append(sb, "\t<colgroup>\n");
        int col = 1;
        while (col < colCount) {
            if (parser.isColVisible(col)) {
                cell = new HtmlCell(this.cellset, 0, col, this.appmap, this.scale);
                cell.setInNS(this.inNS);
                this.append(sb, "\t\t<col id=\"" + this.name + "_col" + col + "\" style=\"" + cell.getStyle());
                this.append(sb, "\"></col>\n");
            }
            ++col;
        }
        this.append(sb, "\t</colgroup>\n");
        boolean selectJSImported = false;
        boolean calendarJSImported = false;
        boolean treeJSImported = false;
        boolean needCreateTree = false;
        String treeName = "";
        Hashtable<String, String> editConfigs = new Hashtable<String, String>();
        Hashtable<String, String> treeConfigs = new Hashtable<String, String>();
        int row = startRow;
        while (row <= endRow) {
            cell = new HtmlCell(this.cellset, row, 0, this.appmap, this.scale);
            this.append(sb, "\t<tr ");
            if (drillable) {
                this.append(sb, "id=\"" + this.name + "_row" + row + "\" ");
            }
            this.append(sb, "height=" + parser.getRowHeight(row, this.scale) + " style=\"" + cell.getStyle());
            if (!parser.isRowVisible(row)) {
                this.append(sb, ";display:none");
            }
            this.append(sb, "\">\n");
            int col2 = 1;
            while (col2 < colCount) {
                block131: {
                    int height;
                    int width;
                    block132: {
                        block130: {
                            this.addVar(sb, row, col2, parser);
                            width = parser.getColWidth(col2, this.scale);
                            height = parser.getRowHeight(row, this.scale);
                            if (!parser.isMerged(row, col2)) break block130;
                            if (!parser.isMergedFirstCell(row, col2)) break block131;
                            this.append(sb, "\t\t<td");
                            int colSpan = parser.getColSpan(row, col2, false);
                            int rowSpan = parser.getRowSpan(row, col2, true);
                            if (this.inNS) {
                                rowSpan = parser.getRowSpan(row, col2, false);
                            }
                            if (rowSpan > 1) {
                                this.append(sb, " rowSpan=" + rowSpan);
                                if (drillable) {
                                    this.append(sb, " tempRowSpan=" + rowSpan);
                                }
                                height = parser.getMergedHeight(row, col2, false, this.scale);
                            }
                            if (colSpan > 1) {
                                this.append(sb, " colSpan=" + colSpan);
                                width = parser.getMergedWidth(row, col2, false, this.scale);
                            }
                            break block132;
                        }
                        this.append(sb, "\t\t<td");
                    }
                    cell = new HtmlCell(this.cellset, row, col2, this.appmap, this.scale);
                    Object obj = parser.getPropertyValue(row, col2, 4101);
                    if (obj == null) {
                        obj = CellPropertyDefine.CDT_TEXT;
                    }
                    int dataType = Integer.parseInt(obj.toString());
                    int editStyle = 1;
                    String editConfig = "";
                    String cellName = ExcelNotation.toExcelNotation(row, col2);
                    String cellJSValid = "";
                    if (this.isInput) {
                        Segment seg;
                        String tmpCfg;
                        this.append(sb, " id=\"" + this.name + "_" + cellName + "\"");
                        editStyle = (Integer)this.cellset.getPropertyValue(row, col2, 4805);
                        editConfig = (String)parser.getPropertyValue(row, col2, 4806);
                        if (editConfig == null) {
                            editConfig = "";
                        }
                        if (editStyle == CellPropertyDefine.CES_LISTBOX && (tmpCfg = (seg = new Segment(editConfig)).get("list")) != null && tmpCfg.trim().length() > 0) {
                            editConfig = tmpCfg;
                        }
                        String dwEditConfig = "";
                        if (editStyle == CellPropertyDefine.CES_DATAWIN) {
                            editConfig = HtmlReport.getDataWinEditConfig(editConfig, row, col2, this.cellset, this.paramsId);
                            boolean configExists = false;
                            Iterator it = editConfigs.keySet().iterator();
                            while (it.hasNext()) {
                                String refCell = (String)it.next();
                                String tmpCfg2 = (String)editConfigs.get(refCell);
                                if (!editConfig.equals(tmpCfg2)) continue;
                                dwEditConfig = "ref:" + this.name + "_" + refCell;
                                configExists = true;
                                break;
                            }
                            if (!configExists) {
                                editConfigs.put(cellName, editConfig);
                            }
                        }
                        boolean writable = (Boolean)this.cellset.getPropertyValue(row, col2, 4804);
                        if (dataType == CellPropertyDefine.CDT_TEXT) {
                            if (editStyle == CellPropertyDefine.CES_CHECKBOX || editStyle == CellPropertyDefine.CES_RADIO || editStyle == CellPropertyDefine.CES_CALENDAR || editStyle == CellPropertyDefine.CES_TREE || editStyle == CellPropertyDefine.CES_UPLOAD) {
                                writable = false;
                            }
                            boolean needValue = false;
                            if (writable) {
                                obj = parser.getPropertyValue(row, col2, 4107);
                                if (obj != null && ((Boolean)obj).booleanValue()) {
                                    editStyle = 0;
                                }
                                needValue = true;
                                this.append(sb, " writable=true");
                                this.append(sb, " editStyle=\"" + editStyle + "\"");
                                if (editConfig != null && editConfig.trim().length() > 0 && (editStyle == 2 || editStyle == 3)) {
                                    if (dwEditConfig.trim().length() == 0) {
                                        this.append(sb, " editConfig=\"" + editConfig + "\"");
                                    } else {
                                        this.append(sb, " editConfig=\"" + dwEditConfig + "\"");
                                    }
                                }
                                int inputDataType = (Integer)parser.getPropertyValue(row, col2, 4810);
                                this.append(sb, " inputDataType=\"" + inputDataType + "\"");
                            }
                            if (this.isKeyCell(cellName)) {
                                needValue = true;
                                this.append(sb, " keyCell=true originValue='" + cell.getValue() + "'");
                            }
                            if (this.isUpdatableCell(cellName)) {
                                needValue = true;
                                this.append(sb, " updatable=true");
                            }
                            if (editStyle == 7) {
                                needValue = false;
                            }
                            this.append(sb, " value='" + cell.getValue() + "'");
                            try {
                                Double.parseDouble(cell.getValue());
                                String dispStyle = (String)parser.getPropertyValue(row, col2, 4104);
                                if (dispStyle != null && dispStyle.trim().length() > 0) {
                                    dispStyle = dispStyle.trim();
                                    int digits = 0;
                                    int digitPos = dispStyle.indexOf(".");
                                    if (digitPos > 0) {
                                        digits = dispStyle.length() - digitPos - 1;
                                    }
                                    this.append(sb, " digits=\"" + digits + "\"");
                                }
                            }
                            catch (Exception dispStyle) {
                                // empty catch block
                            }
                            if ((cellJSValid = InputUtils.createCheckValidScript(this.cellset, this.name, row, col2, this.inNS)).length() > 0) {
                                this.append(sb, " dataValid=\"" + this.name + "_" + row + "_" + col2 + "_dataValid()\"");
                            }
                            if (editStyle == 6 && ((Boolean)parser.getPropertyValue(row, col2, 4804)).booleanValue()) {
                                String vType;
                                Segment seg_6 = new Segment(editConfig);
                                String sepa = seg_6.get("separator");
                                if (sepa.equals("\u65e0")) {
                                    sepa = "";
                                }
                                vType = (vType = seg_6.get("valueType")).equals("\u5e74\u6708\u65e5") ? "day" : (vType.equals("\u5e74\u6708") ? "month" : "year");
                                if (this.inNS) {
                                    this.append(sb, " onclick=\"_hideEditor( event ); _runqianCalendar().separator='" + sepa + "'; _runqianCalendar().type= '" + vType + "';_showCalendar( event )\" noeditor=yes");
                                } else {
                                    this.append(sb, " onclick=\"_hideEditor(); _runqianCalendar.separator='" + sepa + "'; _runqianCalendar.type= '" + vType + "';_showCalendar()\" noeditor=yes");
                                }
                            }
                            if (editStyle == 8 && ((Boolean)parser.getPropertyValue(row, col2, 4804)).booleanValue()) {
                                String treeKey = this.toTreeKey(editConfig);
                                treeName = (String)treeConfigs.get(treeKey);
                                if (treeName == null) {
                                    treeName = "tree_" + this.name + row + col2;
                                    treeConfigs.put(treeKey, treeName);
                                    needCreateTree = true;
                                } else {
                                    needCreateTree = false;
                                }
                                if (this.inNS) {
                                    this.append(sb, " onclick=\"_hideEditor( event ); tree_show( this, '" + treeName + "' )\" noeditor=yes");
                                } else {
                                    this.append(sb, " onclick=\"_hideEditor(); tree_show( this, '" + treeName + "' )\"  noeditor=yes");
                                }
                            }
                        }
                        if (editStyle == 7) {
                            String ext;
                            String update;
                            this.append(sb, " onmousemove=\"_uploadPrompt( 'block', event )\" onmouseout=\"_uploadPrompt( 'none', event )\"");
                            if (this.inNS) {
                                this.append(sb, " onclick=\"_hideEditor( event )\"");
                            }
                            if ((update = (String)parser.getPropertyValue(row, col2, 4801)) == null || update.trim().length() == 0) {
                                update = "";
                            }
                            UpdateProp up = new UpdateProp(update);
                            String keyValues = "";
                            String updateValues = "";
                            if (up.getUpdateCount() > 0) {
                                keyValues = up.getKeyValue(0);
                                updateValues = up.getUpdateValue(0);
                            }
                            if ((ext = editConfig) == null || ext.trim().length() == 0) {
                                ext = "*.*";
                            }
                            this.append(sb, " ondblclick=\"_uploadFile( '" + this.appRoot + ServletMappings.getMapping("com.runqian.report.input.SelectUploadFile") + "', " + "document.getElementById( '" + this.name + "' ), '" + update + "', '" + keyValues + "', '" + updateValues + "', '" + ext + "' )\"");
                        } else if (this.inNS) {
                            if (writable) {
                                this.append(sb, " onclick=\"_displayEditor( event )\"");
                            } else if (editStyle != 6) {
                                this.append(sb, " onclick=\"_hideEditor( event )\"");
                            }
                        }
                    }
                    String hideRows = null;
                    if (drillable && (hideRows = (String)parser.getPropertyValue(row, col2, 4704)) != null && hideRows.trim().length() > 0) {
                        if (!parser.isMerged(row, col2)) {
                            hideRows = null;
                        } else {
                            this.append(sb, " id=\"" + this.name + "_" + cellName + "\"");
                            this.append(sb, " hideRows=\"" + hideRows + "\"");
                        }
                    }
                    String style = cell.getStyle();
                    String styleClass = "";
                    boolean styleExist = false;
                    Iterator it = this.styles.keySet().iterator();
                    while (it.hasNext()) {
                        styleClass = (String)it.next();
                        String tmp = (String)this.styles.get(styleClass);
                        if (!style.equals(tmp)) continue;
                        styleExist = true;
                        break;
                    }
                    if (!styleExist) {
                        styleClass = String.valueOf(this.name) + "_" + row + "_" + col2;
                        this.styles.put(styleClass, style);
                    }
                    this.append(sb, " class=\"" + styleClass + "\"");
                    if (!parser.isColVisible(col2)) {
                        this.append(sb, " style=\"display:none\"");
                    }
                    this.append(sb, ">");
                    if (cell.isVisible()) {
                        String graphId;
                        String link;
                        if (drillable && hideRows != null && hideRows.trim().length() > 0) {
                            this.append(sb, "<img src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.report.view.html.GraphServlet") + "?" + "picFile=%2Fcom%2Frunqian%2Freport%2Fview%2Fhtml%2Ffolded.gif\" onclick=\"_extendCell( document.getElementById( '" + this.name + "_" + cellName + "' ) )\" style=\"cursor:hand;vertical-align:bottom\">");
                            this.append(sb, "<img src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.report.view.html.GraphServlet") + "?" + "picFile=%2Fcom%2Frunqian%2Freport%2Fview%2Fhtml%2Fextended.gif\" onclick=\"_foldCell( document.getElementById( '" + this.name + "_" + cellName + "' ) )\" style=\"cursor:hand;vertical-align:bottom\">");
                        }
                        if ((link = cell.getLink()) != null) {
                            this.append(sb, "<a href=\"" + link + "\"");
                            obj = parser.getPropertyValue(row, col2, 4703);
                            if (obj != null && obj.toString().trim().length() > 0) {
                                this.append(sb, " target=\"" + obj.toString().trim() + "\"");
                            }
                            this.append(sb, ">");
                        }
                        if (dataType == CellPropertyDefine.CDT_TEXT || dataType == CellPropertyDefine.CDT_HTML) {
                            if (this.isInput) {
                                switch (editStyle) {
                                    case 2: 
                                    case 3: {
                                        this.append(sb, this.lookupDisplay(editConfig, cell.getValue()));
                                        break;
                                    }
                                    case 4: {
                                        boolean cbWritable;
                                        String cbValue = cell.getValue();
                                        if (editConfig == null || editConfig.trim().length() == 0) {
                                            throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col2 + "\u5217\u7684\u590d\u9009\u6846\u7f16\u8f91\u65b9\u5f0f\u6ca1\u6709\u914d\u7f6e\uff01");
                                        }
                                        Segment segs = new Segment(editConfig);
                                        String cbText = segs.get("text");
                                        String cbLocation = segs.get("align");
                                        String cbOn = segs.get("on");
                                        String cbOff = segs.get("off");
                                        StringBuffer cbsb = new StringBuffer();
                                        if (this.inNS) {
                                            cbsb.append("<input type=checkbox onclick=\"if( this.checked ) document.getElementById( '" + this.name + "_" + cellName + "' ).attributes.getNamedItem( 'value' ).value = '" + cbOn + "';else document.getElementById( '" + this.name + "_" + cellName + "' ).attributes.getNamedItem( 'value' ).value='" + cbOff + "';\"");
                                        } else {
                                            cbsb.append("<input type=checkbox onclick=\"if( this.checked ) " + this.name + "_" + cellName + ".value = '" + cbOn + "';else " + this.name + "_" + cellName + ".value='" + cbOff + "';\"");
                                        }
                                        if (cbValue.equals(cbOn)) {
                                            cbsb.append(" checked");
                                        }
                                        if (!(cbWritable = ((Boolean)this.cellset.getPropertyValue(row, col2, 4804)).booleanValue())) {
                                            cbsb.append(" disabled");
                                        }
                                        cbsb.append(">");
                                        if (cbText != null && cbText.trim().length() > 0) {
                                            if (cbLocation.equals("0")) {
                                                cbsb.insert(0, cbText);
                                            } else {
                                                cbsb.append(cbText);
                                            }
                                        }
                                        this.append(sb, cbsb.toString());
                                        break;
                                    }
                                    default: {
                                        String text = cell.getText();
                                        obj = parser.getPropertyValue(row, col2, 4107);
                                        if (obj != null && ((Boolean)obj).booleanValue()) {
                                            text = StringUtils.replace(text, "&nbsp;", " ");
                                        }
                                        if (editStyle == 7 && text.length() == 0) {
                                            text = "\u53cc\u51fb\u4e0a\u8f7d\u6587\u4ef6";
                                        }
                                        this.append(sb, text);
                                        break;
                                    }
                                }
                            } else {
                                String text = cell.getText();
                                obj = parser.getPropertyValue(row, col2, 4107);
                                if (obj != null && ((Boolean)obj).booleanValue()) {
                                    text = StringUtils.replace(text, "&nbsp;", " ");
                                }
                                this.append(sb, text);
                            }
                        } else if (dataType == CellPropertyDefine.CDT_SUBREPORT) {
                            obj = parser.getPropertyValue(row, col2, 4102);
                            if (obj != null && obj instanceof CellSet) {
                                try {
                                    HtmlReport sub = new HtmlReport((CellSet)obj, String.valueOf(this.name) + "_sub_" + row + "_" + col2, this.appmap, this.request);
                                    sub.setIsSub(true);
                                    sub.setScale(this.scale);
                                    this.append(sb, sub.generateHtml());
                                }
                                catch (Exception sub) {}
                            }
                        } else if (this.appRoot == null) {
                            obj = parser.getPropertyValue(row, col2, 4102);
                            if (obj != null && obj instanceof byte[]) {
                                try {
                                    String fmt;
                                    if (this.picFileDir == null) {
                                        String tmp = StringUtils.replace(this.htmlFileName, "\\", "/");
                                        int pos = tmp.lastIndexOf("/");
                                        if (pos >= 0) {
                                            this.htmlFileName = tmp.substring(pos + 1);
                                            tmp = tmp.substring(0, pos + 1);
                                            this.picFileDir = new File(String.valueOf(tmp) + this.htmlFileName + "_files");
                                        }
                                        if (!this.picFileDir.exists()) {
                                            this.picFileDir.mkdirs();
                                        }
                                    }
                                    if ((fmt = (String)parser.getPropertyValue(row, col2, 4104)) == null) {
                                        fmt = "jpg";
                                    }
                                    if (!((fmt = fmt.toLowerCase()).equals("jpg") || fmt.equals("gif") || fmt.equals("png"))) {
                                        fmt = "jpg";
                                    }
                                    String picName = String.valueOf(this.htmlFileName) + "_" + row + "_" + col2 + "." + fmt;
                                    File picFile = new File(this.picFileDir, picName);
                                    FileOutputStream fos = new FileOutputStream(picFile);
                                    fos.write((byte[])obj);
                                    fos.flush();
                                    fos.close();
                                    Image im = new ImageIcon((byte[])obj).getImage();
                                    int ww = im.getWidth(null);
                                    int hh = im.getHeight(null);
                                    ww = (int)Math.floor((float)ww * this.scale);
                                    hh = (int)Math.floor((float)hh * this.scale);
                                    this.append(sb, "<img src=\"" + this.htmlFileName + "_files/" + picName + "\" border=no width=" + ww + " height=" + hh + ">");
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e.getMessage());
                                }
                            }
                        } else if (dataType == CellPropertyDefine.CDT_GRAPH) {
                            obj = parser.getPropertyValue(row, col2, 4102);
                            if (obj != null) {
                                graphId = GraphPool.createParamsId();
                                GraphPool.put(graphId, (byte[])obj);
                                String fmt = (String)parser.getPropertyValue(row, col2, 4104);
                                if (fmt == null) {
                                    fmt = "jpg";
                                }
                                if (fmt.equalsIgnoreCase("png") && this.isIE55(this.request)) {
                                    this.append(sb, "<DIV ID=\"pngGraph\" STYLE=\"");
                                    this.append(sb, "position:relative;width:" + width + "px;height:" + height + "px;");
                                    this.append(sb, "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='");
                                    this.append(sb, String.valueOf(this.appRoot) + ServletMappings.getMapping("com.runqian.report.view.html.GraphServlet") + "?graphId=" + graphId + "&time=" + new Date().getTime());
                                    this.append(sb, "', sizingMethod='image');\" ></DIV>");
                                } else {
                                    this.append(sb, "<img src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.report.view.html.GraphServlet") + "?graphId=" + graphId + "&time=" + new Date().getTime() + "\" width=" + width + " height=" + height + " border=no" + " usemap=\"#" + graphId + "\" ismap>");
                                }
                                String graphLink = (String)parser.getPropertyValue(row, col2, 4105);
                                if (graphLink != null) {
                                    graphLink = Sentence.replace(graphLink, "{APPMAP}", this.appRoot, 19);
                                    this.append(sb, "<map name=\"" + graphId + "\">");
                                    this.append(sb, graphLink);
                                    this.append(sb, "</map>");
                                }
                            }
                        } else {
                            obj = parser.getPropertyValue(row, col2, 4102);
                            if (obj instanceof byte[]) {
                                graphId = GraphPool.createParamsId();
                                GraphPool.put(graphId, (byte[])obj);
                                Image im = new ImageIcon((byte[])obj).getImage();
                                int ww = im.getWidth(null);
                                int hh = im.getHeight(null);
                                ww = (int)Math.floor((float)ww * this.scale);
                                hh = (int)Math.floor((float)hh * this.scale);
                                this.append(sb, "<img src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.report.view.html.GraphServlet") + "?graphId=" + graphId + "&time=" + new Date().getTime() + "\" width=" + ww + " height=" + hh + " border=no>");
                            } else if (this.isInput && editStyle == 7 && (obj == null || obj.toString().length() == 0) && dataType == CellPropertyDefine.CDT_PIC_DB) {
                                this.append(sb, "<img src=\"\" alt=\"\u53cc\u51fb\u4e0a\u8f7d\u56fe\u50cf\" width=" + width + " height=" + height + " border=no>");
                            }
                        }
                        if (link != null) {
                            this.append(sb, "</a>");
                        }
                    }
                    this.append(sb, "</td>\n");
                    if (this.isInput && (editStyle == 2 || editStyle == 3) && !selectJSImported) {
                        String selectJs = "select.js";
                        if (this.inNS) {
                            selectJs = "select4ns.js";
                        }
                        this.append(sb, "<script language=javascript src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + selectJs + "\"></script>\n");
                        this.append(sb, "<script language=javascript>var " + this.name + "_listBox = SS_write( \"<select style='width:10px'><option></option></select>\" );</script>\n");
                        selectJSImported = true;
                    }
                    if (this.isInput && editStyle == 6 && !calendarJSImported) {
                        String calendarJs = "calendar.js";
                        if (this.inNS) {
                            calendarJs = "calendar4ns.js";
                        }
                        this.append(sb, "<script language=javascript src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + calendarJs + "\"></script>\n");
                        this.append(sb, "<script language=javascript>_createRunqianCalendar();</script>\n");
                        calendarJSImported = true;
                    }
                    if (this.isInput && editStyle == 8) {
                        if (!treeJSImported) {
                            String treeJs = "tree.js";
                            this.append(sb, "<script language=javascript src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + treeJs + "\"></script>\n");
                            treeJSImported = true;
                        }
                        if (needCreateTree) {
                            Hashtable params = null;
                            if (this.paramsId != null) {
                                params = ParamsPool.get(this.paramsId);
                            }
                            Tree tree = new Tree(editConfig, params, this.appRoot, treeName);
                            tree.setInNS(this.inNS);
                            this.append(sb, tree.generateHtml());
                            this.append(sb, "<script language=javascript>if( document.body.runqianTrees ) document.body.runqianTrees += ',' + '" + treeName + "'; else document.body.runqianTrees = '" + treeName + "';</script>\n");
                        }
                    }
                    if (this.isInput && cellJSValid.length() > 0) {
                        this.append(sb, "<script language=javascript>\n");
                        this.append(sb, "\tfunction " + this.name + "_" + row + "_" + col2 + "_dataValid() {\n");
                        this.append(sb, cellJSValid);
                        this.append(sb, "\t}\n");
                        this.append(sb, "</script>\n");
                    }
                }
                ++col2;
            }
            this.append(sb, "\t</tr>\n");
            ++row;
        }
        this.append(sb, "</table>");
        if (this.isInput) {
            this.append(sb, "<script language=javascript>\n");
            this.append(sb, "\tfunction " + this.name + "_autoCalc() {\n");
            this.append(sb, InputUtils.createAutoCalcScript(this.cellset, this.name, this.inNS));
            this.append(sb, "\t}\n\n");
            this.append(sb, "\t" + this.name + "_autoCalc();\n");
            this.append(sb, "\tfunction " + this.name + "_checkValid() {\n");
            this.append(sb, InputUtils.createCheckValidScript(this.cellset, this.name, this.inNS));
            this.append(sb, "\t}\n\n");
            this.append(sb, "\t_initInput( document.getElementById( '" + this.name + "' ) );\n");
            this.append(sb, "\t_formatData( document.getElementById( '" + this.name + "' ) );\n");
            this.append(sb, "</script>\n");
        }
        if (drillable) {
            String olapJs = "olap.js";
            if (this.inNS) {
                olapJs = "olap4ns.js";
            }
            this.append(sb, "<script language=javascript src=\"" + this.appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Fview%2Fhtml%2F" + olapJs + "\"></script>\n");
            this.append(sb, "<script language=javascript>_initDrill( document.getElementById( '" + this.name + "' ) );</script>\n");
        }
        String css = "<style>\n";
        Iterator it = this.styles.keySet().iterator();
        while (it.hasNext()) {
            String cls = (String)it.next();
            css = String.valueOf(css) + "\t." + cls + " { " + (String)this.styles.get(cls) + " }\n";
        }
        css = String.valueOf(css) + "</style>\n";
        String userUnitName = "";
        if (!this.isSub && generateCounts % 5 == 0) {
            userUnitName = "\u6da6\u4e7e\u62a5\u8868 -- \u8bd5\u7528\u7248";
            try {
                userUnitName = LLObject.get().getCustName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            userUnitName = "<div style=\"color:#E3E6F2; font-family:\u5b8b\u4f53; font-size:9pt; padding-top:3px\">" + userUnitName + "</div>\n";
        }
        if (!this.isSub) {
            ++generateCounts;
        }
        if (this.pw != null) {
            this.pw.write(String.valueOf(css) + userUnitName);
            this.pw.flush();
            return "";
        }
        return String.valueOf(css) + sb.toString() + userUnitName;
    }

    private void addVar(StringBuffer sb, int row, int col, CellSetParser parser) {
        if (parser.isMerged(row, col) && !parser.isMergedFirstCell(row, col)) {
            return;
        }
        Object obj = parser.getPropertyValue(row, col, 4702);
        if (obj == null) {
            return;
        }
        String varName = obj.toString().trim();
        if (varName.length() == 0) {
            return;
        }
        obj = parser.getPropertyValue(row, col, 4101);
        if (obj != null && Integer.parseInt(obj.toString()) != CellPropertyDefine.CDT_TEXT) {
            return;
        }
        obj = parser.getPropertyValue(row, col, 4102);
        String varValue = "";
        if (obj != null) {
            varValue = obj.toString().trim();
        }
        if (this.request != null) {
            this.request.setAttribute(varName, (Object)varValue);
        }
    }

    private boolean isIE55(HttpServletRequest request) {
        int pos1;
        if (request == null) {
            return false;
        }
        String tmp = request.getHeader("user-agent");
        int pos = tmp.indexOf("MSIE");
        if (pos > 0 && (pos1 = tmp.indexOf(";", pos + 4)) > 0) {
            double version = Double.parseDouble(tmp.substring(pos + 4, pos1).trim());
            return version >= 5.5;
        }
        return false;
    }

    private boolean isKeyCell(String cell) {
        return this.keyCells.contains(cell);
    }

    private boolean isUpdatableCell(String cell) {
        return this.updatableCells.contains(cell);
    }

    private String lookupDisplay(String editConfig, String value) {
        if (editConfig == null) {
            return value;
        }
        ArgumentTokenizer at = new ArgumentTokenizer(editConfig, ';');
        while (at.hasMoreTokens()) {
            ArgumentTokenizer at1 = new ArgumentTokenizer(at.nextToken(), ',');
            String tmp = at1.nextToken();
            if (tmp == null || tmp.trim().length() == 0 || !(tmp = tmp.trim()).equals(value)) continue;
            return at1.nextToken();
        }
        return value;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getDataWinEditConfig(String cfg, int row, int col, CellSet cs, String paramsId) throws Exception {
        block39: {
            block38: {
                configs = "";
                segs = new Segment(cfg);
                tbl = segs.get("tbl");
                if (tbl == null) throw new Exception("\u5355\u5143\u683c" + ExcelNotation.toExcelNotation(row, col) + "\u7684\u4e0b\u62c9\u6570\u636e\u7a97\u53e3\u7f16\u8f91\u914d\u7f6e\u9519\u8bef\uff0c\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\uff01");
                if (tbl.trim().length() == 0) {
                    throw new Exception("\u5355\u5143\u683c" + ExcelNotation.toExcelNotation(row, col) + "\u7684\u4e0b\u62c9\u6570\u636e\u7a97\u53e3\u7f16\u8f91\u914d\u7f6e\u9519\u8bef\uff0c\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\uff01");
                }
                code = segs.get("code");
                if (code == null) throw new Exception("\u5355\u5143\u683c" + ExcelNotation.toExcelNotation(row, col) + "\u7684\u4e0b\u62c9\u6570\u636e\u7a97\u53e3\u7f16\u8f91\u914d\u7f6e\u9519\u8bef\uff0c\u6ca1\u6709\u6307\u5b9a\u771f\u5b9e\u503c\u5217\uff01");
                if (code.trim().length() == 0) {
                    throw new Exception("\u5355\u5143\u683c" + ExcelNotation.toExcelNotation(row, col) + "\u7684\u4e0b\u62c9\u6570\u636e\u7a97\u53e3\u7f16\u8f91\u914d\u7f6e\u9519\u8bef\uff0c\u6ca1\u6709\u6307\u5b9a\u771f\u5b9e\u503c\u5217\uff01");
                }
                disp = segs.get("disp");
                if (disp == null || disp.trim().length() == 0) {
                    disp = code;
                }
                where = segs.get("where");
                ds = segs.get("ds");
                sql = "select distinct " + code + " from " + tbl;
                con = null;
                stmt = null;
                stmt1 = null;
                try {
                    dbo = ReportCalculator.getDBObject(ds);
                    con = dbo.getConnection();
                    encode = dbo.getDbEncode();
                    sqlcode = dbo.getSqlEncode();
                    stmt = con.createStatement();
                    rs1 = stmt.executeQuery(String.valueOf(sql) + " where 1=0");
                    codeType = rs1.getMetaData().getColumnType(1);
                    if (where != null && where.trim().length() > 0) {
                        sql = String.valueOf(sql) + " where " + where;
                        exps = segs.get("where_para_names");
                        types = segs.get("where_para_types");
                        dsc = new DataSetConfig();
                        if (sqlcode) {
                            sql = new String(sql.getBytes("GBK"), encode);
                        }
                        dsc.setSQL(sql);
                        dsc.setSQLType(1);
                        dsc.setName("ds_dropDown");
                        exps_array = new Section(exps, true).toStringArray();
                        types_array = HtmlReport.getIntArray(new Section(types, true).toStringArray());
                        dsc.setSQLArguments(exps_array, types_array);
                        dsc.setDataSourceName(ds);
                        rd = new ReportDefine(cs);
                        env = new Env(rd);
                        params = null;
                        if (paramsId != null && paramsId.trim().length() > 0 && (params = ParamsPool.get(paramsId)) == null) {
                            throw new Exception("\u7f13\u5b58\u7684\u62a5\u8868\u53c2\u6570\u6216\u62a5\u8868\u5b8f\u56e0\u8d85\u65f6\u5df2\u88ab\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u53c2\u6570\u53ca\u5b8f!");
                        }
                        ReportCalculator.putParamMacro2Env(rd, params, env);
                        if (ds == null || ds.trim().length() == 0) {
                            env.setConnection(con, encode, dbo.getDbType());
                        } else {
                            env.setConnection(ds, con, encode, dbo.getDbType());
                        }
                        ecs = new ExtCellSet(env);
                        p = new Properties();
                        p.put("dsc", dsc);
                        p.put("ecs", ecs);
                        factory = new SQLDataSetFactory();
                        factory.setProperties(p);
                        dataset = factory.getDataSet(env);
                        sql = "select " + code + ", " + disp + " from " + tbl + " where " + where;
                        if (sqlcode) {
                            sql = new String(sql.getBytes("GBK"), encode);
                        }
                        dsc.setSQL(sql);
                        dispDs = factory.getDataSet(env);
                        rows = dataset.getAllRowCount();
                        i = 1;
                        while (i <= rows) {
                            oCode = dataset.getData(i, 1);
                            if (oCode != null && (scode = oCode.toString().trim()).length() != 0) {
                                sdisp = "";
                                j = 1;
                                while (j <= dispDs.getAllRowCount()) {
                                    oCode = dispDs.getData(j, 1);
                                    if (oCode != null && oCode.toString().trim().equals(scode) && (oDisp = dispDs.getData(j, 2)) != null) {
                                        sdisp = oDisp.toString().trim();
                                        break;
                                    }
                                    ++j;
                                }
                                if (sdisp.length() != 0) {
                                    scode = new String(scode.getBytes(encode), "GBK");
                                    sdisp = new String(sdisp.getBytes(encode), "GBK");
                                    if (configs.length() > 0) {
                                        configs = String.valueOf(configs) + ";";
                                    }
                                    configs = String.valueOf(configs) + scode + "," + sdisp;
                                }
                            }
                            ++i;
                        }
                    } else {
                        stmt1 = con.createStatement();
                        if (sqlcode) {
                            sql = new String(sql.getBytes("GBK"), encode);
                        }
                        rs = stmt.executeQuery(sql);
                        while (rs.next()) {
                            scode = rs.getString(1);
                            if (scode == null) continue;
                            scode = new String(scode.trim().getBytes(encode), "GBK");
                            sql = "select " + disp + " from " + tbl + " where " + code + " = " + DBTypes.getDBConst(dbo.getDbType(), scode, codeType);
                            if (sqlcode) {
                                sql = new String(sql.getBytes("GBK"), encode);
                            }
                            if (!(rs1 = stmt1.executeQuery(sql)).next() || (sdisp = rs1.getString(1)) == null || sdisp.trim().length() == 0) continue;
                            sdisp = new String(sdisp.trim().getBytes(encode), "GBK");
                            if (configs.length() > 0) {
                                configs = String.valueOf(configs) + ";";
                            }
                            configs = String.valueOf(configs) + scode + "," + sdisp;
                        }
                    }
                }
                catch (Throwable var42_44) {
                    var41_45 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception var43_47) {
                        // empty catch block
                    }
                    try {
                        if (stmt1 != null) {
                            stmt1.close();
                        }
                    }
                    catch (Exception var43_47) {
                        // empty catch block
                    }
                    try {
                        if (con == null) throw var42_44;
                        if (con.isClosed() != false) throw var42_44;
                        con.close();
                        throw var42_44;
                    }
                    catch (Exception var43_47) {
                        // empty catch block
                    }
                    throw var42_44;
                }
                {
                    var41_46 = null;
                }
                ** try [egrp 1[TRYBLOCK] [2 : 1358->1373)] { 
lbl134:
                // 1 sources

                if (stmt != null) {
                    stmt.close();
                }
                break block38;
lbl137:
                // 1 sources

                catch (Exception var43_48) {
                    // empty catch block
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 1375->1390)] { 
lbl141:
            // 1 sources

            if (stmt1 != null) {
                stmt1.close();
            }
            break block39;
lbl144:
            // 1 sources

            catch (Exception var43_48) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var43_48) {
            return configs;
        }
        if (con == null) return configs;
        if (con.isClosed() != false) return configs;
        con.close();
        return configs;
    }

    public static int[] getIntArray(String[] sa) {
        int[] ia = new int[sa.length];
        int i = 0;
        while (i < sa.length) {
            ia[i] = Integer.parseInt(sa[i]);
            ++i;
        }
        return ia;
    }

    private void append(StringBuffer sb, String s) throws Exception {
        if (this.pw == null) {
            sb.append(s);
        } else {
            this.pw.write(s);
        }
    }

    private String toTreeKey(String cfg) {
        String s = "";
        Segment seg = new Segment(cfg);
        s = String.valueOf(seg.get("name")) + seg.get("w") + seg.get("h") + seg.get("loop") + seg.get("leafonly");
        int count = Integer.parseInt(seg.get("count"));
        s = String.valueOf(s) + count;
        int i = 0;
        while (i < count) {
            s = String.valueOf(s) + seg.get("ds" + i);
            s = String.valueOf(s) + seg.get("table" + i);
            s = String.valueOf(s) + seg.get("code" + i);
            s = String.valueOf(s) + seg.get("disp" + i);
            s = String.valueOf(s) + seg.get("where" + i);
            ++i;
        }
        return s;
    }
}

