/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.html;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.view.html.HtmlReport;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class HtmlReportPage {
    private ArrayList cellsets;
    private int pageNo;
    private String name;
    private String appmap;
    private HttpServletRequest request;
    private float scale = 1.0f;
    private Writer pw;

    public HtmlReportPage(String name, ArrayList cellsets, int pageNo, String appmap, HttpServletRequest request) {
        this.cellsets = cellsets;
        this.pageNo = pageNo;
        this.name = name;
        this.appmap = appmap;
        this.request = request;
    }

    public HtmlReportPage(String name, CellSet[] css, int pageNo, String appmap, HttpServletRequest request) {
        this.pageNo = pageNo;
        this.name = name;
        this.appmap = appmap;
        this.request = request;
        this.cellsets = new ArrayList();
        int i = 0;
        while (i < css.length) {
            this.cellsets.add(css[i]);
            ++i;
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPrintWriter(Writer pw) {
        this.pw = pw;
    }

    public String generateHtml() throws Exception {
        CellSetParser csp = new CellSetParser((CellSet)this.cellsets.get(0));
        int pagerStyle = csp.getPagerStyle();
        if (pagerStyle == CellPropertyDefine.CPS_PAPER) {
            CellSet cs = (CellSet)this.cellsets.get(this.pageNo - 1);
            HtmlReport report = new HtmlReport(cs, this.name, this.appmap, this.request);
            report.setScale(this.scale);
            report.setPrintWriter(this.pw);
            return report.generateHtml();
        }
        if (pagerStyle == CellPropertyDefine.CPS_ROWS) {
            int layoutRow = csp.getLayoutRows();
            int layoutCol = csp.getLayoutCols();
            int startPage = (this.pageNo - 1) * layoutRow * layoutCol;
            String[] pages = new String[layoutRow * layoutCol];
            int i = 0;
            while (i < pages.length) {
                CellSet cs = null;
                try {
                    cs = (CellSet)this.cellsets.get(startPage + i);
                }
                catch (Exception e) {
                    break;
                }
                if (cs != null) {
                    HtmlReport report = new HtmlReport(cs, String.valueOf(this.name) + "_" + (i + 1), this.appmap, this.request);
                    report.setScale(this.scale);
                    report.setPrintWriter(this.pw);
                    pages[i] = report.generateHtml();
                }
                ++i;
            }
            int layoutIndex = csp.getLayoutIndex();
            String html = "<table id=\"" + this.name + "\">\n";
            int i2 = 1;
            while (i2 <= layoutRow) {
                if (i2 > 1) {
                    html = String.valueOf(html) + "<tr height=10><td colspan=" + (layoutCol * 2 - 1) + "></td></tr>\n";
                }
                html = String.valueOf(html) + "<tr>\n";
                int j = 1;
                while (j <= layoutCol) {
                    if (j > 1) {
                        html = String.valueOf(html) + "<td width=10></td>\n";
                    }
                    int index = 0;
                    if (layoutIndex == CellPropertyDefine.CPLI_ROW) {
                        index = (i2 - 1) * layoutCol + (j - 1);
                    } else if (layoutIndex == CellPropertyDefine.CPLI_COL) {
                        index = (j - 1) * layoutRow + (i2 - 1);
                    }
                    html = String.valueOf(html) + "<td>";
                    if (pages[index] != null) {
                        html = String.valueOf(html) + pages[index];
                    }
                    html = String.valueOf(html) + "</td>";
                    ++j;
                }
                html = String.valueOf(html) + "</tr>\n";
                ++i2;
            }
            html = String.valueOf(html) + "</table>";
            return html;
        }
        return "";
    }
}

