/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.html;

import com.runqian.base.tool.Segment;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.StringUtils;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.input.InputUtils;
import com.runqian.report.view.ParamsPool;
import com.runqian.report.view.ServletMappings;
import com.runqian.report.view.html.GraphPool;
import com.runqian.report.view.html.HtmlCell;
import com.runqian.report.view.html.HtmlReport;
import com.runqian.report.view.html.Tree;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class ParamForm {
    private CellSet cellset;
    private String name;
    private HttpServletRequest request;
    private String paramsId;

    public ParamForm(CellSet cs, String name, HttpServletRequest request) throws Exception {
        this.cellset = cs;
        this.request = request;
        this.name = name;
        int type = (Integer)cs.getPropertyValue(0, 0, 1101);
        if (type != CellPropertyDefine.CRT_INPUT) {
            throw new Exception("\u8bf7\u7528\u201c\u586b\u62a5/\u53c2\u6570\u8868\u5355\u201d\u7c7b\u578b\u7684\u62a5\u8868\u6765\u751f\u6210\u53c2\u6570\u8f93\u5165\u8868\u5355\uff01");
        }
        InputUtils.resolvePropertyRef(this.cellset, 4803, 4808, "\u6570\u636e\u6709\u6548\u6027\u5f15\u7528");
    }

    public void setParamsId(String paramsId) {
        this.paramsId = paramsId;
    }

    public String generateHtml() throws Exception {
        HtmlCell cell = null;
        String appRoot = "";
        if (this.request != null) {
            appRoot = String.valueOf(this.request.getScheme()) + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
        }
        String appmap = this.request.getContextPath();
        boolean inNS = this.request.getHeader("user-agent").toLowerCase().indexOf("msie") < 0;
        StringBuffer sb = new StringBuffer(1000);
        String paramJs = "paramForm.js";
        sb.append("<script language=javascript src=\"" + appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Fview%2Fhtml%2F" + paramJs + "\"></script>\n");
        sb.append("<table cellSpacing=0 cellPadding=0");
        cell = new HtmlCell(this.cellset, 0, 0, appmap, 1.0f);
        sb.append(" style=\"").append(cell.getStyle());
        sb.append("border-collapse:collapse\">\n");
        CellSetParser parser = new CellSetParser(this.cellset);
        int rowCount = parser.getRowCount();
        int colCount = parser.getColCount();
        int startRow = 1;
        int endRow = rowCount - 1;
        Field pageHeader = parser.getPageHeader();
        Field pageFooter = parser.getPageFooter();
        if (pageHeader != null) {
            startRow = pageHeader.getEndRow() + 1;
        }
        if (pageFooter != null) {
            endRow = pageFooter.getStartRow() - 1;
        }
        sb.append("\t<colgroup>\n");
        int col = 1;
        while (col < colCount) {
            if (parser.isColVisible(col)) {
                cell = new HtmlCell(this.cellset, 0, col, appmap, 1.0f);
                cell.setInNS(inNS);
                sb.append("\t\t<col id=\"" + this.name + "_col" + col + "\" style=\"").append(cell.getStyle());
                sb.append("\"></col>\n");
            }
            ++col;
        }
        sb.append("\t</colgroup>\n");
        boolean calendarJSImported = false;
        boolean treeJSImported = false;
        int row = startRow;
        while (row <= endRow) {
            cell = new HtmlCell(this.cellset, row, 0, appmap, 1.0f);
            sb.append("\t<tr ");
            sb.append("height=" + parser.getRowHeight(row) + " style=\"").append(cell.getStyle());
            if (!parser.isRowVisible(row)) {
                sb.append(";display:none");
            }
            sb.append("\">\n");
            int col2 = 1;
            while (col2 < colCount) {
                block61: {
                    int height;
                    int width;
                    block62: {
                        block60: {
                            width = parser.getColWidth(col2);
                            height = parser.getRowHeight(row);
                            if (!parser.isMerged(row, col2)) break block60;
                            if (!parser.isMergedFirstCell(row, col2)) break block61;
                            sb.append("\t\t<td");
                            int colSpan = parser.getColSpan(row, col2, false);
                            int rowSpan = parser.getRowSpan(row, col2, true);
                            if (rowSpan > 1) {
                                sb.append(" rowSpan=").append(rowSpan);
                                height = parser.getMergedHeight(row, col2, false);
                            }
                            if (colSpan > 1) {
                                sb.append(" colSpan=").append(colSpan);
                                width = parser.getMergedWidth(row, col2, false);
                            }
                            break block62;
                        }
                        sb.append("\t\t<td");
                    }
                    boolean writable = (Boolean)this.cellset.getPropertyValue(row, col2, 4804);
                    String paramName = (String)parser.getPropertyValue(row, col2, 4702);
                    boolean isParamCell = writable && paramName != null && paramName.trim().length() > 0;
                    cell = new HtmlCell(this.cellset, row, col2, appmap, 1.0f);
                    cell.setIsParamCell(isParamCell);
                    Object obj = parser.getPropertyValue(row, col2, 4101);
                    if (obj == null) {
                        obj = CellPropertyDefine.CDT_TEXT;
                    }
                    int dataType = Integer.parseInt(obj.toString());
                    int editStyle = 1;
                    String editConfig = "";
                    sb.append(" style=\"");
                    if (!isParamCell) {
                        sb.append(cell.getStyle());
                        if (!parser.isColVisible(col2)) {
                            sb.append(";display:none\"");
                        }
                    }
                    sb.append("\">");
                    if (cell.isVisible()) {
                        String link = cell.getLink();
                        if (link != null) {
                            sb.append("<a href=\"").append(link).append("\"");
                            obj = parser.getPropertyValue(row, col2, 4703);
                            if (obj != null && obj.toString().trim().length() > 0) {
                                sb.append(" target=\"").append(obj.toString().trim()).append("\"");
                            }
                            sb.append(">");
                        }
                        if (dataType == CellPropertyDefine.CDT_TEXT || dataType == CellPropertyDefine.CDT_HTML) {
                            if (isParamCell) {
                                String tmpCfg;
                                Segment seg;
                                editStyle = (Integer)this.cellset.getPropertyValue(row, col2, 4805);
                                editConfig = (String)parser.getPropertyValue(row, col2, 4806);
                                if (editConfig == null) {
                                    editConfig = "";
                                }
                                boolean isMultiSelect = false;
                                if (editStyle == CellPropertyDefine.CES_LISTBOX) {
                                    seg = new Segment(editConfig);
                                    tmpCfg = seg.get("list");
                                    if (tmpCfg != null && tmpCfg.trim().length() > 0) {
                                        editConfig = tmpCfg;
                                    }
                                    if ((tmpCfg = seg.get("multiselect")) != null && tmpCfg.equals("1")) {
                                        isMultiSelect = true;
                                    }
                                }
                                if (editStyle == CellPropertyDefine.CES_DATAWIN) {
                                    seg = new Segment(editConfig);
                                    tmpCfg = seg.get("multiselect");
                                    if (tmpCfg != null && tmpCfg.equals("1")) {
                                        isMultiSelect = true;
                                    }
                                    editConfig = HtmlReport.getDataWinEditConfig(editConfig, row, col2, this.cellset, this.paramsId);
                                }
                                String paramValue = "";
                                String reportParamsId = this.request.getParameter("reportParamsId");
                                Hashtable params = null;
                                if (reportParamsId != null) {
                                    params = ParamsPool.get(reportParamsId);
                                    if (params == null) {
                                        throw new Exception("\u7f13\u5b58\u7684\u62a5\u8868\u53c2\u6570\u6216\u62a5\u8868\u5b8f\u56e0\u8d85\u65f6\u5df2\u88ab\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u53c2\u6570\u53ca\u5b8f!");
                                    }
                                    paramValue = (String)params.get(paramName);
                                }
                                if (paramValue == null || paramValue.trim().length() == 0) {
                                    paramValue = this.request.getParameter(paramName);
                                }
                                if (paramValue == null || paramValue.trim().length() == 0) {
                                    paramValue = cell.getText();
                                }
                                switch (editStyle) {
                                    case 2: 
                                    case 3: {
                                        String optionValue;
                                        String tmpConfig;
                                        ArgumentTokenizer at;
                                        if (isMultiSelect) {
                                            sb.append("<select name=multi_").append(paramName).append(" id=multi_").append(paramName).append(" size=2 multiple style=\"").append(cell.getStyle());
                                            sb.append(";width:").append(width).append("px;height:").append(height).append("px\" onclick=\"_hideDropDown();\">\n");
                                            at = new ArgumentTokenizer(editConfig, ';');
                                            while (at.hasMoreTokens()) {
                                                tmpConfig = at.nextToken();
                                                int tmpPos = tmpConfig.indexOf(",");
                                                optionValue = tmpConfig.substring(0, tmpPos);
                                                sb.append("<option value=\"").append(optionValue).append("\"");
                                                if (("," + paramValue + ",").indexOf("," + optionValue + ",") >= 0) {
                                                    sb.append(" selected");
                                                }
                                                sb.append(">").append(tmpConfig.substring(tmpPos + 1)).append("</option>\n");
                                            }
                                            sb.append("</select>");
                                            sb.append("<input type=hidden name=").append(paramName).append(" id=").append(paramName).append(" value=\"\">");
                                            break;
                                        }
                                        sb.append("<select name=").append(paramName).append(" id=").append(paramName).append(" value=\"").append(paramValue).append("\" style=\"").append(cell.getStyle());
                                        sb.append(";width:").append(width).append("px;height:").append(height).append("px\" onclick=\"_hideDropDown();\">\n");
                                        sb.append("<option value=\"\" selected></option>\n");
                                        at = new ArgumentTokenizer(editConfig, ';');
                                        while (at.hasMoreTokens()) {
                                            tmpConfig = at.nextToken();
                                            int tmpPos = tmpConfig.indexOf(",");
                                            optionValue = tmpConfig.substring(0, tmpPos);
                                            sb.append("<option value=\"").append(optionValue).append("\"");
                                            if (optionValue.equals(paramValue)) {
                                                sb.append(" selected");
                                            }
                                            sb.append(">").append(tmpConfig.substring(tmpPos + 1)).append("</option>\n");
                                        }
                                        sb.append("</select>");
                                        break;
                                    }
                                    case 4: {
                                        if (editConfig == null || editConfig.trim().length() == 0) {
                                            throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col2 + "\u5217\u7684\u590d\u9009\u6846\u7f16\u8f91\u65b9\u5f0f\u6ca1\u6709\u914d\u7f6e\uff01");
                                        }
                                        Segment segs = new Segment(editConfig);
                                        String cbText = segs.get("text");
                                        String cbLocation = segs.get("align");
                                        String cbOn = segs.get("on");
                                        String cbOff = segs.get("off");
                                        StringBuffer cbsb = new StringBuffer();
                                        cbsb.append("<input type=hidden name=").append(paramName).append(" id=").append(paramName).append(" value=\"").append(paramValue).append("\">\n");
                                        cbsb.append("<input type=checkbox onclick=\"_hideDropDown();if( this.checked ) document.getElementById( '" + paramName + "' ).value = '" + cbOn + "';else document.getElementById( '" + paramName + "' ).value='" + cbOff + "';\"");
                                        if (paramValue.equals(cbOn)) {
                                            cbsb.append(" checked");
                                        }
                                        cbsb.append(">");
                                        if (cbText != null && cbText.trim().length() > 0) {
                                            if (cbLocation.equals("0")) {
                                                cbsb.insert(0, cbText);
                                            } else {
                                                cbsb.append(cbText);
                                            }
                                        }
                                        sb.append(cbsb.toString());
                                        break;
                                    }
                                    case 6: {
                                        String vType;
                                        sb.append("<input type=text name=").append(paramName).append(" id=").append(paramName).append(" value=\"").append(paramValue).append("\" style=\"").append(cell.getStyle());
                                        sb.append(";width:").append(width).append("px;height:").append(height).append("px\"");
                                        Segment seg_6 = new Segment(editConfig);
                                        String sepa = seg_6.get("separator");
                                        if (sepa.equals("\u65e0")) {
                                            sepa = "";
                                        }
                                        vType = (vType = seg_6.get("valueType")).equals("\u5e74\u6708\u65e5") ? "day" : (vType.equals("\u5e74\u6708") ? "month" : "year");
                                        if (inNS) {
                                            sb.append(" onclick=\"_hideDropDown();_runqianCalendar().separator='" + sepa + "';_runqianCalendar().type= '" + vType + "';_showCalendar( event )\">");
                                            break;
                                        }
                                        sb.append(" onclick=\"_hideDropDown();_runqianCalendar.separator='" + sepa + "';_runqianCalendar.type= '" + vType + "';_showCalendar()\">");
                                        break;
                                    }
                                    case 8: {
                                        sb.append("<input type=hidden name=").append(paramName).append(" id=").append(paramName).append(" value=\"").append(paramValue).append("\">");
                                        String treeCellName = String.valueOf(paramName) + "_text";
                                        String treeCellValue = "";
                                        if (params != null) {
                                            treeCellValue = (String)params.get(treeCellName);
                                        }
                                        if (treeCellValue == null || treeCellValue.trim().length() == 0) {
                                            treeCellValue = paramValue;
                                        }
                                        sb.append("<input type=text name=").append(treeCellName).append(" id=").append(treeCellName).append(" value=\"").append(treeCellValue).append("\" style=\"").append(cell.getStyle());
                                        sb.append(";width:").append(width).append("px;height:").append(height).append("px\"");
                                        sb.append(" readonly onclick=\"_hideDropDown();tree_show( this, 'tree_" + this.name + row + col2 + "' )\">");
                                        break;
                                    }
                                    default: {
                                        int inputDataType = (Integer)parser.getPropertyValue(row, col2, 4810);
                                        sb.append("<input type=text name=").append(paramName).append(" id=").append(paramName).append(" value=\"").append(paramValue).append("\" style=\"").append(cell.getStyle());
                                        sb.append(";width:").append(width).append("px;height:").append(height).append("px\"");
                                        sb.append(" onblur=\"if( ! _checkDataType( '" + inputDataType + "', value ) ) this.focus();");
                                        String cellJSValid = InputUtils.createParamCheckValidScript(this.cellset, this.name, row, col2);
                                        if (cellJSValid.length() > 0) {
                                            sb.append("if( ! " + paramName + "_dataValid() ) this.focus();");
                                        }
                                        sb.append("\" onclick=\"_hideDropDown();\">\n");
                                        if (cellJSValid.length() > 0) {
                                            sb.append("<script language=javascript>\n");
                                            sb.append("\tfunction " + paramName + "_dataValid() {\n");
                                            sb.append(cellJSValid);
                                            sb.append("\t}\n");
                                            sb.append("</script>\n");
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else {
                                String text = cell.getText();
                                obj = parser.getPropertyValue(row, col2, 4107);
                                if (obj != null && ((Boolean)obj).booleanValue()) {
                                    text = StringUtils.replace(text, "&nbsp;", " ");
                                }
                                sb.append(text);
                            }
                        } else if (dataType == CellPropertyDefine.CDT_SUBREPORT && (obj = parser.getPropertyValue(row, col2, 4102)) instanceof byte[]) {
                            String graphId = GraphPool.createParamsId();
                            GraphPool.put(graphId, (byte[])obj);
                            sb.append("<img src=\"" + appRoot + ServletMappings.getMapping("com.runqian.report.view.html.GraphServlet") + "?graphId=" + graphId + "&time=" + new Date().getTime() + "\" border=no>");
                        }
                        if (link != null) {
                            sb.append("</a>");
                        }
                    }
                    sb.append("</td>\n");
                    if (editStyle == 6 && !calendarJSImported) {
                        String calendarJs = "calendar.js";
                        if (inNS) {
                            calendarJs = "calendar4ns.js";
                        }
                        sb.append("<script language=javascript src=\"" + appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + calendarJs + "\"></script>\n");
                        sb.append("<script language=javascript>_createRunqianCalendar();</script>\n");
                        calendarJSImported = true;
                    }
                    if (editStyle == 8) {
                        if (!treeJSImported) {
                            String treeJs = "tree.js";
                            sb.append("<script language=javascript src=\"" + appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + treeJs + "\"></script>\n");
                            treeJSImported = true;
                        }
                        String treeName = "tree_" + this.name + row + col2;
                        Hashtable params = null;
                        if (this.paramsId != null) {
                            params = ParamsPool.get(this.paramsId);
                        }
                        Tree tree = new Tree(editConfig, params, appRoot, treeName);
                        tree.setInNS(inNS);
                        sb.append(tree.generateHtml());
                        sb.append("<script language=javascript>if( document.body.runqianTrees ) document.body.runqianTrees += ',' + '" + treeName + "'; else document.body.runqianTrees = '" + treeName + "';</script>\n");
                    }
                }
                ++col2;
            }
            sb.append("\t</tr>\n");
            ++row;
        }
        sb.append("</table>");
        sb.append("<script language=javascript>\n");
        sb.append("\tfunction " + this.name + "_checkValid() {\n");
        sb.append(InputUtils.createParamCheckValidScript(this.cellset, this.name));
        sb.append("\t}\n");
        sb.append("</script>\n");
        return sb.toString();
    }
}

