/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.html;

import com.runqian.report.view.html.Tree;
import java.util.ArrayList;

class TreeNode {
    private String id;
    protected String code;
    private String label;
    private String icon;
    private ArrayList children;
    protected TreeNode pNode;

    protected TreeNode(String id, String code, String label) {
        this.id = id;
        this.code = code;
        this.label = label;
        this.children = new ArrayList();
    }

    protected TreeNode[] getChildren() {
        TreeNode[] tn = new TreeNode[this.children.size()];
        int i = 0;
        while (i < tn.length) {
            tn[i] = (TreeNode)this.children.get(i);
            ++i;
        }
        return tn;
    }

    protected void addChild(TreeNode node) {
        this.children.add(node);
        node.pNode = this;
    }

    protected int getChildCount() {
        return this.children.size();
    }

    protected String generateHtml(Tree tree, boolean isLastNode, String leftSide) {
        String display = "none";
        if (this.id.equals("1")) {
            display = "";
        }
        String font = tree.getLabelFace(1);
        String fontSize = tree.getLabelFace(2);
        String fontColor = tree.getLabelFace(3);
        String html = "<table id=\"_tbl_" + this.id + "\" border=0 cellspacing=0 cellpadding=0" + " style=\"font-size:" + fontSize + "; font-family:" + font + "; color:" + fontColor + "\" >\n" + "<tr>";
        if (leftSide == null) {
            leftSide = "";
        }
        int childCount = this.getChildCount();
        if (!this.id.equals("1")) {
            html = String.valueOf(html) + "<td valign=middle nowrap>" + leftSide;
            if (isLastNode) {
                leftSide = String.valueOf(leftSide) + "<img src=\"" + tree.getImage(6) + "\">";
                html = childCount > 0 ? String.valueOf(html) + "<img src=\"" + tree.getImage(7) + "\" border=noborder " + "id=\"_img_" + this.id + "\" nodevalue=\"2\" " + "onClick=\"parent.tree_iconClick( this, document.getElementById( '_div_" + this.id + "' ) )\" >" : String.valueOf(html) + "<img src=\"" + tree.getImage(5) + "\" " + "id=\"_img_" + this.id + "\">";
            } else {
                leftSide = String.valueOf(leftSide) + "<img src=\"" + tree.getImage(4) + "\" >";
                html = childCount > 0 ? String.valueOf(html) + "<img src=\"" + tree.getImage(3) + "\" border=noborder " + "id=\"_img_" + this.id + "\" nodevalue=\"0\" " + "onClick=\"parent.tree_iconClick( this, document.getElementById( '_div_" + this.id + "' ) )\" >" : String.valueOf(html) + "<img src=\"" + tree.getImage(1) + "\" " + "id=\"_img_" + this.id + "\">";
            }
            html = String.valueOf(html) + "</td>\n";
        }
        html = String.valueOf(html) + "<td valign=middle align=left nowrap>";
        String nodeImage = tree.getImage(10);
        if (this.id.equals("1")) {
            nodeImage = tree.getImage(12);
        }
        if (childCount == 0) {
            nodeImage = tree.getImage(11);
        }
        html = String.valueOf(html) + "<img src=\"" + nodeImage + "\" border=noborder name=\"_img2_" + this.id + "\" ></td>\n";
        html = String.valueOf(html) + "<td id=\"id_" + this.id + "\" code=\"" + this.code + "\" valign=middle align=left nowrap";
        if (!this.id.equals("1")) {
            if (!tree.leafOnly || childCount == 0) {
                html = String.valueOf(html) + " onclick=\"parent.tree_select( this, '" + tree.treeWinId + "' )\"";
            }
            html = String.valueOf(html) + " onmouseover=\"parent.tree_mouseOver( this )\" onmouseout=\"parent.tree_mouseOut( this )\"";
        }
        html = String.valueOf(html) + " style=\"cursor:default; padding-left: 5px\" >" + this.label + "</td>\n";
        html = String.valueOf(html) + "</tr></table>\n";
        if (childCount > 0) {
            html = String.valueOf(html) + "<div id=\"_div_" + this.id + "\" style=\"display:" + display + "\">\n";
            TreeNode[] children = this.getChildren();
            int i = 0;
            while (i < childCount) {
                html = i == childCount - 1 ? String.valueOf(html) + children[i].generateHtml(tree, true, leftSide) : String.valueOf(html) + children[i].generateHtml(tree, false, leftSide);
                ++i;
            }
            html = String.valueOf(html) + "</div>";
        }
        return html;
    }
}

