/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.pdf;

import com.lowagie.text.pdf.PdfPCell;
import com.runqian.base.util.ImageTransparencyFilter;
import com.runqian.base.util.ReportError;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.control.CellBorder;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.LeanLine;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class PdfCell {
    private CellSet cs;
    private CellSetParser cp;
    int row;
    int col;

    public PdfCell(CellSet cs, int row, int col, CellSetParser cp) {
        this.cs = cs;
        this.cp = cp;
        this.row = row;
        this.col = col;
    }

    private String getText() {
        Object obj = this.cs.getPropertyValue(this.row, this.col, 4105);
        if (obj == null) {
            obj = this.cs.getPropertyValue(this.row, this.col, 4102);
        }
        if (obj == null) {
            return "";
        }
        String text = obj instanceof byte[] ? new String((byte[])obj) : obj.toString();
        return text;
    }

    public static void drawImage(Graphics2D g2, CellSetParser cp, int row, int col, float x, float y, float w, float h) {
        byte[] b = (byte[])cp.getPropertyValue(row, col, 4102);
        if (b == null) {
            return;
        }
        SeekableStream ss = SeekableStream.wrapInputStream((InputStream)new ByteArrayInputStream(b), (boolean)false);
        RenderedOp pi = JAI.create((String)"stream", (Object)ss);
        Image image1 = pi.getAsBufferedImage();
        image1 = ImageTransparencyFilter.filter(image1);
        g2.drawImage(image1, (int)x, (int)y, (int)w, (int)h, null);
    }

    public void drawCell(Graphics2D g2, int[] x, int[] y) {
        if (this.cp.isMerged(this.row, this.col) && !this.cp.isMergedFirstCell(this.row, this.col)) {
            return;
        }
        int colSpan = this.cp.getColSpan(this.row, this.col, true);
        int rowSpan = this.cp.getRowSpan(this.row, this.col, true);
        this.drawBackground(g2, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1], y[this.row + rowSpan - 1]);
        Object obj = this.cp.getPropertyValue(this.row, this.col, 4101);
        if (obj == null) {
            obj = CellPropertyDefine.CDT_TEXT;
        }
        int dataType = Integer.parseInt(obj.toString());
        try {
            if (dataType == CellPropertyDefine.CDT_TEXT) {
                Object lean = this.cp.getPropertyValue(this.row, this.col, 4414);
                if (lean == null || ((Integer)lean).intValue() == CellPropertyDefine.CLL_NONE.intValue()) {
                    this.drawText(g2, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1], y[this.row + rowSpan - 1]);
                } else {
                    new LeanLine(this.cp, this.row, this.col).draw(g2, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1] - x[this.col - 1], y[this.row + rowSpan - 1] - y[this.row - 1]);
                }
            } else if (dataType == CellPropertyDefine.CDT_SUBREPORT) {
                Object sub = this.cp.getPropertyValue(this.row, this.col, 4102);
                if (sub instanceof CellSet) {
                    if (this.cp.isCellVisible(this.row, this.col)) {
                        this.drawSubReport((CellSet)sub, g2, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1] - x[this.col - 1], y[this.row + rowSpan - 1] - y[this.row - 1]);
                    }
                } else {
                    this.drawText(g2, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1], y[this.row + rowSpan - 1]);
                }
            } else if (!(this.cp.isMerged(this.row, this.col) && !this.cp.isMergedFirstCell(this.row, this.col) || dataType != CellPropertyDefine.CDT_GRAPH && dataType != CellPropertyDefine.CDT_PIC_DB && dataType != CellPropertyDefine.CDT_PIC_FILE)) {
                PdfCell.drawImage(g2, this.cp, this.row, this.col, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1] - x[this.col - 1], y[this.row + rowSpan - 1] - y[this.row - 1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        this.drawBorder(g2, x[this.col - 1], y[this.row - 1], x[this.col + colSpan - 1], y[this.row + rowSpan - 1]);
    }

    public PdfPCell getPdfPCell(int[] x, int[] y) {
        if (this.cp.isMerged(this.row, this.col) && !this.cp.isMergedFirstCell(this.row, this.col)) {
            return null;
        }
        int colSpan = this.cp.getColSpan(this.row, this.col, true);
        int rowSpan = this.cp.getRowSpan(this.row, this.col, true);
        return null;
    }

    private void drawSubReport(CellSet cs, Graphics2D g, int x1, int y1, int w, int h) {
        CellSetParser parser = new CellSetParser(cs);
        try {
            int height;
            int i;
            int totalX;
            int realh = parser.getCellSetHeight();
            int realw = parser.getCellSetWidth();
            realw = realw > w ? w : realw;
            realh = realh > h ? h : realh;
            int align = (Integer)this.cp.getPropertyValue(this.row, this.col, 4201);
            if (align == CellPropertyDefine.CA_CENTER) {
                x1 += (w - realw) / 2;
            } else if (align == CellPropertyDefine.CA_RIGHT) {
                x1 = x1 + w - realw;
            }
            int valign = (Integer)this.cp.getPropertyValue(this.row, this.col, 4202);
            if (valign == CellPropertyDefine.CVA_MIDDLE) {
                y1 += (h - realh) / 2;
            } else if (valign == CellPropertyDefine.CVA_BOTTOM) {
                y1 = y1 + h - realh;
            }
            w = realw;
            h = realh;
            int colCount = parser.getColCount();
            int rowCount = parser.getRowCount();
            int[] x = new int[colCount];
            x[0] = totalX = x1;
            int i2 = 1;
            while (i2 < colCount) {
                int width = parser.getColWidth(i2);
                if (!parser.isColVisible(i2)) {
                    width = 0;
                }
                x[i2] = totalX += width;
                ++i2;
            }
            x[colCount - 1] = totalX;
            int[] y = new int[rowCount];
            int totalY = y1;
            int startHeader = 0;
            int endHeader = 0;
            int startFooter = 0;
            int endFooter = 0;
            Field headField = parser.getPageHeader();
            if (headField != null && (startHeader = headField.getStartRow()) != (endHeader = headField.getEndRow())) {
                y[endHeader - 1] = totalY;
                int i3 = endHeader - 1;
                while (i3 >= startHeader) {
                    int height2 = parser.getRowHeight(i3);
                    if (!parser.isRowVisible(i3)) {
                        height2 = 0;
                    }
                    if ((totalY -= height2) < 0) {
                        totalY = 0;
                    }
                    y[i3 - 1] = totalY;
                    --i3;
                }
            }
            Field footField = parser.getPageFooter();
            totalY = h + y1;
            if (footField != null && (startFooter = footField.getStartRow()) != (endFooter = footField.getEndRow())) {
                i = startFooter + 1;
                while (i <= endFooter) {
                    y[i - 1] = totalY;
                    height = parser.getRowHeight(i);
                    if (!parser.isRowVisible(i)) {
                        height = 0;
                    }
                    totalY += height;
                    ++i;
                }
                y[endFooter] = totalY;
            }
            y[endHeader] = totalY = y1;
            i = 1;
            while (i < rowCount) {
                if (!(i >= startHeader && i <= endHeader || i >= startFooter && i <= endFooter)) {
                    height = parser.getRowHeight(i);
                    if (!parser.isRowVisible(i)) {
                        height = 0;
                    }
                    y[i] = totalY += height;
                }
                ++i;
            }
            i = 1;
            while (i < rowCount) {
                if (parser.isRowVisible(i)) {
                    int j = 1;
                    while (j < colCount) {
                        if (parser.isColVisible(j) && parser.isCellVisible(i, j)) {
                            PdfCell pc = new PdfCell(cs, i, j, parser);
                            pc.drawCell(g, x, y);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
    }

    private void drawBorder(Graphics2D g2, int x1, int y1, int x2, int y2) {
        CellBorder cb = new CellBorder(g2, this.cp, this.row, this.col, false);
        cb.setPageHeaderAndFooter(this.cp.getPageHeader(), this.cp.getPageFooter());
        cb.drawBorder(x1, y1, x2 - x1, y2 - y1);
    }

    private int getHAlign() {
        Object pvalue = this.cs.getPropertyValue(this.row, this.col, 4201);
        if (pvalue == null) {
            return CellPropertyDefine.CA_LEFT;
        }
        return (Integer)pvalue;
    }

    private int getVAlign() {
        Object pvalue = this.cs.getPropertyValue(this.row, this.col, 4202);
        if (pvalue == null) {
            return CellPropertyDefine.CVA_MIDDLE;
        }
        return (Integer)pvalue;
    }

    private Font getFont() {
        Object value = this.cs.getPropertyValue(this.row, this.col, 4301);
        String face = "DialogInput";
        if (value != null) {
            face = value.toString();
        }
        value = this.cs.getPropertyValue(this.row, this.col, 4302);
        int size = 12;
        if (value != null) {
            size = Integer.parseInt(value.toString());
        }
        int fontStyle = 0;
        value = this.cs.getPropertyValue(this.row, this.col, 4304);
        if (value != null && ((Boolean)value).booleanValue()) {
            ++fontStyle;
        }
        if ((value = this.cs.getPropertyValue(this.row, this.col, 4305)) != null && ((Boolean)value).booleanValue()) {
            fontStyle += 2;
        }
        return new Font(face, fontStyle, size);
    }

    private Color getFontColor() {
        Object tmpObj = this.cs.getPropertyValue(this.row, this.col, 4303);
        if (tmpObj != null) {
            return new Color(Integer.parseInt(tmpObj.toString()));
        }
        return Color.black;
    }

    private boolean getUnderLine() {
        Object tmpObj = this.cs.getPropertyValue(this.row, this.col, 4306);
        if (tmpObj == null) {
            return false;
        }
        return (Boolean)tmpObj;
    }

    private boolean getWordWrap() {
        boolean wordWrap = false;
        Object value = this.cs.getPropertyValue(this.row, this.col, 4107);
        if (value != null && ((Boolean)value).booleanValue()) {
            wordWrap = true;
        }
        return wordWrap;
    }

    private int getIndent() {
        int indent = 0;
        Object value = this.cs.getPropertyValue(this.row, this.col, 4203);
        if (value != null) {
            indent = Integer.parseInt(value.toString());
        }
        return indent;
    }

    private void drawBackground(Graphics2D g2, int x1, int y1, int x2, int y2) {
        Object pvalue = this.cs.getPropertyValue(this.row, this.col, 4413);
        if (pvalue == null) {
            return;
        }
        Color color = new Color(Integer.parseInt(pvalue.toString()));
        try {
            g2.setColor(color);
            g2.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void drawText(Graphics2D g2, int x1, int y1, int x2, int y2) {
        ControlUtils.drawText(g2, this.getText(), x1, y1, x2 - x1, y2 - y1, this.getWordWrap(), this.getUnderLine(), this.getHAlign(), this.getVAlign(), this.getIndent(), this.getFont(), this.getFontColor());
    }
}

