/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.runqian.base.util.ReportError;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.view.pdf.PdfCell;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PdfReport {
    private Rectangle rect;
    private IntHashtable firstProps;
    private PageBuilder pb;
    private int pageWidth;
    private int pageHeight;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    String verMessage = "";

    public PdfReport(CellSet cs) {
        this(cs, 0, 0, 0);
    }

    public PdfReport(CellSet cs, int pageWidth, int pageHeight) {
        this(cs, pageWidth, pageHeight, 0);
    }

    public PdfReport(CellSet cs, int pageWidth, int pageHeight, int columns) {
        CellSetParser parser = new CellSetParser(cs);
        if (columns == 0) {
            columns = parser.getColumns();
        }
        PageFormat pf = parser.getPageFormat();
        if (pageWidth == 0) {
            pageWidth = (int)pf.getWidth();
        }
        if (pageHeight == 0) {
            pageHeight = (int)pf.getHeight();
        }
        this.rect = new Rectangle(0.0f, 0.0f, (float)pageWidth, (float)pageHeight);
        try {
            this.leftMargin = (int)pf.getImageableX();
        }
        catch (Exception e) {
            this.leftMargin = 5;
        }
        try {
            this.rightMargin = (int)(pf.getWidth() - pf.getImageableWidth()) - this.leftMargin;
        }
        catch (Exception e) {
            this.rightMargin = 5;
        }
        try {
            this.topMargin = (int)pf.getImageableY();
        }
        catch (Exception e) {
            this.topMargin = 5;
        }
        try {
            this.bottomMargin = (int)(pf.getHeight() - pf.getImageableHeight()) - this.topMargin;
        }
        catch (Exception e) {
            this.bottomMargin = 5;
        }
        try {
            this.pb = new PageBuilder(cs, pageWidth - this.leftMargin - this.rightMargin, pageHeight - this.topMargin - this.bottomMargin, columns, false);
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
    }

    private void outputPage(int page, PdfContentByte pcb) throws Exception {
        Graphics2D g2 = pcb.createGraphicsShapes((float)this.pageWidth, (float)this.pageHeight);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.drawReport(g2, this.pb.getPage(page), this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin, this.pageHeight);
        g2.dispose();
    }

    /*
     * Exception decompiling
     */
    public void out(OutputStream out) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 161->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void drawReport(Graphics2D g2, CellSet cs, int leftMargin, int topMargin, int rightMargin, int bottomMargin, int pageHeight) {
        if (this.verMessage.length() > 0) {
            if (topMargin < 50) {
                topMargin = 50;
            }
            g2.setColor(Color.red);
            g2.setFont(new Font("\u5b8b\u4f53", 0, 20));
            g2.drawString(this.verMessage, 100, 25);
        }
        CellSetParser parser = new CellSetParser(cs);
        try {
            int height;
            int i;
            int totalX;
            int colCount = parser.getColCount();
            int rowCount = parser.getRowCount();
            int[] x = new int[colCount];
            x[0] = totalX = leftMargin;
            int i2 = 1;
            while (i2 < colCount) {
                int width = parser.getColWidth(i2);
                if (!parser.isColVisible(i2)) {
                    width = 0;
                }
                x[i2] = totalX += width;
                ++i2;
            }
            x[colCount - 1] = totalX;
            int[] y = new int[rowCount];
            int totalY = topMargin;
            int startHeader = 0;
            int endHeader = 0;
            int startFooter = 0;
            int endFooter = 0;
            Field headField = parser.getPageHeader();
            if (headField != null && (startHeader = headField.getStartRow()) != (endHeader = headField.getEndRow())) {
                y[endHeader - 1] = totalY;
                int i3 = endHeader - 1;
                while (i3 >= startHeader) {
                    int height2 = parser.getRowHeight(i3);
                    if (!parser.isRowVisible(i3)) {
                        height2 = 0;
                    }
                    if ((totalY -= height2) < 0) {
                        totalY = 0;
                    }
                    y[i3 - 1] = totalY;
                    --i3;
                }
            }
            Field footField = parser.getPageFooter();
            totalY = pageHeight - bottomMargin;
            if (footField != null && (startFooter = footField.getStartRow()) != (endFooter = footField.getEndRow())) {
                i = startFooter + 1;
                while (i <= endFooter) {
                    y[i - 1] = totalY;
                    height = parser.getRowHeight(i);
                    if (!parser.isRowVisible(i)) {
                        height = 0;
                    }
                    totalY += height;
                    ++i;
                }
                y[endFooter] = totalY;
            }
            y[endHeader] = totalY = topMargin;
            i = 1;
            while (i < rowCount) {
                if (!(i >= startHeader && i <= endHeader || i >= startFooter && i <= endFooter)) {
                    height = parser.getRowHeight(i);
                    if (!parser.isRowVisible(i)) {
                        height = 0;
                    }
                    y[i] = totalY += height;
                }
                ++i;
            }
            i = 1;
            while (i < rowCount) {
                if (parser.isRowVisible(i)) {
                    int j = 1;
                    while (j < colCount) {
                        if (parser.isColVisible(j) && parser.isCellVisible(i, j)) {
                            PdfCell pc = new PdfCell(cs, i, j, parser);
                            pc.drawCell(g2, x, y);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        FileOutputStream out = null;
        Document document = new Document(new Rectangle(0.0f, 0.0f, 595.0f, 842.0f), 5.0f, 5.0f, 5.0f, 5.0f);
        try {
            try {
                out = new FileOutputStream("d:\\b.pdf");
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
                document.open();
                document.newPage();
                Phrase phrase = new Phrase("123");
                PdfPTable t = new PdfPTable(2);
                PdfPCell pcell = new PdfPCell(phrase);
                t.addCell(pcell);
                t.addCell(phrase);
                document.add((Element)t);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            document.close();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        document.close();
    }
}

