/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.text;

import com.runqian.base.util.MacroResolver;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.control.ControlUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class TextCell {
    private CellSetParser parser;
    private int row;
    private int col;
    private static int PPC = 6;
    private int width = 0;
    public boolean merged = false;
    private static CellPropertyDefine cpd = new CellPropertyDefine();

    public TextCell(CellSetParser parser, int row, int col) {
        this.parser = parser;
        this.row = row;
        this.col = col;
        this.width = Math.round((float)parser.getColWidth(col) * 1.0f / (float)PPC);
        if (this.width % 2 == 1) {
            ++this.width;
        }
        this.merged = parser.isMerged(row, col);
    }

    private boolean isBorderBold(int r, int c, int key) {
        Float border;
        if (r <= 1 || c <= 1) {
            return false;
        }
        if (r >= this.parser.getRowCount() - 1) {
            if (key != 4408) {
                return false;
            }
        }
        if (c >= this.parser.getColCount() - 1) {
            if (key != 4402) {
                return false;
            }
        }
        if ((border = (Float)this.parser.getPropertyValue(r, c, key)) == null) {
            return false;
        }
        return (double)border.floatValue() >= 2.0;
    }

    private boolean hasBorder(int r, int c, int key) {
        Integer border;
        if (r <= 1 || c <= 1) {
            return false;
        }
        if (r >= this.parser.getRowCount() - 1) {
            if (key != 4407) {
                return false;
            }
        }
        if (c >= this.parser.getColCount() - 1) {
            if (key != 4401) {
                return false;
            }
        }
        if (this.parser.isMerged(r, c)) {
            switch (key) {
                case 4401: {
                    if (this.parser.isMergedLeftCell(r, c)) break;
                    return false;
                }
                case 4407: {
                    if (this.parser.isMergedTopCell(r, c)) break;
                    return false;
                }
                case 4404: {
                    if (this.parser.isMergedRightCell(r, c)) break;
                    return false;
                }
                case 4410: {
                    if (this.parser.isMergedBottomCell(r, c)) break;
                    return false;
                }
            }
        }
        if ((border = (Integer)this.parser.getPropertyValue(r, c, key)) == null) {
            return false;
        }
        return border.intValue() != CellPropertyDefine.CBS_NONE.intValue();
    }

    public String getLeftTopCorner() {
        boolean hasLeft = this.hasBorder(this.row, this.col - 1, 4407);
        boolean hasTop = this.hasBorder(this.row - 1, this.col, 4401);
        boolean hasRight = this.hasBorder(this.row, this.col, 4407);
        boolean hasBottom = this.hasBorder(this.row, this.col, 4401);
        boolean leftBold = this.isBorderBold(this.row, this.col - 1, 4408);
        boolean topBold = this.isBorderBold(this.row - 1, this.col, 4402);
        boolean rightBold = this.isBorderBold(this.row, this.col, 4408);
        boolean bottomBold = this.isBorderBold(this.row, this.col, 4402);
        if (!(hasLeft || hasTop || hasRight || hasBottom)) {
            return "  ";
        }
        if (!hasTop && !hasBottom) {
            if (hasLeft && !hasRight) {
                if (leftBold) {
                    return "\u2501";
                }
                return "\u2500";
            }
            if (!hasLeft && hasRight) {
                if (rightBold) {
                    return "\u2501";
                }
                return "\u2500";
            }
            if (leftBold || rightBold) {
                return "\u2501";
            }
            return "\u2500";
        }
        if (!hasLeft && !hasRight) {
            if (hasTop && !hasBottom) {
                if (topBold) {
                    return "\u2503";
                }
                return "\u2502";
            }
            if (!hasTop && hasBottom) {
                if (bottomBold) {
                    return "\u2503";
                }
                return "\u2502";
            }
            if (topBold || bottomBold) {
                return "\u2503";
            }
            return "\u2502";
        }
        if (!hasLeft && !hasTop) {
            if (!rightBold && !bottomBold) {
                return "\u250c";
            }
            if (rightBold && !bottomBold) {
                return "\u250d";
            }
            if (!rightBold && bottomBold) {
                return "\u250e";
            }
            return "\u250f";
        }
        if (!hasTop && !hasRight) {
            if (!leftBold && !bottomBold) {
                return "\u2510";
            }
            if (leftBold && !bottomBold) {
                return "\u2511";
            }
            if (!leftBold && bottomBold) {
                return "\u2512";
            }
            return "\u2513";
        }
        if (!hasLeft && !hasBottom) {
            if (!rightBold && !topBold) {
                return "\u2514";
            }
            if (rightBold && !topBold) {
                return "\u2515";
            }
            if (!rightBold && topBold) {
                return "\u2516";
            }
            return "\u2517";
        }
        if (!hasBottom && !hasRight) {
            if (!leftBold && !topBold) {
                return "\u2518";
            }
            if (leftBold && !topBold) {
                return "\u2519";
            }
            if (!leftBold && topBold) {
                return "\u251a";
            }
            return "\u251b";
        }
        if (!hasLeft) {
            if (!(topBold || rightBold || bottomBold)) {
                return "\u251c";
            }
            if (!topBold && rightBold && !bottomBold) {
                return "\u251d";
            }
            if (topBold && !rightBold && !bottomBold) {
                return "\u251e";
            }
            if (!topBold && !rightBold && bottomBold) {
                return "\u251f";
            }
            if (topBold && !rightBold && bottomBold) {
                return "\u2520";
            }
            if (topBold && rightBold && !bottomBold) {
                return "\u2521";
            }
            if (!topBold && rightBold && bottomBold) {
                return "\u2522";
            }
            return "\u2523";
        }
        if (!hasRight) {
            if (!(topBold || leftBold || bottomBold)) {
                return "\u2524";
            }
            if (!topBold && leftBold && !bottomBold) {
                return "\u2525";
            }
            if (topBold && !leftBold && !bottomBold) {
                return "\u2526";
            }
            if (!topBold && !leftBold && bottomBold) {
                return "\u2527";
            }
            if (topBold && !leftBold && bottomBold) {
                return "\u2528";
            }
            if (topBold && leftBold && !bottomBold) {
                return "\u2529";
            }
            if (!topBold && leftBold && bottomBold) {
                return "\u252a";
            }
            return "\u252b";
        }
        if (!hasTop) {
            if (!(leftBold || rightBold || bottomBold)) {
                return "\u252c";
            }
            if (leftBold && !rightBold && !bottomBold) {
                return "\u252d";
            }
            if (!leftBold && rightBold && !bottomBold) {
                return "\u252e";
            }
            if (leftBold && rightBold && !bottomBold) {
                return "\u252f";
            }
            if (!leftBold && !rightBold && bottomBold) {
                return "\u2530";
            }
            if (leftBold && !rightBold && bottomBold) {
                return "\u2531";
            }
            if (!leftBold && rightBold && bottomBold) {
                return "\u2532";
            }
            return "\u2533";
        }
        if (!hasBottom) {
            if (!(leftBold || rightBold || topBold)) {
                return "\u2534";
            }
            if (leftBold && !rightBold && !topBold) {
                return "\u2535";
            }
            if (!leftBold && rightBold && !topBold) {
                return "\u2536";
            }
            if (leftBold && rightBold && !topBold) {
                return "\u2537";
            }
            if (!leftBold && !rightBold && topBold) {
                return "\u2538";
            }
            if (leftBold && !rightBold && topBold) {
                return "\u2539";
            }
            if (!leftBold && rightBold && topBold) {
                return "\u253a";
            }
            return "\u253b";
        }
        if (!(leftBold || rightBold || topBold || bottomBold)) {
            return "\u253c";
        }
        if (leftBold && !rightBold && !topBold && !bottomBold) {
            return "\u253d";
        }
        if (!leftBold && rightBold && !topBold && !bottomBold) {
            return "\u253e";
        }
        if (leftBold && rightBold && !topBold && !bottomBold) {
            return "\u253f";
        }
        if (!leftBold && !rightBold && topBold && !bottomBold) {
            return "\u2540";
        }
        if (!leftBold && !rightBold && !topBold && bottomBold) {
            return "\u2541";
        }
        if (!leftBold && !rightBold && topBold && bottomBold) {
            return "\u2542";
        }
        if (leftBold && !rightBold && topBold && !bottomBold) {
            return "\u2543";
        }
        if (!leftBold && rightBold && topBold && !bottomBold) {
            return "\u2544";
        }
        if (leftBold && !rightBold && !topBold && bottomBold) {
            return "\u2545";
        }
        if (!leftBold && rightBold && !topBold && bottomBold) {
            return "\u2546";
        }
        if (leftBold && rightBold && topBold && !bottomBold) {
            return "\u2547";
        }
        if (leftBold && rightBold && !topBold && bottomBold) {
            return "\u2548";
        }
        if (leftBold && !rightBold && topBold && bottomBold) {
            return "\u2549";
        }
        if (!leftBold && rightBold && topBold && bottomBold) {
            return "\u254a";
        }
        return "\u254b";
    }

    public String getTopBorder() {
        if (this.hasBorder(this.row, this.col, 4407)) {
            String tmp = "\u2500";
            if (this.isBorderBold(this.row, this.col, 4408)) {
                tmp = "\u2501";
            }
            String border = "";
            int count = this.width / 2;
            int i = 0;
            while (i < count) {
                border = String.valueOf(border) + tmp;
                ++i;
            }
            return border;
        }
        String tmp = " ";
        String border = "";
        int i = 0;
        while (i < this.width) {
            border = String.valueOf(border) + tmp;
            ++i;
        }
        return border;
    }

    public String getLeftBorder() {
        if (this.merged && !this.parser.isMergedLeftCell(this.row, this.col)) {
            return "";
        }
        if (this.hasBorder(this.row, this.col, 4401)) {
            String tmp = "\u2502";
            if (this.isBorderBold(this.row, this.col, 4402)) {
                tmp = "\u2503";
            }
            return tmp;
        }
        return "  ";
    }

    public String getText() {
        String value;
        int c;
        int r;
        block21: {
            block20: {
                r = this.row;
                c = this.col;
                if (this.merged) {
                    if (!this.parser.isMergedLeftCell(this.row, this.col)) {
                        return "";
                    }
                    r = this.parser.getMergedStartRow(this.row, this.col);
                    c = this.parser.getMergedStartCol(this.row, this.col);
                }
                int type = (Integer)this.parser.getPropertyValue(r, c, 4101);
                value = "";
                if (type == CellPropertyDefine.CDT_TEXT) break block20;
                if (type != CellPropertyDefine.CDT_HTML) break block21;
            }
            if (this.parser.isCellVisible(r, c)) {
                Object obj = this.parser.getPropertyValue(r, c, 4105);
                if (obj != null) {
                    value = obj.toString();
                }
                if (value.trim().length() == 0) {
                    obj = this.parser.getPropertyValue(r, c, 4102);
                    if (obj != null) {
                        value = obj.toString();
                    }
                }
            }
        }
        int align = (Integer)this.parser.getPropertyValue(r, c, 4201);
        int indent = (Integer)this.parser.getPropertyValue(r, c, 4203);
        String indentString = "";
        if (indent > PPC / 2) {
            int indentWidth = Math.round((float)indent * 1.0f / (float)PPC);
            int i = 0;
            while (i < indentWidth) {
                indentString = String.valueOf(indentString) + " ";
                ++i;
            }
        }
        if (!this.merged) {
            String newValue = MacroResolver.onlyRemoveBrace(value);
            if (align == CellPropertyDefine.CA_LEFT) {
                return String.valueOf(indentString) + newValue + this.space(this.width - this.getLength(value) - indentString.length());
            }
            if (align == CellPropertyDefine.CA_RIGHT) {
                return String.valueOf(this.space(this.width - this.getLength(value) - indentString.length())) + newValue + indentString;
            }
            int valueLen = this.getLength(value);
            int leftLen = (this.width - valueLen) / 2;
            int rightLen = this.width - leftLen - valueLen;
            return String.valueOf(this.space(leftLen)) + newValue + this.space(rightLen);
        }
        int colSpan = this.parser.getColSpan(this.row, this.col, true);
        int mergedWidth = 0;
        int i = this.col;
        while (i < this.col + colSpan) {
            if (this.parser.isColVisible(i) && (mergedWidth += Math.round((float)this.parser.getColWidth(i) * 1.0f / (float)PPC)) % 2 == 1) {
                ++mergedWidth;
            }
            ++i;
        }
        mergedWidth += this.parser.getColSpan(this.row, this.col, false) * 2 - 2;
        int w_cell = this.parser.getMergedWidth(this.row, this.col, false);
        String[] tmp = this.split(value, w_cell -= ((Integer)this.parser.getPropertyValue(this.row, this.col, 4203)).intValue());
        int index = 0;
        int rowSpan = this.parser.getRowSpan(this.row, this.col, true);
        int i2 = r;
        while (i2 < r + rowSpan) {
            if (i2 == this.row) break;
            if (this.parser.isRowVisible(i2)) {
                ++index;
            }
            ++i2;
        }
        value = tmp.length > index ? tmp[index] : "";
        String newValue = MacroResolver.onlyRemoveBrace(value);
        if (align == CellPropertyDefine.CA_LEFT) {
            return String.valueOf(indentString) + newValue + this.space(mergedWidth - this.getLength(value) - indentString.length());
        }
        if (align == CellPropertyDefine.CA_RIGHT) {
            return String.valueOf(this.space(mergedWidth - this.getLength(value) - indentString.length())) + newValue + indentString;
        }
        int valueLen = this.getLength(value);
        int leftLen = (mergedWidth - valueLen) / 2;
        int rightLen = mergedWidth - leftLen - valueLen;
        return String.valueOf(this.space(leftLen)) + newValue + this.space(rightLen);
    }

    private int getLength(String src) {
        if (src == null) {
            return 0;
        }
        return MacroResolver.getLengthExceptMacros(src);
    }

    private String space(int n) {
        String s = "";
        int i = 0;
        while (i < n) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        return s;
    }

    private String[] split(String src, int w) {
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(font);
        ArrayList al = ControlUtils.wrapString(src, fm, w);
        String[] s = new String[al.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)al.get(i);
            ++i;
        }
        return s;
    }
}

