/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.text;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;

public class TextFile {
    private String separator = "\t";
    private CellSet cs;
    private boolean saveDispValue;

    public TextFile(CellSet cs, String separator) {
        this.cs = cs;
        this.separator = separator;
    }

    public void setSaveDispValue(boolean b) {
        this.saveDispValue = b;
    }

    public String toString() {
        String text = "";
        CellSetParser parser = new CellSetParser(this.cs);
        int rows = parser.getRowCount();
        int cols = parser.getColCount();
        int startRow = 1;
        int endRow = rows - 1;
        Field pageHeader = parser.getPageHeader();
        Field pageFooter = parser.getPageFooter();
        if (pageHeader != null) {
            startRow = pageHeader.getEndRow() + 1;
        }
        if (pageFooter != null) {
            endRow = pageFooter.getStartRow() - 1;
        }
        int row = startRow;
        while (row <= endRow) {
            int col = 1;
            while (col < cols) {
                if (!parser.isMerged(row, col)) {
                    text = String.valueOf(text) + this.getText(row, col, parser);
                } else if (parser.isMergedFirstCell(row, col)) {
                    text = String.valueOf(text) + this.getText(row, col, parser);
                }
                text = String.valueOf(text) + this.separator;
                ++col;
            }
            text = String.valueOf(text) + "\n";
            ++row;
        }
        return text;
    }

    private String getText(int row, int col, CellSetParser parser) {
        int type = (Integer)parser.getPropertyValue(row, col, 4101);
        if (type != CellPropertyDefine.CDT_TEXT) {
            return "";
        }
        if (!this.saveDispValue) {
            return this.getValue(row, col);
        }
        String text = "";
        Object obj = this.cs.getPropertyValue(row, col, 4105);
        if (obj != null) {
            text = obj.toString();
        }
        if (text.trim().length() == 0) {
            return this.getValue(row, col);
        }
        return text;
    }

    private String getValue(int row, int col) {
        Object obj = this.cs.getPropertyValue(row, col, 4102);
        if (obj == null) {
            return "";
        }
        String text = obj.toString();
        if (obj instanceof byte[]) {
            try {
                text = new String((byte[])obj, "GBK");
            }
            catch (Exception e) {
                text = new String((byte[])obj);
            }
        }
        if (text.trim().length() == 0) {
            text = "";
        }
        return text;
    }
}

