/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.view.text;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.CellSetReader;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.view.text.TextCell;

public class TextReport {
    private CellSetParser parser;

    public TextReport(CellSet cs) throws Exception {
        CellSet cellset = (CellSet)cs.clone();
        cellset.insertColumn(1);
        cellset.insertRow(1);
        cellset.insertColumn(-1);
        cellset.insertRow(-1);
        PageBuilder pb = new PageBuilder(cellset, 999999999, 999999999);
        this.parser = new CellSetParser(pb.getPage(1));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int rows = this.parser.getRowCount();
        int cols = this.parser.getColCount();
        int row = 2;
        while (row < rows) {
            if (this.parser.isRowVisible(row)) {
                TextCell cell;
                int col = 2;
                while (col < cols) {
                    if (this.parser.isColVisible(col)) {
                        cell = new TextCell(this.parser, row, col);
                        sb.append(cell.getLeftTopCorner());
                        if (col < cols - 1) {
                            sb.append(cell.getTopBorder());
                        } else {
                            sb.append("\n");
                        }
                    }
                    ++col;
                }
                if (row < rows - 1) {
                    col = 2;
                    while (col < cols) {
                        if (this.parser.isColVisible(col)) {
                            cell = new TextCell(this.parser, row, col);
                            sb.append(cell.getLeftBorder());
                            if (col < cols - 1) {
                                sb.append(cell.getText());
                            } else {
                                sb.append("\n");
                            }
                        }
                        ++col;
                    }
                }
            }
            ++row;
        }
        return sb.toString();
    }

    public static void main(String[] a) {
        try {
            TextReport r = new TextReport(new CellSetReader("e:/work/report/web/reportFiles/text.raq").read());
            System.out.println(r.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

