function _initInput( table ) {
	table.writableCells = new Array();
	table.currEditor = null;
	var writableCount = 0;
	for( var row = 0; row < table.rows.length; row++ ) {
		var currRow = table.rows[ row ];
		for( var col = 0; col < currRow.cells.length; col++ ) {
			var currCell = currRow.cells[ col ];
			var attr = currCell.attributes.getNamedItem( "writable" );
			if( ( attr != null && attr.value ) && ( currCell.style.display != "none" && currCell.parentNode.style.display != "none" ) ) {
				table.writableCells[ writableCount ] = currCell;
				writableCount++;
			}
		}
	}
}

function _submitEditor( table ) {
	var editor = table.currEditor;
	if( editor != null && editor.editingCell != null ) {
		var disp = editor.value;
		var value = editor.value;
		switch( editor.editingCell.attributes.getNamedItem( "editStyle" ).value ) {
			case "1":
				if( editor.editingCell.attributes.getNamedItem( "digits" ) != null ) {
					var i = 0;
					while( i < value.length ) {
						var ch = value.charAt( i );
						if( isNaN( ch ) && ch != "-" && ch != "+" && ch != "." && ch != "%" ) value = value.substring( 0, i ) + value.substring( i + 1 );
						else i++;
					}
				}
				var inputDataType = editor.editingCell.attributes.getNamedItem( "inputDataType" ).value;
				if( ! _checkDataType( inputDataType, value ) ) return false;
				if( value == editor.oldValue ) value = editor.editingCell.attributes.getNamedItem( "value" ).value;
				editor.style.display = "none";
				break;
			case "2":
			case "3":
				if( editor.selectedIndex < 0 ) {
					disp = editor.editingCell.innerHTML;
					value = editor.editingCell.attributes.getNamedItem( "value" ).value;
				}
				else {
					value = editor.getValue();
					disp = editor.getDisp();
				}
				editor.Table.style.display = "none";
				break;
			default:
				editor.style.display = "none";
		}
		editor.editingCell.innerHTML = _convert( disp, 1 );
		editor.editingCell.attributes.getNamedItem( "value" ).value = value;
		if( editor.editingCell.attributes.getNamedItem( "editStyle" ).value == "1" ) {
			var attr = editor.editingCell.attributes.getNamedItem( "dataValid" );
			if( attr != null && attr.value.length > 0 ) {
				if( ! eval( attr.value ) ) {
					editor.style.display = "block";
					return false;
				}
			}
		}
		editor.editingCell = null;
		table.currEditor = null;
		eval( table.id + "_autoCalc()" );
		_formatData( table );
	}
	return true;
}

function _checkDataType( type, value ) {
	if( value.length == 0 ) return true;
	switch( type ) {
		case "1": return true;
		case "2":
			if( isNaN( value ) ) {
				alert( "ֵ" );
				return false;
			}
			return true;
		case "3":
			var r = value.match(/^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2})$/); 
   			if( r == null ) {
				alert( "Чڣ" );
   				return false; 
   			}
   			var d = new Date( r[1], r[3]-1, r[4] ); 
   			if( ! ( d.getFullYear() == r[1] && ( d.getMonth()+1 ) == r[3] && d.getDate() == r[4] ) ) {
				alert( "Чڣ" );
   				return false; 
   			}
			return true;
		case "4":
			if( isNaN( value ) ) {
				alert( "ȫɵַ" );
				return false;
			}
			return true;
		case "5":
			var pos = value.indexOf( "@" );
			if( pos < 1 || pos == value.length - 1 ) {
				alert( "ȷEmailַ" );
				return false;
			}
			return true;
		case "6":
			if( isNaN( value ) || value.indexOf( "." ) >= 0 ) {
				alert( "ֵ" );
				return false;
			}
			return true;
	}
	return true;
}	

function _hideEditor( event ) {
	var cell = event.target;
	var table = _lookupTable( cell );
	_submitEditor( table );
	try {
		_hiddenCalendar();
	}catch( e ) {}
	try {
		tree_hide();
	}catch( e ) {}
}

function _displayEditor( event ) {
	try {
		_hiddenCalendar();
	}catch( e ) {}
	try {
		tree_hide();
	}catch( e ) {}
	var cell = event.target;
	_bindingEditor( cell );
}

function _bindingEditor( cell ) {
	var table = _lookupTable( cell );
	if( ! _submitEditor( table ) ) return;
	var editor = _lookupEditor( table, cell );
	table.currEditor = editor;
	_setEditorStyle( editor, cell );
}

function _lookupTable( cell ) {
	var table = cell;
	while( table.tagName != "TABLE" ) {
		table = table.parentNode;
	}
	return table;
}

function _lookupEditor( table, cell ) {
	var editStyle = "1";
	var attr = cell.attributes.getNamedItem( "editStyle" );
	if( attr != null ) editStyle = attr.value;
	var editor = null;
	switch( editStyle ) {
		case "0":
			editor = document.getElementById( table.id + "_textArea" );
			if( editor == null ) {
				var border = "";
				try {
					border += "border-left:" + _editorBorderLeft;
					border += ";border-right:" + _editorBorderRight;
					border += ";border-top:" + _editorBorderTop;
					border += ";border-bottom:" + _editorBorderBottom;
				}catch( e ) {
					border = "border: 1px solid red";
				}
				var tmpDiv = document.createElement( "div" );
				document.body.appendChild( tmpDiv );
				tmpDiv.innerHTML = "<textArea id=\"" + table.id + "_textArea\" style=\"position:absolute;" + border + 
					";display:none;zIndex:100\" onkeydown=\"_editorKeyPress( event )\"></textArea>";
				editor = document.getElementById( table.id + "_textArea" );
			}
			editor.value = cell.attributes.getNamedItem( "value" ).value;
			editor.style.display = "block";
			break;
		case "2":
		case "3":
			editor = eval( table.id + "_listBox" );
			if( editor.TitleTable.rows[0].cells[0] == null ) {
				editor = SS_write( "<select style='width:10px'><option></option></select>" );
			}
			attr = cell.attributes.getNamedItem( "editConfig" );
			if( attr != null && attr.value != null ) {
				var configs = attr.value;
				if( configs.indexOf( "ref:" ) == 0 ) configs = document.getElementById( configs.substring( 4 ) ).attributes.getNamedItem( "editConfig" ).value;
				if( editor.configs != configs ) {
					editor.configs = configs;
					editor.clearOptions();
					var items = configs.split( ";" );
					editor.length = items.length;
					for( var i = 0; i < items.length; i++ ) {
						var item = items[i];
						var pos = item.indexOf( "," );
						var value = item.substring( 0, pos );
						var disp = item.substring( pos + 1 );
						editor.insertOption( value, disp, -1 );
					}
				}
			}
			editor.setValue( cell.attributes.getNamedItem( "value" ).value );
			editor.Table.style.display = "block";
			break;
		default:
			editor = document.getElementById( table.id + "_editBox" );
			if( editor == null ) {
				var border = "";
				try {
					border += "border-left:" + _editorBorderLeft;
					border += ";border-right:" + _editorBorderRight;
					border += ";border-top:" + _editorBorderTop;
					border += ";border-bottom:" + _editorBorderBottom;
				}catch( e ) {
					border = "border: 1px solid red";
				}
				var tmpDiv = document.createElement( "div" );
				document.body.appendChild( tmpDiv );
				tmpDiv.innerHTML = "<input type=text id=\"" + table.id + "_editBox\" style=\"position:absolute;" + border + 
					";display:none;zIndex:100\" onkeydown=\"_editorKeyPress( event )\">";
				editor = document.getElementById( table.id + "_editBox" );
			}
			editor.value = _convert( cell.innerHTML, 2 );
			editor.oldValue = _convert( cell.innerHTML, 2 );
			editor.style.display = "block";
	}
	editor.editingCell = cell;
	return editor;
}

function _convert( s, flag ) {
	var re;
	if( flag == 1 ) {
		re = /&/g;
		s = s.replace( re, "&amp;" );
		re = /</g;
		s = s.replace( re, "&lt;" );
		re = />/g;
		s = s.replace( re, "&gt;" );
		re = / /g;
		s = s.replace( re, "&nbsp;" );
		re = /\n/g;
		s = s.replace( re, "<br>" );
	}
	else if( flag == 2 ) {
		re = /&nbsp;/g;
		s = s.replace( re, " " );
		re = /&lt;/g;
		s = s.replace( re, "<" );
		re = /&gt;/g;
		s = s.replace( re, ">" );
		re = /&amp;/g;
		s = s.replace( re, "&" );
	}
	return s;
}

function _setEditorStyle( editor, cell ) {
	var x = cell.offsetLeft, y = cell.offsetTop;
	var obj = cell.offsetParent;
	while( obj.tagName != 'BODY' ) {
		x += obj.offsetLeft;
		y += obj.offsetTop;
		obj = obj.offsetParent;
	}
	var currentStyle = null ;
	for( var i = 0; i < document.styleSheets.length; i++ ) {
		for( var j = 0; j < document.styleSheets[i].cssRules.length; j++ ) {
			if( document.styleSheets[i].cssRules[j].selectorText == "." + cell.className ) {
				currentStyle = document.styleSheets[i].cssRules[j].style;
				break;
			}
		}
		if( currentStyle != null ) break;
	}
	switch( cell.attributes.getNamedItem( "editStyle" ).value ) {
		case "2":
		case "3":
			editor.setBackColor( currentStyle.backgroundColor );
			editor.setFontWeight( currentStyle.fontWeight );
			editor.setFontColor( currentStyle.color );
			editor.setFontFace( currentStyle.fontFamily );
			editor.setFontItalic( currentStyle.fontStyle );
			editor.setFontSize( currentStyle.fontSize );
			editor.setLeft( x );
			editor.setTop( y );
			editor.setWidth( cell.offsetWidth );
			editor.setHeight( cell.offsetHeight );
			break;
		default:
			editor.style.textAlign = currentStyle.textAlign;
			editor.style.backgroundColor = currentStyle.backgroundColor;
			editor.style.paddingLeft = currentStyle.paddingLeft;
			editor.style.paddingRight = currentStyle.paddingRight;
			editor.style.fontWeight = currentStyle.fontWeight;
			editor.style.color = currentStyle.color;
			editor.style.fontFamily = currentStyle.fontFamily;
			editor.style.fontStyle = currentStyle.fontStyle;
			editor.style.fontSize = currentStyle.fontSize;
			editor.style.textDecoration = currentStyle.textDecoration;
			editor.style.verticalAlign = currentStyle.verticalAlign;
			editor.style.left = x - 1;
			editor.style.top = y - 1;
			editor.style.width = cell.offsetWidth + 1;
			editor.style.height = cell.offsetHeight + 1;
			editor.focus();
	}	
}

function _editorKeyPress( event ) {
	var keyCode = event.keyCode;
	var flag = -1;
	var gotoNext = false;
	var editor = event.target;
	if( keyCode == 39 && event.ctrlKey ) {  //right
		flag = 3;
		gotoNext = true;
	}
	if( keyCode == 13 ) {
		flag = 3;
		gotoNext = true;
		if( editor.tagName == "TEXTAREA" && !event.ctrlKey ) gotoNext = false;
	}
	if( keyCode == 37 && event.ctrlKey ) {  //left
		flag = 1;
		gotoNext = true;
	}
	if( keyCode == 9 ) {
		flag = event.shiftKey ? 1 : 3;
		gotoNext = true;
	}
	if( keyCode == 38 || keyCode == 40 ) {
		if( keyCode == 38 ) flag = 2;
		if( keyCode == 40 ) flag = 4;
		gotoNext = true;
		if( editor.tagName == "TEXTAREA" && !event.ctrlKey ) gotoNext = false;
	}
	if( gotoNext ) {
		var cell = _lookupNextCell( editor.editingCell, flag );
		if( cell != null ) _bindingEditor( cell );
	}
	if( keyCode == 9 ) return false;
	return true;
}

function _lookupNextCell( cell, flag ) {
	var table = _lookupTable( cell );
	var nextCell = null;
	if( flag == 1 || flag == 3 ) {  //left || right
		for( var i = 0; i < table.writableCells.length; i++ ) {
			if( table.writableCells[i] == cell ) {
				if( flag == 3 ) {
					nextCell = table.writableCells[ i + 1 ];
					if( nextCell == null ) nextCell = table.writableCells[0];
				}
				if( flag == 1 ) {
					nextCell = table.writableCells[ i - 1 ];
					if( nextCell == null ) nextCell = table.writableCells[ table.writableCells.length - 1 ];
				}
				break;
			}
		}
	}
	else {  //2-up  4-down
		var delta = 1;
		if( flag == 2 ) delta = -1;
		var s = cell.id.substring( cell.id.lastIndexOf( "_" ) + 1 );
		var rc = _toRowCol( s );
		var row = rc[0], col = rc[1];
		if( flag == 4 ) row = row + cell.rowSpan - 1;
		while( true ) {
			row += delta;
			if( row < 1 || row > table.rows.length ) return null;
			var tmpCell = null;
			tmpCell = document.getElementById( table.id + "_" + _toExcelNotation( row, col ) );
			if( tmpCell == null ) {
				tmpCell = _getMergeCell( table, row, col );
				if( tmpCell == null ) return null;
			}
			var attr = tmpCell.attributes.getNamedItem( "writable" );
			if( ! ( attr != null && attr.value ) || tmpCell.style.display == "none" || tmpCell.parentNode.style.display == "none" ) {
				if( flag == 4 ) row = row + tmpCell.rowSpan - 1;
				if( flag == 2 ) row = row - tmpCell.rowSpan + 1;
			}
			else {
				nextCell = tmpCell;
				break;
			}
		}
	}
	return nextCell;
}

function _getMergeCell( table, row, col ) {  //ذ(row,col)Ԫĺϲ
	for( var i = 0; i < table.rows.length; i++ ) {
		var r = table.rows[i];
		for( var j = 0; j < r.cells.length; j++ ) {
			var c = r.cells[j];
			if( c.colSpan == 1 && c.rowSpan == 1 ) continue;
			var s = c.id.substring( c.id.lastIndexOf( "_" ) + 1 );
			var rc = _toRowCol( s );
			var row1 = rc[0], col1 = rc[1];
			if( row1 <= row && row1 + c.rowSpan > row && col1 <= col && col1 + c.colSpan > col ) return c;
		}
	}
	return null;
}

function _toExcelNotation( row, col ) {
	var s = "";
	do {
		col--;
		var c = col % 26 + "A".charCodeAt(0);
		s = String.fromCharCode( c ) + s;
		col = Math.floor( col / 26 );
	} while ( col > 0 );
	return s + row;
}

function _toRowCol( s ) {
	var len = s.length;
	var row = 0, col = 0;
	var i = 0;
	while( i < len ) {
		var ch = s.charAt(i);
		if ( ch >= 'A' && ch <= 'Z' ) 
			col = col * 26 + ch.charCodeAt(0) - 'A'.charCodeAt(0) + 1;
		else break;
		i++;
	}
	row = parseInt( s.substring( i ) );
	var rc = new Array(2);
	rc[0] = row;
	rc[1] = col;
	return rc;
}

function _submitTable( table, resultInfoPage ) {
	if( ! _submitEditor( table ) ) return;
	if( ! eval( table.id + "_checkValid()" ) ) {  //ЧԼ
		try {
			if( batImport ) {
				parent.getResultInfo( "error", "ݲЧҪ" );
			}
		}catch(ex){}
		return;
	}
	try {
		if( ! eval( table.id + "_userDefineValidScript()" ) ) return;
	}catch( exception ) {}
	var form = document.getElementById( table.id + "_submitForm" );
	var data = "", originData = "";
	for( var row = 0; row < table.rows.length; row++ ) {
		var currRow = table.rows[ row ];
		for( var col = 0; col < currRow.cells.length; col++ ) {
			var currCell = currRow.cells[ col ];
			var name = currCell.id;
			name = name.substring( name.lastIndexOf( "_" ) + 1 );
			var attr = currCell.attributes.getNamedItem( "value" );
			var value = "";
			if( attr != null ) value = attr.value;
			else value = currCell.value;
			if( value == null ) value = "";
			attr = currCell.attributes.getNamedItem( "keyCell" );
			if( attr != null && attr.value ) {
				if( data.length > 0 ) data += ";";
				data += name + "=" + _addEscape( value );
				attr = currCell.attributes.getNamedItem( "originValue" );
				var origin = "";
				if( attr != null ) origin = attr.value;
				if( originData.length > 0 ) originData += ";";
				originData += name + "=" + _addEscape( origin );
			}
			else {
				attr = currCell.attributes.getNamedItem( "updatable" );
				if( attr != null && attr.value ) {
					if( data.length > 0 ) data += ";";
					data += name + "=" + _addEscape( value );
				}
			}
		}
	}
	form.data.value = data;
	form.originData.value = originData;
	try {
		if( batImport ) {
			form.pageUrl.value = resultInfoPage;
			form.backAndRefresh.value = "batImport";
		}
	}catch( e ) {}
	form.submit();
}

function _submitReport( table ) {
	if( ! _submitEditor( table ) ) return;
	var form = document.getElementById( table.id + "_submitForm" );
	var data = "", originData = "";
	for( var row = 0; row < table.rows.length; row++ ) {
		var currRow = table.rows[ row ];
		for( var col = 0; col < currRow.cells.length; col++ ) {
			var currCell = currRow.cells[ col ];
			var name = currCell.id;
			name = name.substring( name.lastIndexOf( "_" ) + 1 );
			var attr = currCell.attributes.getNamedItem( "value" );
			var value = "";
			if( attr != null ) value = attr.value;
			else value = currCell.value;
			if( value == null ) value = "";
			attr = currCell.attributes.getNamedItem( "keyCell" );
			if( attr != null && attr.value ) {
				if( data.length > 0 ) data += ";";
				data += name + "=" + _addEscape( value );
				attr = currCell.attributes.getNamedItem( "originValue" );
				var origin = "";
				if( attr != null ) origin = attr.value;
				if( originData.length > 0 ) originData += ";";
				originData += name + "=" + _addEscape( origin );
			}
			else {
				attr = currCell.attributes.getNamedItem( "updatable" );
				if( attr != null && attr.value ) {
					if( data.length > 0 ) data += ";";
					data += name + "=" + _addEscape( value );
				}
			}
		}
	}
	form.data.value = data;
	form.originData.value = originData;
	form.submit();
}

function _addEscape( src ) {
	try {
		var re = /\\/g;
		src = src.replace( re, "\\\\" );
		re = /\"/g;
		src = src.replace( re, "\\\"" );
		return "\"" + src + "\"";
	}catch( exception ) {
		return "\"" + src + "\"";
	}
}

function _parseValue( cell ) {
	var value = "";
	attr = cell.attributes.getNamedItem( "value" );
	if( attr != null ) value = parseFloat( attr.value );
	else {
		try { value = parseFloat( cell.value ); } catch(e){}
	}
	attr = cell.attributes.getNamedItem( "digits" );
	if( attr != null ) {
		if( ! isNaN( value ) ) value = parseFloat( value.toFixed( parseInt( attr.value ) ) );
	}
	return isNaN( value ) ? 0 : value;
}

function _formatData( table ) {
	for( var row = 0; row < table.rows.length; row++ ) {
		var currRow = table.rows[ row ];
		for( var col = 0; col < currRow.cells.length; col++ ) {
			var currCell = currRow.cells[ col ];
			var attr = currCell.attributes.getNamedItem( "digits" );
			if( attr != null ) {
				var attr1 = currCell.attributes.getNamedItem( "value" );
				var value = "";
				if( attr1 != null ) value = parseFloat( attr1.value );
				else {
					try { value = parseFloat( currCell.value ); }catch(e){}
				}
				if( ! isNaN( value ) ) {
					value = value.toFixed( parseInt( attr.value ) );
					if( attr1 != null ) attr1.value = value + "";
					else currCell.value = value + "";
					//currCell.innerHTML = value;
				}
			}
		}
	}
}

function _formatCalcValue( cell ) {
	var attr = cell.attributes.getNamedItem( "digits" );
	if( attr != null ) {
		var attr1 = cell.attributes.getNamedItem( "value" );
		var value = "";
		if( attr1 != null ) value = parseFloat( attr1.value );
		else {
			try { value = parseFloat( cell.value ); }catch(e){}
		}
		if( ! isNaN( value ) ) {
			value = value.toFixed( parseInt( attr.value ) );
			cell.innerHTML = value;
		}
	}
}

function _uploadFile( url, table, update, keyValues, updateValues, ext ) {
	if( update.length == 0 ) {
		alert( "˵ԪûдãԺ!" );
		return;
	}
	var data = "";
	var originData = "";
	var keys = keyValues.split( "," );
	for( var i = 0; i < keys.length; i++ ) {
		var key = keys[i].toUpperCase();
		var cell = document.getElementById( table.id + "_" + key );
		if( cell == null ) {
			alert( "ؼֶȡֵԪ" + key + "ڣ" + update );
			return;
		}
		var attr = cell.attributes.getNamedItem( "value" );
		if( attr == null || attr.value.length == 0 ) {
			alert( "ؼֶεԪ" + key + "δֵ" );
			return;
		}
		if( data.length > 0 ) data += ";";
		data += key + "=" + attr.value;
		attr = cell.attributes.getNamedItem( "originValue" );
		if( attr != null ) {
			if( originData.length > 0 ) originData += ";";
			originData += key + "=" + attr.value;
		}
	}
	var cols = updateValues.split( "," );
	for( var i = 0; i < cols.length; i++ ) {
		var col = cols[i].toUpperCase();
		var cell = document.getElementById( table.id + "_" + col );
		if( cell == null ) {
			alert( "ɸֶȡֵԪ" + col + "ڣ" + update );
			return;
		}
		var attr = cell.attributes.getNamedItem( "keyCell" );
		if( attr != null && attr.value ) continue;
		attr = cell.attributes.getNamedItem( "value" );
		var value = "";
		if( attr != null ) value = attr.value;
		else value = cell.value;
		if( value == null ) value = "";
		if( data.length > 0 ) data += ";";
		data += col + "=" + value;
	}
	url += "?update=" + _urlEncode( update ) + "&data=" + _urlEncode( data ) + "&originData=" + _urlEncode( originData ) + "&ext=" + _urlEncode( ext );
	window.open( url, "", "left=200, top=250, height=180, width=400, status=no, resizable=yes" );
}

function _uploadPrompt( display, event ) {
	var promptBox = document.getElementById( "___promptBox" );
	if( promptBox == null ) {
		var tmpDiv = document.createElement( "div" );
		document.body.appendChild( tmpDiv );
		tmpDiv.innerHTML = "<table id=___promptBox style=\"display:none; BACKGROUND-COLOR: mistyrose; BORDER: blue 1px solid; FONT-FAMILY: ; FONT-SIZE: 13px; HEIGHT: 26px; POSITION: absolute; WIDTH: 80px\">" +
							"<tr><td align=middle>˫ļ</td></tr></table>";
		promptBox = document.getElementById( "___promptBox" );
	}
	promptBox.style.left = event.pageX + 10;
	promptBox.style.top = event.pageY + 5;
	promptBox.style.display = display;
}

function _urlEncode( str )
{
	var dst = "";
	for ( var i = 0; i < str.length; i++ )
	{
		switch ( str.charAt( i ) )
		{
			case ' ':
				dst += "+";
				break;
			case '!':
				dst += "%21";
				break;
			case '\"':
				dst += "%22";
				break;
			case '#':
				dst += "%23";
				break;
			case '$':
				dst += "%24";
				break;
			case '%':
				dst += "%25";
				break;
			case '&':
				dst += "%26";
				break;
			case '\'':
				dst += "%27";
				break;
			case '(':
				dst += "%28";
				break;
			case ')':
				dst += "%29";
				break;
			case '+':
				dst += "%2B";
				break;
			case ',':
				dst += "%2C";
				break;
			case '/':
				dst += "%2F";
				break;
			case ':':
				dst += "%3A";
				break;
			case ';':
				dst += "%3B";
				break;
			case '<':
				dst += "%3C";
				break;
			case '=':
				dst += "%3D";
				break;
			case '>':
				dst += "%3E";
				break;
			case '?':
				dst += "%3F";
				break;
			case '@':
				dst += "%40";
				break;
			case '[':
				dst += "%5B";
				break;
			case '\\':
				dst += "%5C";
				break;
			case ']':
				dst += "%5D";
				break;
			case '^':
				dst += "%5E";
				break;
			case '`':
				dst += "%60";
				break;
			case '{':
				dst += "%7B";
				break;
			case '|':
				dst += "%7C";
				break;
			case '}':
				dst += "%7D";
				break;
			case '~':
				dst += "%7E";
				break;
			default:
				dst += str.charAt( i );
				break;
		}
	}
	return dst;
}

function switchCase() {
	var len = arguments.length;
	if( len < 4 ) {
		alert( "switchCase̫٣Ӧ4ȷʽΪ\n\nswitchCase( , ֵ1, ֵ1, [ֵ2, ֵ2, ......]ȱʡֵ )" );
		return;
	}
	if( arguments[0] == arguments[1] ) return arguments[2];
	if( len > 4 ) {
		if( len % 2 == 1 ) {
			alert( "switchCaseӦΪ˫ȷʽΪ\n\nswitchCase( , ֵ1, ֵ1, [ֵ2, ֵ2, ......]ȱʡֵ )" );
			return;
		}
		var i = 3;
		while( true ) {
			if( arguments[i] != null && arguments[i+1] != null ) {
				if( arguments[0] == arguments[i] ) return arguments[i+1];
			}
			else break;
			i += 2;
		}
		
	}
	return arguments[ len - 1 ]; 
}
	
function _getScriptFunctions() {
	var html = "<script language=javascript>\n";
	html += _initInput.toString() + "\n";
	html += _submitEditor.toString() + "\n";
	html += _checkDataType.toString() + "\n";
	html += _hideEditor.toString() + "\n";
	html += _displayEditor.toString() + "\n";
	html += _bindingEditor.toString() + "\n";
	html += _lookupTable.toString() + "\n";
	html += _lookupEditor.toString() + "\n";
	html += _convert.toString() + "\n";
	html += _setEditorStyle.toString() + "\n";
	html += _editorKeyPress.toString() + "\n";
	html += _lookupNextCell.toString() + "\n";
	html += _getMergeCell.toString() + "\n";
	html += _toExcelNotation.toString() + "\n";
	html += _toRowCol.toString() + "\n";
	html += _submitTable.toString() + "\n";
	html += _submitReport.toString() + "\n";
	html += _addEscape.toString() + "\n";
	html += _parseValue.toString() + "\n";
	html += _formatData.toString() + "\n";
	html += _formatCalcValue.toString() + "\n";
	html += _uploadFile.toString() + "\n";
	html += _uploadPrompt.toString() + "\n";
	html += _urlEncode.toString() + "\n";
	html += switchCase.toString() + "\n";
	html += _getScriptFunctions.toString() + "\n";
	html += _saveToLocal.toString() + "\n";
	html += _tabClicked.toString() + "\n";
	html += _submitSheets.toString() + "\n";
	html += _saveSheetsToLocal.toString() + "\n";
	html += _toDate.toString() + "\n";
	try {
		SS_create.toString();
		html += "\t\tif( SS_VAR == null ) {\n";
		html += "\t\t\tvar SS_VAR = new Object();\n";
		html += "\t\t\tSS_VAR.DivDummy = document.createElement(\"DIV\");\n";
		html += "\t\t\tSS_VAR.SelectList = new Array();\n";
		html += "\t\t\tSS_VAR.bEventAttached = false;\n";
		html += "\t\t\tvar SS_CreatedElements = new Object();\n";
		html += "\t\t}\n";
		html += SS_create.toString() + "\n";
		html += SS_getValue.toString() + "\n";
		html += SS_setValue.toString() + "\n";
		html += SS_getDisp.toString() + "\n";
		html += SS_setHeight.toString() + "\n";
		html += SS_setWidth.toString() + "\n";
		html += SS_setLeft.toString() + "\n";
		html += SS_setTop.toString() + "\n";
		html += SS_setFontFace.toString() + "\n";
		html += SS_setFontColor.toString() + "\n";
		html += SS_setFontSize.toString() + "\n";
		html += SS_setFontWeight.toString() + "\n";
		html += SS_setFontItalic.toString() + "\n";
		html += SS_setBackColor.toString() + "\n";
		html += SS_display.toString() + "\n";
		html += SS_write.toString() + "\n";
		html += SS_insertOption.toString() + "\n";
		html += SS_clearOptions.toString() + "\n";
		html += SS_changeOption.toString() + "\n";
		html += SS_cancelEvent.toString() + "\n";
		html += SS_isThisEventToBeCanceled.toString() + "\n";
		html += SS_createElement.toString() + "\n";
		html += SS_blurExcept.toString() + "\n";
		html += SS_syncSelectedIndex.toString() + "\n";
		html += SS_toggleTitle.toString() + "\n";
		html += SS_toggleOptions.toString() + "\n";
		html += SS_handlePropertychange.toString() + "\n";
		html += SS_handleMousewheel.toString() + "\n";
		html += SS_handleOverTitle.toString() + "\n";
		html += SS_handleOutTitle.toString() + "\n";
		html += SS_handleOverOption.toString() + "\n";
		html += SS_turnOnOption.toString() + "\n";
		html += SS_turnOffOption.toString() + "\n";
		html += SS_adjustOptionsDiv.toString() + "\n";
		html += SS_syncOptions.toString() + "\n";
		html += SS_pressTitle.toString() + "\n";
		html += SS_releaseTitle.toString() + "\n";
		html += SS_pressOption.toString() + "\n";
		html += SS_moveOption.toString() + "\n";
		html += SS_releaseOption.toString() + "\n";
		html += SS_createTable.toString() + "\n";
		html += SS_createTitleDiv.toString() + "\n";
		html += SS_createOptionsDiv.toString() + "\n";
		html += SS_createOptionTr.toString() + "\n";
	} catch( e ) {}
	try {
		html += _createRunqianCalendar.toString() + "\n";
		html += _runqianCalendar.toString() + "\n";
		html += _createIframeSyntax.toString() + "\n";
		html += _showCalendar.toString() + "\n";
		html += _funMonthSelect.toString() + "\n";
		html += _prevMonth.toString() + "\n";
		html += _nextMonth.toString() + "\n";
		html += _prevYear.toString() + "\n";
		html += _nextYear.toString() + "\n";
		html += _hiddenSelect.toString() + "\n";
		html += _hiddenCalendar.toString() + "\n";
		html += _appendZero.toString() + "\n";
		html += _trimString.toString() + "\n";
		html += _dayMouseOver.toString() + "\n";
		html += _dayMouseOut.toString() + "\n";
		html += _writeCalendar.toString() + "\n";
		html += _returnDate.toString() + "\n";
		html += _changeYear.toString() + "\n";
	} catch( e ) {}
	try {
		html += tree_iconClick.toString() + "\n";
		html += tree_mouseOver.toString() + "\n";
		html += tree_mouseOut.toString() + "\n";
		html += tree_select.toString() + "\n";
		html += tree_show.toString() + "\n";
		html += tree_hide.toString() + "\n";
	} catch( e ) {}
	html += "</scr" + "ipt>\n";
	return html;
}	

function _saveToLocal( table, name ) {
	if( ! _submitEditor( table ) ) return;
	var html = "<html>\n<body>\n";
	html += _getScriptFunctions();
	try {
		while( my___select.length ) {
			my___select[0].outerHTML = "";
		}
		my___select.outerHTML = "";
	}catch( e ) {}
	try {
		while( _runqianCalendar.length ) {
			_runqianCalendar[0].outerHTML = "";
		}
		_runqianCalendar.outerHTML = "";
	}catch( e ) {}
	html += eval( "div_" + table.id ).outerHTML + "\n";
	html += "<SCRIPT language=javascript>\n";
	html += "\tvar batImport = document.location.href.indexOf( \"?batImport\" ) > 0;\n";
	html += "\tvar resultInfoPage = parent.location.href.substring( 0, parent.location.href.lastIndexOf( \"/\" ) ) + \"/getResultInfo.html\";\n";
	html += "\tif( batImport ) _submitTable( " + table.id + ", resultInfoPage );\n";
	html += "</SCR" + "IPT>\n";
	html += "</body>\n</html>";
	try {
		var fso = new ActiveXObject( "Scripting.FileSystemObject" );
		var fileDialog;
		try {
			fileDialog = eval( "_fileDialog" );
		}catch( exception ) {
			document.body.insertAdjacentHTML( "AfterBegin", "<object id=\"_fileDialog\" width=\"0px\" height=\"0px\" classid=\"clsid:F9043C85-F6F2-101A-A3C9-08002B2F49FB\" codebase=\"http://activex.microsoft.com/controls/vb5/comdlg32.cab\"></object>" );
			fileDialog = eval( "_fileDialog" );
		}
	  	fileDialog.Filter = "HTML Files (*.html) | *.html";
		fileDialog.filename = name;
		fileDialog.ShowSave();
		var f = fso.CreateTextFile( fileDialog.filename, true );
		f.writeLine( html );
		f.Close();
	}catch( exception ) {
		var form = eval( table.id + "_saveToLocalForm" );
		form.fileContent.value = html;
		form.saveAsName.value = name;
		form.submit();
	}
}

function _tabClicked( tab, sheetName ) {
	var tabs = eval( "tabs_" + sheetName );
	var currTab = eval( tabs.currTab );
	if( ! _submitEditor( eval( currTab.report ) ) ) return;
	currTab.style.backgroundColor = tabs.bkColor;
	currTab.style.color = tabs.fontColor;
	tab.style.backgroundColor = tabs.bkHLColor;
	tab.style.color = tabs.fontHLColor;
	eval( currTab.report ).style.display = "none";
	eval( tab.report ).style.display = "block";
	tabs.currTab = tab.id;
}

function _submitSheets( sheets ) {
	var tabs = eval( "tabs_" + sheets.id );
	if( ! _submitEditor( eval( eval( tabs.currTab ).report ) ) ) return;
	var tables = sheets.tables.split( "," );
	for( var i = 0; i < tables.length; i++ ) {
		if( ! eval( tables[i] + "_checkValid()" ) ) {  //ЧԼ
			return;
		}
	}
	if( ! eval( sheets.id + "_sheetsValid()" ) ) {   //ЧԼ
		return;
	}
	try {    //ûԶЧԼ
		if( ! eval( sheets.id + "_userDefineValidScript()" ) ) return;
	}catch( exception ) {}
	
	var form = eval( sheets.id + "_submitForm" );
	for( var i = 0; i < tables.length; i++ ) {
		var table = eval( tables[i] );
		var data = "", originData = "";
		for( var row = 0; row < table.rows.length; row++ ) {
			var currRow = table.rows[ row ];
			for( var col = 0; col < currRow.cells.length; col++ ) {
				var currCell = currRow.cells[ col ];
				var name = currCell.id;
				name = name.substring( name.lastIndexOf( "_" ) + 1 );
				var value = currCell.value;
				if( value == null ) value = "";
				if( currCell.keyCell ) {
					if( data.length > 0 ) data += ";";
					data += name + "=" + _addEscape( value );
					var origin = currCell.originValue;
					if( origin == null ) origin = "";
					if( originData.length > 0 ) originData += ";";
					originData += name + "=" + _addEscape( origin );
				}
				else if( currCell.updatable ) {
					if( data.length > 0 ) data += ";";
					data += name + "=" + _addEscape( value );
				}
			}
		}
		form.item( tables[i] + "_data" ).value = data;
		form.item( tables[i] + "_originData" ).value = originData;
	}
	form.submit();
}

function _saveSheetsToLocal( sheets, name ) {
	var tabs = eval( "tabs_" + sheets.id );
	if( ! _submitEditor( eval( eval( tabs.currTab ).report ) ) ) return;
	var html = "<html>\n<body>\n";
	html += _getScriptFunctions();
	if( SS_VAR != null ) {
		while( my___select.length ) {
			my___select[0].outerHTML = "";
		}
		my___select.outerHTML = "";
	}
	html += sheets.outerHTML + "\n";
	html += "<SCRIPT language=javascript>\n";
	html += "\tvar batImport = document.location.href.indexOf( \"?batImport\" ) > 0;\n";
	html += "\tif( batImport ) _submitSheets( " + sheets.id + " );\n";
	html += "</SCR" + "IPT>\n";
	html += "</body>\n</html>";
	try {
		var fso = new ActiveXObject( "Scripting.FileSystemObject" );
		var fileDialog;
		try {
			fileDialog = eval( "_fileDialog" );
		}catch( exception ) {
			document.body.insertAdjacentHTML( "AfterBegin", "<object id=\"_fileDialog\" width=\"0px\" height=\"0px\" classid=\"clsid:F9043C85-F6F2-101A-A3C9-08002B2F49FB\" codebase=\"http://activex.microsoft.com/controls/vb5/comdlg32.cab\"></object>" );
			fileDialog = eval( "_fileDialog" );
		}
	  	fileDialog.Filter = "HTML Files (*.html)|*.html";
		fileDialog.filename = name;
		fileDialog.ShowSave();
		var f = fso.CreateTextFile( fileDialog.filename, true );
		f.writeLine( html );
		f.Close();
	}catch( exception ) {
		var form = eval( sheets.id + "_saveToLocalForm" );
		form.fileContent.value = html;
		form.saveAsName.value = name;
		form.submit();
	}
}

function _toDate( s ) {
	var re = /\./g;
	s = s.replace( re, "/" );
	re = /-/g;
	s = s.replace( re, "/" );
	var ymr = s.split( "/" );
	return new Date( ymr[1] + "-" + ymr[2] + "-" + ymr[0] );
}
