function _hideRow( belongToCell, row ) {
	var isGroupRow = false;
	for( var col = 0; col < row.cells.length; col++ ) {
		var cell = row.cells[ col ];
		if( cell == belongToCell ) isGroupRow = true;
		if( ! row.hide && cell.rowSpan < 2 ) cell.style.display = "none";
	}
	if( ! row.hide ) {
		var cells = row.crossCells;
		for( var i = 0; i < cells.length; i++ ) {
			var cell = cells[i];
			if( cell.tempRowSpan == 1 ) cell.style.display = "none";
			cell.tempRowSpan = cell.tempRowSpan - 1;
		}
	}
	if( ! isGroupRow ) row.style.display = "none";
	row.hide = true;
}

function _showRow( row ) {
	if( ! row.hide ) return;
	var table = row.parentElement;
	while( table.tagName != "TABLE" ) table = table.parentElement;
	var cells = row.crossCells;
	var needShow = true;
	for( var i = 0; i < cells.length; i++ ) {
		var cell = cells[i];
		if( ! cell.hideRows ) continue;
		if( cell.extended ) continue;
		var hideRows = cell.hideRows.split( "," );
		var includeThisRow = false;
		for( var j = 0; j < hideRows.length; j++ ) {
			var r = null;
			try {
				r = eval( table.id + "_row" + hideRows[j] );
			}catch( exception ) {}
			if( r == row ) {
				includeThisRow = true;
				break;
			}
		}
		if( includeThisRow ) {
			needShow = false;
			break;
		}
	}
	if( ! needShow ) return;
	
	row.style.display = "";
	for( var col = 0; col < row.cells.length; col++ ) {
		var cell = row.cells[ col ];
		cell.style.display = "";
	}
	for( var i = 0; i < cells.length; i++ ) {
		var cell = cells[i];
		cell.style.display = "";
		cell.tempRowSpan = cell.tempRowSpan + 1;
		cell.parentElement.style.display = "";
	}
	row.hide = false;
}

function _lookupCellsCrossRow( row ) {
	var cells = new Array();
	var table = row.parentElement;
	while( table.tagName != "TABLE" ) table = table.parentElement;
	var count = 0;
	for( var i = 0; i < table.rows.length; i++ ) {
		if( i > row.rowIndex ) break;
		var r = table.rows[i];
		for( var j = 0; j < r.cells.length; j++ ) {
			var cell = r.cells[j];
			if( cell.rowSpan < 2 ) continue;
			if( cell.rowSpan + i - 1 >= row.rowIndex ) {
				cells[ count ] = cell;
				count++;
			}
		}
	}
	return cells;
}

function _initDrill( table ) {
	for( var i = 0; i < table.rows.length; i++ ) {
		var row = table.rows[i];
		row.crossCells = _lookupCellsCrossRow( row );
	}
	for( var i = 0; i < table.rows.length; i++ ) {
		var row = table.rows[i];
		for( var j = 0; j < row.cells.length; j++ ) {
			_foldCell( row.cells[j] );
		}
	}
}

function _foldCell( cell ) {
	if( ! cell.hideRows ) return;
	cell.extended = false;
	var table = _lookupTable( cell );
	var rows = cell.hideRows.split( "," );
	for( var i = 0; i < rows.length; i++ ) {
		var row = null;
		try {
			row = eval( table.id + "_row" + rows[i] );
		}catch( exception ) {}
		if( row == null ) continue;
		_hideRow( cell, row );
	}
	cell.childNodes(0).style.display = "";
	cell.childNodes(1).style.display = "none";
}

function _extendCell( cell ) {
	if( ! cell.hideRows ) return;
	cell.extended = true;
	var table = _lookupTable( cell );
	var rows = cell.hideRows.split( "," );
	for( var i = 0; i < rows.length; i++ ) {
		var row = null;
		try {
			row = eval( table.id + "_row" + rows[i] );
		}catch( exception ) {}
		if( row == null ) continue;
		_showRow( row );
	}
	cell.childNodes(0).style.display = "none";
	cell.childNodes(1).style.display = "";
}

function _lookupTable( cell ) {
	var table = cell;
	while( table.tagName != "TABLE" ) {
		table = table.parentElement;
	}
	return table;
}
