function _hideRow( belongToCell, row ) {
	//if( belongToCell == document.getElementById( "report1_B3" ) ) alert( "haha" );
	var isGroupRow = false;
	for( var col = 0; col < row.cells.length; col++ ) {
		var cell = row.cells[ col ];
		if( cell == belongToCell ) isGroupRow = true;
		if( ! row.hide && cell.rowSpan < 2 ) cell.style.display = "none";
	}
	if( ! row.hide ) {
		var cells = row.crossCells;
		for( var i = 0; i < cells.length; i++ ) {
			var cell = cells[i];
			if( cell.rowSpan < 2 ) cell.style.display = "none";
			if( cell != belongToCell || !isGroupRow ) cell.rowSpan -= 1;
		}
	}
	if( ! isGroupRow ) row.style.display = "none";
	else {
		if( row.style.height != "0px" ) row.oldHeight = row.style.height;
		row.style.height = "0px";	
	}
	row.hide = true;
}

function _showRow( row, extendCell ) {
	if( ! row.hide ) return;
	var table = row.parentNode;
	while( table.tagName != "TABLE" ) table = table.parentNode;
	var cells = row.crossCells;
	var needShow = true;
	for( var i = 0; i < cells.length; i++ ) {
		var cell = cells[i];
		if( cell.attributes.getNamedItem( "hideRows" ) == null ) continue;
		if( cell.extended ) continue;
		var hideRows = cell.attributes.getNamedItem( "hideRows" ).value.split( "," );
		var includeThisRow = false;
		for( var j = 0; j < hideRows.length; j++ ) {
			var r = document.getElementById( table.id + "_row" + hideRows[j] );
			if( r == row ) {
				includeThisRow = true;
				break;
			}
		}
		if( includeThisRow ) {
			needShow = false;
			break;
		}
	}
	if( ! needShow ) return;
	
	
	for( var i = 0; i < cells.length; i++ ) {
		var cell = cells[i];
		if( cell.style.display == "none" ) {
			for( var j = 0; j < cells.length; j++ ) {
				if( cells[j] == cell ) continue;
				if( cell.parentNode != cells[j].parentNode && cells[j].style.display != "none" 
					&& extendCell.parentNode != cell.parentNode ) cells[j].rowSpan += 1;
			}
		}
		if( cell.parentNode != row && row.style.display == "none" ) cell.rowSpan += 1;
		cell.style.display = "";
		cell.parentNode.style.display = "";
	}
	for( var col = 0; col < row.cells.length; col++ ) {
		var cell = row.cells[ col ];
		cell.style.display = "";
	}
	row.style.display = "";
	if( row.style.height == "0px" ) {
		row.style.height = row.oldHeight;
	}
	row.hide = false;
}

function _lookupCellsCrossRow( row ) {
	var cells = new Array();
	var table = row.parentNode;
	while( table.tagName != "TABLE" ) table = table.parentNode;
	var count = 0;
	for( var i = 0; i < table.rows.length; i++ ) {
		if( i > row.rowIndex ) break;
		var r = table.rows[i];
		for( var j = 0; j < r.cells.length; j++ ) {
			var cell = r.cells[j];
			if( cell.rowSpan < 2 ) continue;
			if( cell.rowSpan + i - 1 >= row.rowIndex ) {
				cells[ count ] = cell;
				count++;
			}
		}
	}
	return cells;
}

function _initDrill( table ) {
	for( var i = 0; i < table.rows.length; i++ ) {
		var row = table.rows[i];
		row.crossCells = _lookupCellsCrossRow( row );
	}
	for( var i = 0; i < table.rows.length; i++ ) {
		var row = table.rows[i];
		for( var j = 0; j < row.cells.length; j++ ) {
			_foldCell( row.cells[j] );
		}
	}
}

function _foldCell( cell ) {
	var attr = cell.attributes.getNamedItem( "hideRows" );
	if( attr == null ) return;
	cell.extended = false;
	var table = _lookupTable( cell );
	var rows = attr.value.split( "," );
	for( var i = 0; i < rows.length; i++ ) {
		var row = document.getElementById( table.id + "_row" + rows[i] );
		if( row == null ) continue;
		_hideRow( cell, row );
	}
	cell.childNodes[0].style.display = "";
	cell.childNodes[1].style.display = "none";
}

function _extendCell( cell ) {
	var attr = cell.attributes.getNamedItem( "hideRows" );
	if( attr == null ) return;
	cell.extended = true;
	var table = _lookupTable( cell );
	var rows = attr.value.split( "," );
	for( var i = 0; i < rows.length; i++ ) {
		var row = document.getElementById( table.id + "_row" + rows[i] );
		if( row == null ) continue;
		_showRow( row, cell );
	}
	cell.childNodes[0].style.display = "none";
	cell.childNodes[1].style.display = "";
}

function _lookupTable( cell ) {
	var table = cell;
	while( table.tagName != "TABLE" ) {
		table = table.parentNode;
	}
	return table;
}
