/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.client650;

import ilog.jum.IluUrlParams;
import ilog.jum.client650.IluJumServerUtil;
import ilog.jum.client650.IluReport;
import ilog.jum.client650.IluSAMLogger;
import ilog.jum.client650.IluThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class IluConnectionThread
extends IluThread
implements IluUrlParams {
    private static final String SHOW_REPORT_IN_CONSOLE_PROPERTY = "ilog.sam.show-report-in-console";
    private static final String THREAD_NAME_PREFIX = "ilog.sam.connection.";
    private static final int NB_THREADS_MAX = 2;
    private final String fUrlString;
    private final IluReport fReport;
    private final IluSAMLogger fLog;
    private URLConnection fConnection;
    private boolean fSucceeded;
    private String fFinalizedReport;
    private boolean fCompleted;

    IluConnectionThread(String url, IluReport reportObj) {
        super(url);
        this.fUrlString = url;
        this.fReport = reportObj;
        this.fCompleted = false;
        this.fSucceeded = false;
        this.fConnection = null;
        this.fLog = new IluSAMLogger();
        try {
            this.setDaemon(true);
        }
        catch (SecurityException e) {
            this.fLog.logDebugConsole(e);
        }
    }

    public void run() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                try {
                    IluConnectionThread.this.fConnection = IluConnectionThread.this.openConnection();
                    if (IluConnectionThread.this.fConnection != null) {
                        IluConnectionThread.this.fFinalizedReport = IluConnectionThread.this.fReport.getReport();
                        IluConnectionThread.this.fLog.logDebugConsole(IluConnectionThread.this.fFinalizedReport);
                        IluConnectionThread.this.sendWithPost();
                        IluConnectionThread.this.sendWithGet();
                        if (IluConnectionThread.this.fConnection instanceof HttpURLConnection) {
                            ((HttpURLConnection)IluConnectionThread.this.fConnection).disconnect();
                        }
                    }
                }
                catch (SecurityException e) {
                    IluConnectionThread.this.fLog.logDebug(e);
                }
                finally {
                    IluConnectionThread.this.setCompleted(true);
                    IluConnectionThread.this.fLog.logDebugConsole("connection to " + IluConnectionThread.this.fUrlString + " fLog:\n" + IluConnectionThread.this.fLog.getLog());
                }
                return null;
            }
        });
    }

    final URLConnection openConnection() {
        URL url = null;
        try {
            url = new URL(this.getUrlString());
        }
        catch (MalformedURLException e) {
            this.fLog.logDebug(e);
        }
        URLConnection uc = null;
        if (url != null) {
            try {
                uc = url.openConnection();
            }
            catch (IOException e) {
                this.fLog.logDebug(e);
            }
        }
        return uc;
    }

    final void sendWithGet() {
    }

    final void sendWithPost() {
        try {
            String postData;
            this.fConnection.setUseCaches(false);
            this.fConnection.setDoOutput(true);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(byteStream);
            try {
                postData = "DATA=" + URLEncoder.encode(this.fFinalizedReport, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                postData = "DATA=" + this.fFinalizedReport;
            }
            out.print(postData);
            out.flush();
            String lengthString = String.valueOf(byteStream.size());
            this.fConnection.setRequestProperty("Content-Length", lengthString);
            this.fConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream outputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                outputStream = this.fConnection.getOutputStream();
                bufferedOutputStream = new BufferedOutputStream(outputStream);
                byteStream.writeTo(bufferedOutputStream);
                bufferedOutputStream.flush();
                outputStream.flush();
                bufferedOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                this.fLog.logDebug(e);
                return;
            }
            out.close();
            try {
                byteStream.close();
            }
            catch (IOException e) {
                this.fLog.logDebug(e);
                return;
            }
            this.checkServerAnswer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkServerAnswer() {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = this.fConnection.getInputStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            inputStreamReader = new InputStreamReader(bufferedInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (IOException e) {
            this.fLog.logDebug(e);
            return;
        }
        String answer = "";
        if (bufferedReader != null) {
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    answer = answer + line;
                }
            }
            catch (IOException e) {
                this.fLog.logDebug(e);
                return;
            }
        }
        try {
            bufferedReader.close();
            inputStreamReader.close();
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            return;
        }
        this.checkServerAnswerString(answer);
    }

    private void checkServerAnswerString(String answer) {
        int errorNumber = IluJumServerUtil.checkServerResponseForErrors(answer);
        switch (errorNumber) {
            case 0: {
                this.fSucceeded = true;
                break;
            }
            case -1: {
                this.fLog.logDebug("server answer was not correct.\n" + answer);
                break;
            }
            default: {
                this.fLog.logDebug("server error code: " + errorNumber + "\n" + answer);
            }
        }
        if (this.fSucceeded) {
            this.showReport();
        }
        this.setSucceeded(this.fSucceeded);
    }

    private void showReport() {
        String showReport = null;
        try {
            showReport = System.getProperty(SHOW_REPORT_IN_CONSOLE_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (showReport != null) {
            System.out.println(this.fFinalizedReport);
        }
    }

    final String getUrlString() {
        return this.fUrlString;
    }

    final IluReport getReport() {
        return this.fReport;
    }

    final synchronized void setCompleted(boolean b) {
        this.fCompleted = b;
    }

    final synchronized boolean isCompleted() {
        return this.fCompleted;
    }

    final synchronized void setSucceeded(boolean b) {
        this.fSucceeded = b;
    }

    final synchronized boolean isSucceeded() {
        return this.fSucceeded;
    }

    final String getNamePrefix() {
        return THREAD_NAME_PREFIX;
    }

    final int getNbThreadsMax() {
        return 2;
    }
}

