/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.client650;

import ilog.jum.IluUrlParams;
import ilog.jum.client650.IluConnectionThread;
import ilog.jum.client650.IluReport;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class IluReportSender
implements IluUrlParams {
    private final IluReport report;
    private final String license;

    IluReportSender(IluReport reportObj, String licenseXML) {
        this.report = reportObj;
        this.license = licenseXML;
    }

    final void send() {
        List urls = this.getURLs();
        Iterator iterator = urls.iterator();
        boolean reportSent = false;
        while (!reportSent) {
            if (iterator.hasNext()) {
                try {
                    String urlName = (String)iterator.next();
                    IluConnectionThread thread = new IluConnectionThread(urlName, this.report);
                    thread.start();
                    try {
                        if (thread.isAlive()) {
                            thread.join(30000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    reportSent = thread.isCompleted() && thread.isSucceeded();
                    continue;
                }
                catch (SecurityException e) {
                    return;
                }
            }
            return;
        }
        if (reportSent) {
            this.report.getJumLog().logDebugConsole("reporting successful.");
        } else {
            this.report.getJumLog().logDebugConsole("reporting failed.");
        }
    }

    final List getURLs() {
        String ai = null;
        List rawUrls = null;
        try {
            rawUrls = IluXML.getFirstMultipleValues("report-URLs", "URL", this.license);
        }
        catch (IluXMLTagNotFoundException e) {
            // empty catch block
        }
        LinkedList<String> urls = new LinkedList<String>();
        if (rawUrls != null) {
            try {
                ai = IluXML.getFirstValue("activation-id", this.license);
            }
            catch (IluXMLTagNotFoundException e) {
                ai = "99999999";
            }
            Iterator iter = rawUrls.iterator();
            while (iter.hasNext()) {
                urls.add((String)iter.next() + "?" + "ai" + "=" + ai);
            }
        }
        return urls;
    }
}

