/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.client650;

import ilog.jum.IluIlogRightsTags;
import ilog.jum.IluLicenseTags;
import ilog.jum.IluProductAndModuleNames;
import ilog.jum.IluVersion;
import ilog.jum.client650.IluSAMLogger;
import ilog.jum.client650.IluSAMNotGrantedException;
import ilog.jum.client650.IluSAMResourseNotFoundException;
import ilog.jum.client650.IluUsageMonitoringThread;
import ilog.jum.util.IluActivatedMachine;
import ilog.jum.util.IluActivatedModule;
import ilog.jum.util.IluCharacterCodingException;
import ilog.jum.util.IluCharsetTools;
import ilog.jum.util.IluDateFormat;
import ilog.jum.util.IluDigestor;
import ilog.jum.util.IluDigestorInvalidFormatException;
import ilog.jum.util.IluFileBuffer;
import ilog.jum.util.IluLicensedModule;
import ilog.jum.util.IluMD5;
import ilog.jum.util.IluMachine;
import ilog.jum.util.IluMachineInfo;
import ilog.jum.util.IluModule;
import ilog.jum.util.IluModuleException;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class IluSAM
implements IluProductAndModuleNames,
IluVersion,
IluLicenseTags,
IluIlogRightsTags,
Serializable {
    static final long serialVersionUID = 2110226858148793428L;
    private static final String DEFAULT_LICENSE_SUFFIX = "license.xml";
    private static final String UNSPECIFIED_APPLICATION = "Unspecified application";
    private static final String RUNTIME_DISABLE_MONITORING = "ilog.sam.runtime-disable-monitoring";
    private static final String CHECK_LOG_TO_CONSOLE = "ilog.sam.license-check-log-to-console";
    private static final String APPLICATION_NAME_PROPERTY = "ilog.sam.application";
    private static final String SAM_LOG_VERBOSITY = "ilog.sam.verbosity";
    private final String fModuleName;
    private final String fModuleReleaseId;
    private final String fLicense;
    private final IluLicensedModule[] fLicensedModule;
    private final String fUsageType;
    private final SortedSet fAllApplications = new TreeSet();
    private final List fRawUrls;
    private final String fCtorDate;
    private final IluActivatedModule fActivatedModule;
    private final IluMachineInfo fRunningMachine;
    private final IluSAMLogger fLog;
    private final URL fLicenseURL;
    private final LinkedList fMatchingLicenses;
    private final String fApplication;
    private final String fActivationId;
    private final String fActivationLog;
    private final boolean fInternetReport;
    private final String fProxyValue;
    private final boolean fChekLogOnConsole;
    private final boolean fVerbosity;
    private final ClassLoader fClassLoader;

    public IluSAM(String moduleName, String applicationName) throws IluSAMResourseNotFoundException, IluSAMNotGrantedException {
        this(moduleName, applicationName, null, null, null);
    }

    public IluSAM(String moduleName, String applicationName, ClassLoader classLoader) throws IluSAMResourseNotFoundException, IluSAMNotGrantedException {
        this(moduleName, applicationName, null, null, classLoader);
    }

    public IluSAM(String moduleName, String applicationName, String license) throws IluSAMResourseNotFoundException, IluSAMNotGrantedException {
        this(moduleName, applicationName, license, null, null);
    }

    public IluSAM(String moduleName, String applicationName, String license, IluMachineInfo machine, ClassLoader classLoader) throws IluSAMResourseNotFoundException, IluSAMNotGrantedException {
        LinkedList rawUrls;
        boolean noApplicationSet;
        String proxyValue;
        this.fRunningMachine = machine == null ? IluMachineInfo.currentMachine() : machine;
        this.fModuleName = moduleName;
        this.fCtorDate = IluDateFormat.formatSecZ(new Date());
        this.fLog = new IluSAMLogger();
        this.fClassLoader = classLoader;
        this.fChekLogOnConsole = IluMachineInfo.getSystemProperty(CHECK_LOG_TO_CONSOLE) != null;
        this.fVerbosity = IluMachineInfo.getSystemProperty(SAM_LOG_VERBOSITY) != null;
        String extraLog = "";
        if (!VALID_MODULES.contains(this.fModuleName)) {
            throw new IluSAMNotGrantedException("At " + this.fCtorDate + ", SAM " + SAM_VERSION + ": License for ILOG module '" + this.fModuleName + "' is refused because licenses are" + " granted only for " + VALID_MODULES + ".");
        }
        String licenseResource = "the argument passed to IluSAM";
        if (license != null) {
            this.fLicense = license;
            this.fLicenseURL = null;
            this.fMatchingLicenses = null;
        } else {
            String lic = null;
            URL url = null;
            LinkedList resList = null;
            licenseResource = "ilog/jum/client650/" + this.fModuleName + DEFAULT_LICENSE_SUFFIX;
            try {
                resList = this.getResource(licenseResource);
                if (resList.size() > 0) {
                    url = (URL)resList.getFirst();
                    lic = IluCharsetTools.decode(this.getURLContents(url, licenseResource));
                }
            }
            catch (SecurityException e) {
                throw new IluSAMResourseNotFoundException(e.getMessage(), e);
            }
            catch (IluCharacterCodingException e) {
                throw new IluSAMResourseNotFoundException(e.getMessage(), e);
            }
            if (lic == null) {
                ClassLoader cl = classLoader;
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                throw new IluSAMResourseNotFoundException("At " + this.fCtorDate + ", SAM " + SAM_VERSION + ": " + "License for ILOG module '" + this.fModuleName + "' can't locate a resource" + " named '" + licenseResource + "' using " + this.getClass() + " class loader (" + cl + ").");
            }
            this.fLicense = lic;
            this.fLicenseURL = url;
            this.fMatchingLicenses = resList;
        }
        String errMessage = null;
        try {
            IluDigestor d = new IluDigestor();
            boolean checkDigest = true;
            if (!checkDigest) {
                System.out.println("*** WARNING: checkDigest is set in IluSAM ***");
            }
            if (!d.check(this.fLicense)) {
                if (checkDigest) {
                    errMessage = "wrong digest";
                } else {
                    System.out.println("fix digest with: <" + IluXML.getFirstValue("digest", d.set(this.fLicense)) + ">");
                }
            }
        }
        catch (IluDigestorInvalidFormatException e) {
            errMessage = e.getMessage();
        }
        catch (IluXMLTagNotFoundException e) {
            errMessage = "<digest> tag is missing";
        }
        if (errMessage != null) {
            throw new IluSAMNotGrantedException("At " + this.fCtorDate + ", SAM " + SAM_VERSION + ": License for ILOG module '" + this.fModuleName + "' has no valid <digest> tag in '" + licenseResource);
        }
        try {
            this.fLicensedModule = IluLicensedModule.getLicensedModulesFromXML(this.fLicense);
        }
        catch (IluModuleException e) {
            throw new IluSAMNotGrantedException("Parse error reading " + licenseResource + " " + e.getMessage());
        }
        try {
            String eActivation = IluXML.getFirstValue("effective-activation", this.fLicense);
            String reportMedium = IluXML.getFirstValue("report-medium", this.fLicense);
            this.fActivatedModule = IluActivatedModule.getInstanceFromXML(eActivation);
            this.fInternetReport = reportMedium.equals("internet") && !this.isReportingRuntimeDisabled(this.fLicense);
        }
        catch (IluXMLTagNotFoundException e) {
            throw new IluSAMNotGrantedException("Parse error reading " + licenseResource + " " + e.getMessage());
        }
        catch (IluModuleException e) {
            throw new IluSAMNotGrantedException("Parse error reading " + licenseResource + " " + e.getMessage());
        }
        try {
            proxyValue = IluXML.getFirstValue("online-proxy", this.fLicense);
        }
        catch (IluXMLTagNotFoundException e) {
            proxyValue = null;
        }
        this.fProxyValue = proxyValue;
        CollectorHelper collector = this.collectApplications(this.fRunningMachine.getMachineHost(), this.fActivatedModule.getModules(), this.fLicensedModule);
        Map usageTypeActivationId = collector.getMap();
        this.fModuleReleaseId = collector.getId();
        boolean bl = noApplicationSet = applicationName == null;
        if (noApplicationSet) {
            String appProperty = IluSAM.getProperty(APPLICATION_NAME_PROPERTY);
            if (appProperty != null) {
                this.fApplication = appProperty;
            } else {
                this.fApplication = UNSPECIFIED_APPLICATION;
                if (this.fAllApplications.size() > 0) {
                    extraLog = extraLog + "application should be one of " + this.fAllApplications + " instead of \"" + this.fApplication + "\".";
                }
            }
        } else {
            this.fApplication = applicationName;
        }
        String usage = null;
        if (noApplicationSet || this.fAllApplications.contains(this.fApplication)) {
            if (usageTypeActivationId.keySet().contains("s")) {
                usage = "s";
            } else if (usageTypeActivationId.keySet().contains("d")) {
                usage = "d";
            }
        }
        if (usage == null) {
            throw new IluSAMNotGrantedException("At " + this.fCtorDate + ", SAM " + SAM_VERSION + ": License for ILOG module '" + this.fModuleName + "', using application '" + this.fApplication + "' " + "is not granted for machine name '" + this.fRunningMachine.getMachineHost() + "' as seen in " + (this.fLicenseURL == null ? "license:\n" + this.fLicense : "resource " + this.fLicenseURL));
        }
        this.fActivationId = (String)usageTypeActivationId.get(usage);
        this.fUsageType = usage;
        try {
            rawUrls = IluXML.getFirstMultipleValues("report-URLs", "URL", this.fLicense);
        }
        catch (IluXMLTagNotFoundException e) {
            rawUrls = new LinkedList();
        }
        this.fRawUrls = rawUrls;
        this.fActivationLog = "<sam-activation-log>\n <!-- To get more information, use property settings      -->\n <!-- ilog.sam.verbosity and change ilog.sam.client.level -->\n <!-- logging property to log FINE or a lower level.      -->\n " + IluXML.getTaggedValueln("sam-version", SAM_VERSION) + " " + IluXML.getTaggedValueln("log-date", this.fCtorDate) + this.fActivatedModule.toXML(1) + IluMachine.getCurrentInstance().toXML(1) + " " + IluXML.getTaggedValueln("requested-module-name", this.fModuleName) + " " + IluXML.getTaggedValueln("requested-application-name", this.fApplication) + " " + IluXML.getTaggedValueln("usage-type", this.fUsageType) + " " + IluXML.getTaggedValueln("resource-url", this.fLicenseURL) + " " + IluXML.getTaggedValueln("activation-warning", extraLog) + "</sam-activation-log>\n";
        if (this.fChekLogOnConsole) {
            System.out.println("Constructor log:");
            System.out.println(this.fLog.getLog());
        }
    }

    public final Collection getApplications() {
        return this.fAllApplications;
    }

    public final String getModuleName() {
        return this.fModuleName;
    }

    public final String getModuleReleaseId() {
        return this.fModuleReleaseId;
    }

    public final String getApplication() {
        return this.fApplication;
    }

    public final String getUsageType() {
        return this.fUsageType;
    }

    public static final String getJumVersion() {
        return SAM_VERSION;
    }

    public final String getMktData() {
        return this.fActivatedModule.getMktData();
    }

    public final String getLog() {
        return this.fActivationLog;
    }

    final IluMachineInfo getRunningMachine() {
        return this.fRunningMachine;
    }

    final List getRawUrls() {
        return this.fRawUrls;
    }

    final String getOnlineProxy() {
        return this.fProxyValue;
    }

    final String getLicense() {
        return this.fLicense;
    }

    public final void report(final String componentName, final String userData, final long sessionDuration) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    IluSAM.this.doReport(componentName, userData, sessionDuration);
                    return null;
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doReport(String componentName, String userData, long sessionDuration) {
        boolean reportSuccessful = false;
        String component = componentName == null ? "" : componentName;
        IluUsageMonitoringThread thread = null;
        try {
            try {
                if (this.isUsageMonitoringThreadNeeded()) {
                    thread = new IluUsageMonitoringThread(component, userData, sessionDuration, this, this.fLog);
                    try {
                        thread.start();
                        reportSuccessful = true;
                    }
                    catch (SecurityException e) {
                        reportSuccessful = false;
                    }
                }
                Object var10_9 = null;
                if (this.fLog.getUserMessage() != null) {
                    this.fLog.setUserMessage("JRules: " + component + "\n" + this.fLog.getUserMessage());
                }
            }
            catch (Exception e) {
                this.fLog.severe(e.getMessage());
                Object var10_10 = null;
                if (this.fLog.getUserMessage() != null) {
                    this.fLog.setUserMessage("JRules: " + component + "\n" + this.fLog.getUserMessage());
                }
                if (IluSAMLogger.isDebug()) {
                    String userMessage = this.fLog.getUserMessage();
                    if (userMessage != null) {
                        this.fLog.logDebugConsole("user message: " + userMessage);
                    }
                    this.fLog.logDebugConsole("application: " + this.getApplication());
                }
                if (!this.fChekLogOnConsole) return;
                System.out.println("Report log:");
                System.out.println(this.fLog.getLog());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (this.fLog.getUserMessage() != null) {
                this.fLog.setUserMessage("JRules: " + component + "\n" + this.fLog.getUserMessage());
            }
            if (IluSAMLogger.isDebug()) {
                String userMessage = this.fLog.getUserMessage();
                if (userMessage != null) {
                    this.fLog.logDebugConsole("user message: " + userMessage);
                }
                this.fLog.logDebugConsole("application: " + this.getApplication());
            }
            if (!this.fChekLogOnConsole) throw throwable;
            System.out.println("Report log:");
            System.out.println(this.fLog.getLog());
            throw throwable;
        }
        if (IluSAMLogger.isDebug()) {
            String userMessage = this.fLog.getUserMessage();
            if (userMessage != null) {
                this.fLog.logDebugConsole("user message: " + userMessage);
            }
            this.fLog.logDebugConsole("application: " + this.getApplication());
        }
        if (!this.fChekLogOnConsole) return;
        System.out.println("Report log:");
        System.out.println(this.fLog.getLog());
    }

    private final CollectorHelper collectApplications(String machineName, IluModule[] activatedModules, IluLicensedModule[] licensedModule) {
        Hashtable<String, String> usageTypeActivationId = new Hashtable<String, String>();
        String releaseId = null;
        for (int i = 0; i < activatedModules.length; ++i) {
            IluModule module = activatedModules[i];
            if (!module.getName().equals(this.fModuleName)) continue;
            for (int j = 0; j < licensedModule.length; ++j) {
                IluLicensedModule lm = licensedModule[j];
                if (!lm.getName().equals(module.getName()) || !lm.getLicensedUptoRelDate().after(module.getReleaseDate()) || !lm.getLicensedUntil().after(new Date())) continue;
                boolean isCurrentMachineLicensed = false;
                IluActivatedMachine[] am = lm.getActivatedMachines();
                for (int k = 0; k < am.length; ++k) {
                    if (!am[k].match(machineName) && !lm.getUsageType().equals("s")) continue;
                    usageTypeActivationId.put(lm.getUsageType(), am[k].getActivationId());
                    isCurrentMachineLicensed = true;
                }
                if (!isCurrentMachineLicensed) continue;
                releaseId = module.getReleaseId();
                String[] appnames = lm.getAppNames();
                for (int k = 0; k < appnames.length; ++k) {
                    this.fAllApplications.add(appnames[k]);
                }
            }
        }
        return new CollectorHelper(usageTypeActivationId, releaseId);
    }

    private final LinkedList getResource(final String resName) {
        return (LinkedList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL url;
                LinkedList<URL> list = new LinkedList<URL>();
                ClassLoader cl = IluSAM.this.fClassLoader;
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                if ((url = cl.getResource(resName)) != null) {
                    list.add(url);
                }
                return list;
            }
        });
    }

    private final byte[] getURLContents(final URL url, final String resName) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InputStream is;
                    if (IluSAM.this.fClassLoader != null) {
                        is = IluSAM.this.fClassLoader.getResourceAsStream(resName);
                    } else {
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setUseCaches(false);
                        is = urlConnection.getInputStream();
                    }
                    byte[] buf = IluFileBuffer.getStreamContentAsBytes(is);
                    return buf;
                }
                catch (IOException e) {
                    throw new IluSAMResourseNotFoundException(e.getMessage(), e);
                }
            }
        });
    }

    private static String getProperty(final String propname) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(propname);
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    boolean isUsageMonitoringThreadNeeded() {
        return this.fInternetReport;
    }

    private boolean isReportingRuntimeDisabled(String xmlLicense) {
        boolean res = false;
        String disableMonitoringProperty = null;
        try {
            disableMonitoringProperty = IluSAM.getProperty(RUNTIME_DISABLE_MONITORING);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (disableMonitoringProperty != null) {
            try {
                String ip = IluXML.getFirstValue("installation-password", xmlLicense);
                String id = IluXML.getFirstValue("activation-id", xmlLicense);
                String md5 = IluMD5.fromString(ip + id);
                res = disableMonitoringProperty.equals(md5);
            }
            catch (IluXMLTagNotFoundException e) {
                res = false;
            }
        }
        return res;
    }

    class CollectorHelper {
        private Map fMap;
        private String fId;

        CollectorHelper(Map map, String id) {
            this.fMap = map;
            this.fId = id;
        }

        final Map getMap() {
            return this.fMap;
        }

        final String getId() {
            return this.fId;
        }
    }
}

