/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.client650;

import ilog.jum.client650.IluSAMLicenseLog;
import ilog.jum.util.IluMachineInfo;
import ilog.jum.util.IluXML;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IluSAMLogger
implements Serializable {
    static final long serialVersionUID = -5591502504485443657L;
    private static final String DEBUG_PROPERTY = "ilog.sam.debug";
    private static final String DEFAULT_LOGGER_NAME = "ilog.sam.client";
    private static final Logger LOGGER = Logger.getLogger("ilog.sam.client");
    private Level fLevel = Level.FINER;
    private LinkedList fLog = new LinkedList();
    private String fUserMessage = null;
    private static final boolean DEBUG;

    IluSAMLogger() {
    }

    synchronized void finest(String msg) {
        try {
            LOGGER.finest(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.FINEST, msg);
    }

    synchronized void finer(String msg) {
        try {
            LOGGER.finer(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.FINER, msg);
    }

    synchronized void fine(String msg) {
        try {
            LOGGER.fine(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.FINE, msg);
    }

    synchronized void info(String msg) {
        try {
            LOGGER.info(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.INFO, msg);
    }

    synchronized void config(String msg) {
        try {
            LOGGER.config(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.CONFIG, msg);
    }

    synchronized void warning(String msg) {
        try {
            LOGGER.warning(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.WARNING, msg);
    }

    synchronized void severe(String msg) {
        try {
            LOGGER.severe(msg);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.updateLevel(Level.SEVERE, msg);
    }

    synchronized void logDebugConsole(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    synchronized void logDebugConsole(Exception e) {
        if (DEBUG) {
            System.out.println(e);
        }
    }

    synchronized void logDebug(String msg) {
        if (DEBUG) {
            try {
                LOGGER.fine(msg);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    synchronized void logDebug(Exception excpt) {
        if (DEBUG) {
            try {
                LOGGER.severe("" + excpt);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private synchronized void updateLevel(Level level, String msg) {
        String text = " " + IluXML.getTaggedValueln(level.toString(), msg);
        this.fLog.add(text);
        IluSAMLicenseLog.add(text);
        if (this.fLevel.intValue() < level.intValue()) {
            this.fLevel = level;
        }
    }

    synchronized void add(String msg) {
        this.fLog.add(msg);
    }

    String getJumStatusAsString() {
        return this.fLevel.toString();
    }

    int getJumStatusAsInteger() {
        return this.fLevel.intValue();
    }

    synchronized void setUserMessage(String userMessage) {
        this.fUserMessage = userMessage;
    }

    synchronized void addUserMessage(String userMessage) {
        this.fUserMessage = this.fUserMessage == null ? userMessage : this.fUserMessage + "\n" + this.fUserMessage;
    }

    String getUserMessage() {
        return this.fUserMessage;
    }

    synchronized String getLog(int indent) {
        String offset = IluXML.getIndent(indent);
        String log = "";
        log = log + offset + "<sam-log>\n";
        Iterator it = this.fLog.iterator();
        while (it.hasNext()) {
            log = log + offset + (String)it.next();
        }
        log = log + offset + "</sam-log>\n";
        return log;
    }

    String getLog() {
        return this.getLog(0);
    }

    static boolean isDebug() {
        return DEBUG;
    }

    static {
        String debugProperty = null;
        try {
            debugProperty = IluMachineInfo.getSystemProperty(DEBUG_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = debugProperty != null;
    }
}

