/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.client650;

import ilog.jum.IluUsageReportTags;
import ilog.jum.client650.IluSAM;
import ilog.jum.client650.IluSAMLogger;
import ilog.jum.util.IluDigestor;
import ilog.jum.util.IluDigestorInvalidFormatException;
import ilog.jum.util.IluMD5;
import ilog.jum.util.IluMachineInfo;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class IluUsageCollector
implements IluUsageReportTags {
    private final String fComponent;
    private final long fSessionDuration;
    private final IluSAMLogger fLog;
    private final String fUserData;
    private final IluSAM fSam;

    IluUsageCollector(IluSAM sam, String componentName, String userData, long duration, IluSAMLogger log) {
        this.fSam = sam;
        this.fComponent = componentName;
        this.fUserData = userData;
        this.fSessionDuration = duration;
        this.fLog = log;
    }

    final String collect() {
        String report = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<sam-usage>\n " + this.xmlTag("digest", "fixme later") + " " + this.xmlTag("sam-version", IluSAM.getJumVersion()) + " " + this.xmlLicenseTag("installation-password") + " " + this.xmlLicenseTag("activation-id") + " " + this.xmlLicenseTag("installation-date") + " " + this.xmlLicenseTag("release-date") + " " + this.xmlTag("module", this.fSam.getModuleName()) + " " + this.xmlTag("module-version", this.fSam.getModuleReleaseId()) + " " + this.xmlTag("usage-type", this.fSam.getUsageType()) + " " + this.xmlTag("component", this.fComponent) + " " + this.xmlTag("user-data", this.fUserData) + " " + this.xmlTag("session-duration", "" + this.fSessionDuration) + " " + this.xmlTag("application", this.getApplication()) + " " + this.xmlLicenseTag("report-medium");
        report = report + " <application-name-array>\n";
        Iterator it = this.getApplications().iterator();
        while (it.hasNext()) {
            report = report + "  " + this.xmlTag("application-name", (String)it.next());
        }
        report = report + " </application-name-array>\n";
        report = report + " <report-URL-array>\n";
        it = this.getRawUrls().iterator();
        while (it.hasNext()) {
            report = report + "  " + this.xmlTag("report-URL", (String)it.next());
        }
        report = report + " </report-URL-array>\n";
        report = report + "" + this.fSam.getRunningMachine().machineToXML(1) + " " + this.xmlTag("user-hash", this.getUserHash()) + " " + this.xmlTag("pid", this.getPID()) + " " + this.xmlTag("sam-status", this.fLog.getJumStatusAsString());
        String mktData = this.fSam.getMktData();
        report = mktData.equals("true") ? report + " <marketing-data>\n  " + this.xmlTag("enabled", "true") + this.fSam.getRunningMachine().marketingToXML(2) + "  " + this.xmlTag("using-proxy", this.fSam.getOnlineProxy()) + this.fLog.getLog(2) + " </" + "marketing-data" + ">\n" : report + " <marketing-data>\n  " + this.xmlTag("enabled", "false") + " </" + "marketing-data" + ">\n";
        report = report + "</sam-usage>\n";
        IluDigestor digestor = new IluDigestor("digest");
        try {
            report = digestor.set(report);
        }
        catch (IluDigestorInvalidFormatException e) {
            this.fLog.severe(e.getMessage());
        }
        this.fLog.logDebugConsole(report);
        return report;
    }

    private String xmlTag(String tag, String value) {
        return IluXML.getTaggedValueln(tag, value);
    }

    private String xmlLicenseTag(String tag) {
        return IluXML.getTaggedValueln(tag, this.getLicenseValue(tag));
    }

    private String getLicenseContent() {
        try {
            return IluXML.getFirstValue("data-block", this.fSam.getLicense());
        }
        catch (IluXMLTagNotFoundException e) {
            return "  <error-no-data-block-found />\n";
        }
    }

    final String getApplication() {
        return this.fSam.getApplication();
    }

    final List getRawUrls() {
        return this.fSam.getRawUrls();
    }

    final Collection getApplications() {
        return this.fSam.getApplications();
    }

    private String getLicenseValue(String tag) {
        try {
            return IluXML.getFirstValue(tag, this.fSam.getLicense());
        }
        catch (IluXMLTagNotFoundException e) {
            return null;
        }
    }

    final String getNbProcessors() {
        return "" + this.fSam.getRunningMachine().getGuessedCPUs();
    }

    final String getMachineName() {
        return this.fSam.getRunningMachine().getMachineHost();
    }

    final String getFullMachineName() {
        return this.fSam.getRunningMachine().getUnNormalizedHost();
    }

    final String getMachineIp() {
        return this.fSam.getRunningMachine().getMachineIp();
    }

    final String getUserHash() {
        int maxLen = 16;
        String userName = IluMachineInfo.getUserName();
        String userHash = null;
        if (userName != null) {
            userHash = IluMD5.fromString(userName);
            userHash = userHash.substring(userHash.length() - 16);
        } else {
            userHash = "unknown";
        }
        return userHash;
    }

    final String getPID() {
        return IluMachineInfo.getPID();
    }

    final String getComponent() {
        return this.fComponent;
    }
}

