/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.client650;

import ilog.jum.IluLicenseTags;
import ilog.jum.IluUsageReportTags;
import ilog.jum.client650.IluReport;
import ilog.jum.client650.IluReportSender;
import ilog.jum.client650.IluSAM;
import ilog.jum.client650.IluSAMLogger;
import ilog.jum.client650.IluThread;
import ilog.jum.client650.IluUsageCollector;

public class IluUsageMonitoringThread
extends IluThread
implements IluLicenseTags,
IluUsageReportTags {
    private static final String THREAD_NAME_PREFIX = "ilog.sam.report.";
    public static final int NB_THREADS_MAX = 2;
    private final IluSAM fUsageMonitor;
    private final String fModuleName;
    private final IluSAMLogger fLog;
    private final IluReport fReport;
    private final String fUserData;

    IluUsageMonitoringThread(String modName, String userData, long sessionSeconds, IluSAM sam, IluSAMLogger log) {
        super(modName);
        this.fModuleName = modName;
        this.fUsageMonitor = sam;
        this.fLog = log;
        this.fUserData = userData;
        IluUsageCollector usageCollector = new IluUsageCollector(this.fUsageMonitor, this.fModuleName, this.fUserData, sessionSeconds, this.fLog);
        this.fReport = new IluReport(usageCollector.collect(), this.fLog);
        try {
            this.setDaemon(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public final void run() {
        this.fLog.fine("starting monitoring thread for " + this.fModuleName);
        this.sendReport();
        this.fLog.fine("ending monitoring thread for " + this.fModuleName);
        this.fLog.logDebugConsole(this.fLog.getLog());
    }

    final void sendReport() {
        IluReportSender reportSender = new IluReportSender(this.fReport, this.getUsageMonitor().getLicense());
        reportSender.send();
    }

    final IluReport getReport() {
        return this.fReport;
    }

    final IluSAMLogger getJumLog() {
        return this.fLog;
    }

    final IluSAM getUsageMonitor() {
        return this.fUsageMonitor;
    }

    final String getNamePrefix() {
        return THREAD_NAME_PREFIX;
    }

    final int getNbThreadsMax() {
        return 2;
    }
}

