/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluActivatedMachine;
import ilog.jum.util.IluDateFormat;
import ilog.jum.util.IluModule;
import ilog.jum.util.IluModuleException;
import ilog.jum.util.IluModuleReleaseDateException;
import ilog.jum.util.IluModuleUseTypeException;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;

public class IluActivatedModule
extends IluXML {
    static final long serialVersionUID = -3937644743424987571L;
    private String fMktData;
    private String fMachineName;
    private String fMachineIP;
    private String fGuessedCPU;
    private Date fInstallDate;
    private IluModule[] fRequestedModule;

    public IluActivatedModule(String mktData, String machineName, String machineIP, String guessedCPU, Date installDate, IluModule[] requestedModule) throws IluModuleReleaseDateException, IluModuleUseTypeException {
        super("effective-activation");
        this.fMktData = mktData;
        this.fMachineName = machineName;
        this.fMachineIP = machineIP;
        this.fGuessedCPU = guessedCPU;
        this.fInstallDate = installDate;
        this.fRequestedModule = requestedModule;
    }

    public final String getMktData() {
        return this.fMktData;
    }

    public final String getMachineName() {
        return this.fMachineName;
    }

    public final String getMachineIP() {
        return this.fMachineIP;
    }

    public final String getGuessedCPU() {
        return this.fGuessedCPU;
    }

    public final Date getInstallDate() {
        return this.fInstallDate;
    }

    public final IluModule[] getModules() {
        return this.fRequestedModule;
    }

    public static IluActivatedModule getInstanceFromXML(String xmlText) throws IluModuleReleaseDateException, IluModuleUseTypeException, IluXMLTagNotFoundException, IluModuleException {
        String mktData = IluActivatedModule.getStringValue("marketing-usage-monitoring", xmlText);
        String machineName = IluActivatedModule.getStringValue("machine-name", xmlText);
        String machineIP = IluActivatedModule.getStringValue("machine-ip", xmlText);
        String guessedCPU = IluActivatedModule.getStringValue("machine-cpus", xmlText);
        Date installDate = IluActivatedModule.getDateValue("installation-date", xmlText);
        IluModule[] modules = IluActivatedModule.getRequestedModulesFromXML(xmlText);
        return new IluActivatedModule(mktData, machineName, machineIP, guessedCPU, installDate, modules);
    }

    public final IluModule[] getRequestedModule() {
        return this.fRequestedModule;
    }

    private static final String getStringValue(String xmlTag, String xmlText) {
        try {
            return IluActivatedModule.getFirstValue(xmlTag, xmlText);
        }
        catch (IluXMLTagNotFoundException e) {
            return null;
        }
    }

    private static final Date getDateValue(String xmlTag, String xmlText) {
        try {
            String dateString = IluActivatedModule.getFirstValue(xmlTag, xmlText);
            return IluDateFormat.parseSecZ(dateString);
        }
        catch (IluXMLTagNotFoundException e) {
            System.out.println(e);
            return null;
        }
        catch (ParseException e) {
            System.out.println(e);
            return null;
        }
    }

    public static String getDate(Date date) {
        return IluDateFormat.formatSecZ(date);
    }

    protected void parseXML(String xmlBlock) throws IluXMLTagNotFoundException {
        new RuntimeException("IluActivatedModule.parseXML(String) is not implemented.\n" + xmlBlock);
    }

    public String toXML(int indent) {
        String prefix = "";
        for (int i = 0; i < indent; ++i) {
            prefix = prefix + " ";
        }
        String header = "" + prefix + this.fXmlToplevelStartTag + "\n" + prefix + " " + IluActivatedModule.getTaggedValueln("marketing-usage-monitoring", this.fMktData) + prefix + " <requested-machine>\n" + prefix + "  " + IluActivatedModule.getTaggedValueln("machine-name", this.fMachineName) + prefix + "  " + IluActivatedModule.getTaggedValueln("machine-ip", this.fMachineIP) + prefix + "  " + IluActivatedModule.getTaggedValueln("machine-cpus", this.fGuessedCPU) + prefix + " </requested-machine>\n" + prefix + " " + IluActivatedModule.getTaggedValueln("installation-date", IluDateFormat.formatSecZ(this.fInstallDate));
        String data = "";
        data = data + prefix + " <requested-module-array>\n";
        if (this.fRequestedModule != null) {
            for (int i = 0; i < this.fRequestedModule.length; ++i) {
                data = data + prefix + "  <requested-module>\n";
                data = data + this.fRequestedModule[i].toXML(indent + 3);
                data = data + prefix + "  </requested-module>\n";
            }
        }
        data = data + prefix + " </requested-module-array>\n";
        String footer = "" + prefix + this.fXmlToplevelStopTag + "\n";
        return header + data + footer;
    }

    public static final IluModule[] getRequestedModulesFromXML(String contents) throws IluModuleException {
        String xmlActivatedModulesTagName = "requested-module-array";
        String xmlActivatedModuleTagName = "requested-module";
        String xmlActivatedModuleStartTag = "<" + xmlActivatedModuleTagName + ">";
        String xmlActivatedModuleStopTag = "</" + xmlActivatedModuleTagName + ">";
        LinkedList moduleList = new LinkedList();
        String xml = null;
        try {
            xml = IluActivatedModule.getFirstValue(xmlActivatedModulesTagName, contents);
        }
        catch (IluXMLTagNotFoundException e) {
            return new IluModule[0];
        }
        return IluModule.getInstancesFromXML(xmlActivatedModuleTagName, xml);
    }

    private static final IluActivatedMachine[] getActivatedMachinesFromXML(String contents) {
        String xmlActivatedMachinesTagName = "activated-machine-array";
        String xmlActivatedMachineTagName = "activated-machine";
        String xmlActivatedMachineTag = "<" + xmlActivatedMachineTagName + ">";
        LinkedList<IluActivatedMachine> moduleList = new LinkedList<IluActivatedMachine>();
        String xml = null;
        try {
            xml = IluActivatedModule.getFirstValue(xmlActivatedMachinesTagName, contents);
        }
        catch (IluXMLTagNotFoundException e) {
            return new IluActivatedMachine[0];
        }
        int start = 0;
        while ((start = xml.indexOf(xmlActivatedMachineTag, start)) >= 0) {
            try {
                moduleList.add(IluActivatedMachine.getInstanceFromXML(xmlActivatedMachineTagName, xml, start));
            }
            catch (IluXMLTagNotFoundException e) {
                // empty catch block
            }
            start += xmlActivatedMachineTag.length();
        }
        return moduleList.toArray(new IluActivatedMachine[0]);
    }
}

