/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluCharsetTools;
import ilog.jum.util.IluEnum;
import ilog.jum.util.IluInvalidCharsetException;

public class IluCharsetEnum
extends IluEnum {
    private static IluCharsetEnum ISO_8859_1 = null;
    private static IluCharsetEnum US_ASCII = null;
    private static IluCharsetEnum UTF_8 = null;

    private IluCharsetEnum(String name) {
        super(name);
        try {
            IluCharsetTools.charsetForName(name);
        }
        catch (IluInvalidCharsetException e) {
            throw new RuntimeException("Impossible, since charset " + name + " is supposed to be supported!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IluCharsetEnum ISO_8859_1() {
        Class clazz = IluCharsetEnum.class;
        synchronized (clazz) {
            if (ISO_8859_1 == null) {
                ISO_8859_1 = new IluCharsetEnum("ISO-8859-1");
            }
        }
        return ISO_8859_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IluCharsetEnum US_ASCII() {
        Class clazz = IluCharsetEnum.class;
        synchronized (clazz) {
            if (US_ASCII == null) {
                US_ASCII = new IluCharsetEnum("US-ASCII");
            }
        }
        return US_ASCII;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IluCharsetEnum UTF_8() {
        Class clazz = IluCharsetEnum.class;
        synchronized (clazz) {
            if (UTF_8 == null) {
                UTF_8 = new IluCharsetEnum("UTF-8");
            }
        }
        return UTF_8;
    }
}

