/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluCharacterCodingException;
import ilog.jum.util.IluCharsetEnum;
import ilog.jum.util.IluInvalidCharsetException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IluCharsetTools {
    public static final String SAM_DEFAULT_CHARSET_NAME = "" + IluCharsetEnum.UTF_8();

    public static String getHTTPCharset(String contentType) {
        Pattern pattern = Pattern.compile("charset\\s*=\\s*([\\p{Alnum}-_:.]*)");
        Matcher matcher = pattern.matcher(contentType);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String decode(byte[] data) throws IluCharacterCodingException {
        try {
            return IluCharsetTools.decode(data, SAM_DEFAULT_CHARSET_NAME);
        }
        catch (IluInvalidCharsetException e) {
            return null;
        }
    }

    public static String decode(byte[] data, String charsetName) throws IluInvalidCharsetException, IluCharacterCodingException {
        Charset charset = IluCharsetTools.charsetForName(charsetName);
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        try {
            CharBuffer charBuffer = decoder.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new IluCharacterCodingException(e);
        }
    }

    public static String decode(byte[] data, IluCharsetEnum charsetEnum) throws IluCharacterCodingException {
        try {
            return IluCharsetTools.decode(data, "" + charsetEnum);
        }
        catch (IluInvalidCharsetException e) {
            throw new RuntimeException("Impossible, since charsetEnum " + charsetEnum + " *is* supported!");
        }
    }

    public static byte[] encode(String data) throws IluCharacterCodingException {
        try {
            return IluCharsetTools.encode(data, SAM_DEFAULT_CHARSET_NAME);
        }
        catch (IluInvalidCharsetException e) {
            return null;
        }
    }

    public static byte[] encode(String data, String charsetName) throws IluInvalidCharsetException, IluCharacterCodingException {
        Charset charset = IluCharsetTools.charsetForName(charsetName);
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer charBuffer = CharBuffer.wrap(data);
        try {
            ByteBuffer byteBuffer = encoder.encode(charBuffer);
            return IluCharsetTools.byteBufferToByteArray(byteBuffer);
        }
        catch (CharacterCodingException e) {
            throw new IluCharacterCodingException(e);
        }
    }

    public static byte[] encode(String data, IluCharsetEnum charsetEnum) throws IluCharacterCodingException {
        try {
            return IluCharsetTools.encode(data, "" + charsetEnum);
        }
        catch (IluInvalidCharsetException e) {
            throw new RuntimeException("Impossible, since charsetEnum " + charsetEnum + " *is* supported!");
        }
    }

    public static Charset charsetForName(String charsetName) throws IluInvalidCharsetException {
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            throw new IluInvalidCharsetException("Unknown charset: " + charsetName, e);
        }
        catch (UnsupportedCharsetException e) {
            throw new IluInvalidCharsetException("Unsupported charset: " + charsetName, e);
        }
    }

    public static byte[] byteBufferToByteArray(ByteBuffer buffer) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        buffer.rewind();
        try {
            while (true) {
                byteArray.write(buffer.get());
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return byteArray.toByteArray();
        }
    }

    public static String encodeLikeId(String clear) {
        if (clear == null) {
            return null;
        }
        try {
            return URLEncoder.encode(clear, "" + IluCharsetEnum.UTF_8());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible exception, " + IluCharsetEnum.UTF_8() + " is allways supported!", e);
        }
    }

    public static String decodeLikeId(String encoded, String context) {
        if (encoded == null) {
            return null;
        }
        try {
            return URLDecoder.decode(encoded, "" + IluCharsetEnum.UTF_8());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible exception, " + IluCharsetEnum.UTF_8() + " is allways supported!", e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Can't decode <<" + encoded + ">> because it was not generated by encodeLikeId.  Context is: " + context, e);
        }
    }
}

