/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class IluDateFormat {
    private IluDateFormat() {
    }

    private static SimpleDateFormat makeDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ENGLISH);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    private static SimpleDateFormat getFormatSecZ() {
        SimpleDateFormat dateFormatSecZ = IluDateFormat.makeDateFormat("yyyy-MM-dd HH:mm:ss z");
        return dateFormatSecZ;
    }

    private static SimpleDateFormat getFormatSec() {
        SimpleDateFormat dateFormatSec = IluDateFormat.makeDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormatSec;
    }

    private static SimpleDateFormat getFormatDay() {
        SimpleDateFormat dateFormatDay = IluDateFormat.makeDateFormat("yyyy-MM-dd");
        return dateFormatDay;
    }

    private static SimpleDateFormat getFormatRelease() {
        SimpleDateFormat dateFormatRelease = IluDateFormat.makeDateFormat("yyyyMMdd");
        return dateFormatRelease;
    }

    private static SimpleDateFormat getFormatOnlineMachineLocal() {
        SimpleDateFormat dateFormatRelease = IluDateFormat.makeDateFormat("yyyyMMdd");
        return dateFormatRelease;
    }

    public static Date parseDay(String input) throws ParseException {
        return IluDateFormat.getFormatDay().parse(input);
    }

    public static String formatDay(Date date) {
        return IluDateFormat.getFormatDay().format(date);
    }

    public static Date parseRelease(String input) throws ParseException {
        return IluDateFormat.getFormatRelease().parse(input);
    }

    public static String formatRelease(Date date) {
        return IluDateFormat.getFormatRelease().format(date);
    }

    public static Date parseOnlineMachineLocal(String input) throws ParseException {
        return IluDateFormat.getFormatOnlineMachineLocal().parse(input);
    }

    public static String formatOnlineMachineLocal(Date date) {
        return IluDateFormat.getFormatOnlineMachineLocal().format(date);
    }

    public static Date parseSecZ(String input) throws ParseException {
        return IluDateFormat.getFormatSecZ().parse(input);
    }

    public static String formatSecZ(Date date) {
        return IluDateFormat.getFormatSecZ().format(date);
    }

    public static Date parseSec(String input) throws ParseException {
        return IluDateFormat.getFormatSec().parse(input);
    }

    public static String formatSec(Date date) {
        return IluDateFormat.getFormatSec().format(date);
    }
}

