/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluDigestorInvalidFormatException;
import ilog.jum.util.IluMD5;
import java.io.UnsupportedEncodingException;

public class IluDigestor {
    public static final String DEFAULT_DIGESTOR_TAG = "digest";
    private String m_startTag;
    private String m_stopTag;

    public IluDigestor(String tagName) {
        this.m_startTag = "<" + tagName + ">";
        this.m_stopTag = "</" + tagName + ">";
    }

    public IluDigestor() {
        this(DEFAULT_DIGESTOR_TAG);
    }

    public String emptyDigestBlock() {
        return this.m_startTag + this.m_stopTag;
    }

    public String unset(String text) throws IluDigestorInvalidFormatException {
        if (text == null) {
            throw new IluDigestorInvalidFormatException("Text is null.\n");
        }
        String s = text;
        int start = s.indexOf(this.m_startTag);
        int stop = s.indexOf(this.m_stopTag);
        if (start == -1 || stop == -1) {
            throw new IluDigestorInvalidFormatException("No " + this.m_startTag + " or " + this.m_stopTag + " found.\n");
        }
        return s.substring(0, start + this.m_startTag.length()) + s.substring(stop);
    }

    public boolean check(String text) throws IluDigestorInvalidFormatException {
        if (text == null) {
            throw new IluDigestorInvalidFormatException("Text is null.\n");
        }
        String s = text;
        int start = s.indexOf(this.m_startTag);
        int stop = s.indexOf(this.m_stopTag);
        if (start == -1 || stop == -1) {
            throw new IluDigestorInvalidFormatException("No " + this.m_stopTag + " or " + this.m_stopTag + " found.\n");
        }
        String oldmd5 = s.substring(start + this.m_startTag.length(), stop).trim();
        String raw = s.substring(0, start + this.m_startTag.length()) + s.substring(stop);
        String newmd5 = IluMD5.fromString(this.canonicalize(raw));
        return oldmd5.equalsIgnoreCase(newmd5);
    }

    public String set(String text) throws IluDigestorInvalidFormatException {
        if (text == null) {
            throw new IluDigestorInvalidFormatException("Text is null");
        }
        String s = this.unset(text);
        int start = s.indexOf(this.m_startTag);
        int stop = s.indexOf(this.m_stopTag);
        if (start == -1 || stop == -1) {
            throw new IluDigestorInvalidFormatException("No " + this.m_stopTag + " or " + this.m_stopTag + " found.\n");
        }
        String newmd5 = IluMD5.fromString(this.canonicalize(s));
        return s.substring(0, start + this.m_startTag.length()) + newmd5 + s.substring(stop);
    }

    public String canonicalize(String text) throws IluDigestorInvalidFormatException {
        String s = text.trim();
        int size = s.length();
        try {
            byte[] buf = s.getBytes(IluMD5.CHARSET_NAME);
            byte[] res = new byte[size];
            boolean space = false;
            int j = 0;
            block5: for (int i = 0; i < size; ++i) {
                switch (buf[i]) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        if (space) continue block5;
                        res[j++] = 32;
                        space = true;
                        continue block5;
                    }
                    default: {
                        res[j++] = buf[i];
                        space = false;
                    }
                }
            }
            return new String(res, 0, j, IluMD5.CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new IluDigestorInvalidFormatException(e.getMessage());
        }
    }

    public static final boolean isValidDigest(String s) {
        IluDigestor digest = new IluDigestor(DEFAULT_DIGESTOR_TAG);
        try {
            if (s != null && digest.check(s)) {
                return true;
            }
        }
        catch (IluDigestorInvalidFormatException iluDigestorInvalidFormatException) {
            // empty catch block
        }
        return false;
    }
}

