/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluCharsetEnum;
import ilog.jum.util.IluCharsetTools;
import ilog.jum.util.IluEncodingException;

public class IluEncodedData {
    private static final String FALLBACK_CHARSET_NAME = "" + IluCharsetEnum.ISO_8859_1();
    private byte[] data;
    private String charset;

    public IluEncodedData(byte[] data, String charsetName) {
        if (data == null) {
            throw new IllegalArgumentException("data argument can't be null");
        }
        this.data = data;
        this.charset = this.charset;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getCharset() {
        return this.charset;
    }

    public String decode() {
        try {
            return this.decode(FALLBACK_CHARSET_NAME);
        }
        catch (IluEncodingException e) {
            return "";
        }
    }

    public String decode(String fallbackCharset) throws IluEncodingException {
        if (this.charset != null) {
            try {
                return IluCharsetTools.decode(this.data, this.charset);
            }
            catch (IluEncodingException iluEncodingException) {
                // empty catch block
            }
        }
        return IluCharsetTools.decode(this.data, fallbackCharset);
    }
}

