/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;

public class IluFileBuffer {
    public static String getFileBuffer(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return IluFileBuffer.getStreamContent(in);
    }

    public static String getStreamContent(InputStream in) throws IOException {
        return new String(IluFileBuffer.getStreamContentAsBytes(in));
    }

    public static byte[] getStreamContentAsBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        byte[] buffer = new byte[512];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
        return out.toByteArray();
    }

    public static String getFileBuffer(String fileName) throws IOException {
        return IluFileBuffer.getFileBuffer(new File(fileName));
    }

    public static String saveFileBuffer(String fileName, String text) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        OutputStreamWriter osw = new OutputStreamWriter(out);
        BufferedWriter bdw = new BufferedWriter(osw);
        bdw.write(text, 0, text.length());
        bdw.close();
        osw.close();
        out.close();
        return fileName;
    }

    public static String saveTmpFileBuffer(String fileName, String text) throws IOException {
        String tmpdir = IluFileBuffer.getTempDirectory();
        return IluFileBuffer.saveFileBuffer(tmpdir + fileName, text);
    }

    public static String getTempDirectory() throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir", "/tmp") + System.getProperty("file.separator", "/");
        if (tmpdir == null) {
            throw new IOException("can't get temporary directory");
        }
        File dir = new File(tmpdir);
        if (!dir.exists()) {
            throw new IOException("can't access temporary directory named " + tmpdir);
        }
        return tmpdir;
    }
}

