/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.IluTags;
import ilog.jum.util.IluActivatedMachine;
import ilog.jum.util.IluDateFormat;
import ilog.jum.util.IluModuleException;
import ilog.jum.util.IluModuleReleaseDateException;
import ilog.jum.util.IluModuleUseTypeException;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLException;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class IluLicensedModule
extends IluXML
implements IluTags {
    static final long serialVersionUID = -6407904790448081150L;
    private static final String sXmlToplevelStartTag = "licensed-module";
    private String fModName;
    private String fUsageType;
    private String fLicensedUptoRelId;
    private Date fLicensedUptoRelDate;
    private Date fLicensedUntil;
    private String fLicensedCPU;
    private String fReportMedium;
    private String[] fAppNames;
    private IluActivatedMachine[] fActivatedMachine;
    private static Date sMinRelDate;
    private static Date sMaxRelDate;

    public IluLicensedModule(String modName, String usageType, String licensedUptoRelId, Date licensedUptoRelDate, Date licensedUntil, String licensedCPU, String reportMedium, String[] appNames, IluActivatedMachine[] activatedMachine) throws IluModuleReleaseDateException, IluModuleUseTypeException {
        super(sXmlToplevelStartTag);
        this.fModName = modName;
        this.fUsageType = usageType;
        this.fLicensedUptoRelId = licensedUptoRelId;
        this.fLicensedUptoRelDate = licensedUptoRelDate;
        this.fLicensedUntil = licensedUntil;
        this.fLicensedCPU = licensedCPU;
        this.fReportMedium = reportMedium;
        this.fAppNames = appNames;
        this.fActivatedMachine = activatedMachine;
        boolean knownUseType = VALID_USAGES.contains(this.fUsageType);
        if (!knownUseType) {
            throw new IluModuleUseTypeException("'" + this.fUsageType + "' is an unknown usage type.");
        }
        if (this.fLicensedUptoRelDate != null) {
            if (this.fLicensedUptoRelDate.before(sMinRelDate)) {
                throw new IluModuleReleaseDateException("Release date request is before " + sMinRelDate);
            }
            if (this.fLicensedUptoRelDate.after(sMaxRelDate)) {
                throw new IluModuleReleaseDateException("Release date request is after " + sMaxRelDate);
            }
        }
    }

    public static IluLicensedModule getInstanceFromXML(String xml) throws IluModuleReleaseDateException, IluModuleUseTypeException, IluXMLTagNotFoundException {
        String modName = IluLicensedModule.getStringValue("module-name", xml);
        String usageType = IluLicensedModule.getStringValue("usage-type", xml);
        String licensedUptoRelId = IluLicensedModule.getStringValue("licensed-upto-release-id", xml);
        Date licensedUptoRelDate = IluLicensedModule.getDateValue("licensed-upto-release-date", xml);
        Date licensedUntil = IluLicensedModule.getDateValue("licensed-until", xml);
        String licensedCPU = IluLicensedModule.getStringValue("licensed-nb-cpu", xml);
        String reportMedium = IluLicensedModule.getStringValue("report-medium", xml);
        List list = IluLicensedModule.getFirstMultipleValues("application-array", "application-name", xml);
        String[] appNames = list.toArray(new String[0]);
        IluActivatedMachine[] activatedMachine = IluLicensedModule.getActivatedMachinesFromXML(xml);
        return new IluLicensedModule(modName, usageType, licensedUptoRelId, licensedUptoRelDate, licensedUntil, licensedCPU, reportMedium, appNames, activatedMachine);
    }

    public final String getName() {
        return this.fModName;
    }

    public final String getUsageType() {
        return this.fUsageType;
    }

    public final String getLicensedUptoRelId() {
        return this.fLicensedUptoRelId;
    }

    public final Date getLicensedUptoRelDate() {
        return this.fLicensedUptoRelDate;
    }

    public final Date getLicensedUntil() {
        return this.fLicensedUntil;
    }

    public final String getLicensedCPU() {
        return this.fLicensedCPU;
    }

    public final String getReportMedium() {
        return this.fReportMedium;
    }

    public final String[] getAppNames() {
        return this.fAppNames;
    }

    public final IluActivatedMachine[] getActivatedMachines() {
        return this.fActivatedMachine;
    }

    private static final String getStringValue(String xmlTag, String xmlText) {
        try {
            return IluLicensedModule.getFirstValue(xmlTag, xmlText);
        }
        catch (IluXMLTagNotFoundException e) {
            return null;
        }
    }

    private static final Date getDateValue(String xmlTag, String xmlText) {
        try {
            String dateString = IluLicensedModule.getFirstValue(xmlTag, xmlText);
            return IluDateFormat.parseSecZ(dateString);
        }
        catch (IluXMLTagNotFoundException e) {
            System.out.println(e);
            return null;
        }
        catch (ParseException e) {
            System.out.println(e);
            return null;
        }
    }

    public static String getDate(Date date) {
        return IluDateFormat.formatSecZ(date);
    }

    protected void parseXML(String xmlBlock) throws IluXMLException {
        List list = IluLicensedModule.getFirstMultipleValues("application-array", "application-name", xmlBlock);
        this.fModName = IluLicensedModule.getStringValue("module-name", xmlBlock);
        this.fUsageType = IluLicensedModule.getStringValue("usage-type", xmlBlock);
        this.fLicensedUptoRelId = IluLicensedModule.getStringValue("licensed-upto-release-id", xmlBlock);
        this.fLicensedUptoRelDate = IluLicensedModule.getDateValue("licensed-upto-release-date", xmlBlock);
        this.fLicensedUntil = IluLicensedModule.getDateValue("licensed-until", xmlBlock);
        this.fLicensedCPU = IluLicensedModule.getStringValue("licensed-nb-cpu", xmlBlock);
        this.fReportMedium = IluLicensedModule.getStringValue("report-medium", xmlBlock);
        this.fAppNames = list.toArray(new String[0]);
        this.fActivatedMachine = IluLicensedModule.getActivatedMachinesFromXML(xmlBlock);
    }

    public String toXML(int indent) {
        int i;
        String prefix = IluLicensedModule.getIndent(indent);
        String header = "" + prefix + this.fXmlToplevelStartTag + "\n" + prefix + " " + IluLicensedModule.getTaggedValueln("module-name", this.fModName) + prefix + " " + IluLicensedModule.getTaggedValueln("usage-type", this.fUsageType) + prefix + " " + IluLicensedModule.getTaggedValueln("licensed-upto-release-id", this.fLicensedUptoRelId) + prefix + " " + IluLicensedModule.getTaggedValueln("licensed-upto-release-date", IluLicensedModule.getDate(this.fLicensedUptoRelDate)) + prefix + " " + IluLicensedModule.getTaggedValueln("licensed-until", IluLicensedModule.getDate(this.fLicensedUntil)) + prefix + " " + IluLicensedModule.getTaggedValueln("licensed-nb-cpu", this.fLicensedCPU) + prefix + " " + IluLicensedModule.getTaggedValueln("report-medium", this.fReportMedium);
        String data = "";
        data = data + prefix + " <application-array>\n";
        if (this.fAppNames != null) {
            for (i = 0; i < this.fAppNames.length; ++i) {
                data = data + "" + prefix + "  <application>\n" + prefix + "   " + IluLicensedModule.getTaggedValueln("application-name", this.fAppNames[i]) + prefix + "  </application>\n";
            }
        }
        data = data + prefix + " </application-array>\n";
        data = data + prefix + " <activated-machine-array>\n";
        if (this.fActivatedMachine != null) {
            for (i = 0; i < this.fActivatedMachine.length; ++i) {
                data = data + this.fActivatedMachine[i].toXML(indent + 2);
            }
        }
        data = data + prefix + " </activated-machine-array>\n";
        String footer = "" + prefix + this.fXmlToplevelStopTag + "\n";
        return header + data + footer;
    }

    public static final IluLicensedModule[] getLicensedModulesFromXML(String contents) throws IluModuleException {
        String xmlLicensedModulesTagName = "licensed-module-array";
        String xmlLicensedModuleStartTag = "<licensed-module>";
        String xmlLicensedModuleStopTag = "</licensed-module>";
        LinkedList<IluLicensedModule> moduleList = new LinkedList<IluLicensedModule>();
        String xml = null;
        try {
            xml = IluLicensedModule.getFirstValue(xmlLicensedModulesTagName, contents);
        }
        catch (IluXMLTagNotFoundException e) {
            return new IluLicensedModule[0];
        }
        int start = 0;
        while ((start = xml.indexOf(xmlLicensedModuleStartTag, start)) >= 0) {
            try {
                String license = IluLicensedModule.getFirstValue(sXmlToplevelStartTag, xml, start);
                moduleList.add(IluLicensedModule.getInstanceFromXML(license));
            }
            catch (IluXMLTagNotFoundException e) {
                // empty catch block
            }
            start = xml.indexOf(xmlLicensedModuleStopTag, start);
        }
        return moduleList.toArray(new IluLicensedModule[0]);
    }

    private static final IluActivatedMachine[] getActivatedMachinesFromXML(String contents) {
        String xmlActivatedMachinesTagName = "activated-machine-array";
        String xmlActivatedMachineTagName = "activated-machine";
        String xmlActivatedMachineTag = "<" + xmlActivatedMachineTagName + ">";
        LinkedList<IluActivatedMachine> moduleList = new LinkedList<IluActivatedMachine>();
        String xml = null;
        try {
            xml = IluLicensedModule.getFirstValue(xmlActivatedMachinesTagName, contents);
        }
        catch (IluXMLTagNotFoundException e) {
            return new IluActivatedMachine[0];
        }
        int start = 0;
        while ((start = xml.indexOf(xmlActivatedMachineTag, start)) >= 0) {
            try {
                moduleList.add(IluActivatedMachine.getInstanceFromXML(xmlActivatedMachineTagName, xml, start));
            }
            catch (IluXMLTagNotFoundException e) {
                System.out.println(e);
            }
            start += xmlActivatedMachineTag.length();
        }
        return moduleList.toArray(new IluActivatedMachine[0]);
    }

    public String toCSV() {
        String[] apps = this.getAppNames();
        String res = "" + this.getName() + ";" + this.getUsageType() + ";" + this.getLicensedUptoRelId() + ";" + this.getLicensedUptoRelDate() + ";";
        if (apps != null) {
            for (int i = 0; i < apps.length; ++i) {
                res = res + "\"" + apps[i] + "\"";
                if (i + 1 >= apps.length) continue;
                res = res + ", ";
            }
        }
        return res;
    }

    static {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
        cal.set(2000, 0, 1, 0, 0);
        sMinRelDate = cal.getTime();
        cal.set(2100, 0, 1, 0, 0);
        sMaxRelDate = cal.getTime();
    }
}

