/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluCharsetTools;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class IluMD5 {
    public static final String CHARSET_NAME = IluCharsetTools.SAM_DEFAULT_CHARSET_NAME;
    private static final String MD5 = "MD5";

    private IluMD5() {
    }

    private static void init(MessageDigest md) {
        md.reset();
        byte[] b = new byte[]{78, 26, 13, 43, 52, 20, 88, 39};
        for (int i = 0; i < b.length; ++i) {
            md.update(b[i]);
        }
    }

    public static String fromString(String text) {
        try {
            return IluMD5.fromString(text.getBytes(CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Can't compute digest of " + text, e);
        }
    }

    private static String fromString(byte[] text) {
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            IluMD5.init(md);
            md.update(text);
            return IluMD5.toHexString(md);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Can't compute digest because MD5is not supported!", e);
        }
    }

    private static String toHexString(MessageDigest md) {
        byte[] v = md.digest();
        return IluMD5.hexEncode(v);
    }

    private static String hexEncode(byte[] bytes) {
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer s = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            s.append(digits[(b & 0xF0) >> 4]);
            s.append(digits[b & 0xF]);
        }
        return s.toString();
    }

    static {
        try {
            MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Can't compute digest because MD5is not supported!", e);
        }
    }
}

