/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluDigestor;
import ilog.jum.util.IluDigestorInvalidFormatException;
import ilog.jum.util.IluMD5;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class IluMD5TaggedFile {
    private File file;
    protected String text;
    private IluDigestor digest;

    public IluMD5TaggedFile() {
        this.file = null;
        this.text = null;
        this.digest = new IluDigestor();
    }

    public IluMD5TaggedFile(File fileObj) throws IOException {
        this.file = fileObj;
        this.text = this.load();
        this.digest = new IluDigestor();
    }

    public IluMD5TaggedFile(String fileName) throws IOException {
        this(new File(fileName));
    }

    public final String untag() {
        try {
            this.text = this.digest.unset(this.text);
            return this.text;
        }
        catch (IluDigestorInvalidFormatException e) {
            return "";
        }
    }

    public final boolean check() {
        try {
            return this.digest.check(this.text);
        }
        catch (IluDigestorInvalidFormatException e) {
            return false;
        }
    }

    public final String tag() {
        try {
            this.text = this.digest.set(this.text);
            return this.text;
        }
        catch (IluDigestorInvalidFormatException e) {
            return "";
        }
    }

    protected final String load() throws IOException {
        StringBuffer text = new StringBuffer();
        FileInputStream in = new FileInputStream(this.file);
        InputStreamReader ir = new InputStreamReader((InputStream)in, IluMD5.CHARSET_NAME);
        BufferedReader br = new BufferedReader(ir);
        char[] buf = new char[1024];
        int i = 0;
        while ((i = br.read(buf)) > 0) {
            text.append(buf, 0, i);
        }
        br.close();
        ir.close();
        in.close();
        return text.toString();
    }

    public final void save() throws IOException {
        this.saveAs(this.file);
    }

    public final void tagAndSave() throws IOException {
        this.tag();
        this.save();
    }

    public final void saveAs(String fileName) throws IOException {
        this.saveAs(new File(fileName));
    }

    public final void saveAs(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(out);
        BufferedWriter bdw = new BufferedWriter(osw);
        bdw.write(this.text, 0, this.text.length());
        bdw.close();
        osw.close();
        out.close();
    }

    public final void canonicalize() throws IluDigestorInvalidFormatException {
        this.text = this.digest.canonicalize(this.text);
    }

    public static final boolean checkFile(String fileName) {
        IluMD5TaggedFile md5TaggedFile;
        try {
            md5TaggedFile = new IluMD5TaggedFile(new File(fileName));
        }
        catch (IOException e) {
            return false;
        }
        return md5TaggedFile.check();
    }

    public static final void setDigestInFile(String fileName) throws IOException, IluDigestorInvalidFormatException {
        IluMD5TaggedFile md5TaggedFile = new IluMD5TaggedFile(new File(fileName));
        md5TaggedFile.getDigest().set(md5TaggedFile.getText());
    }

    final IluDigestor getDigest() {
        return this.digest;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String newText) {
        this.text = newText;
    }

    public final void setFileName(String fileName) {
        this.file = new File(fileName);
    }
}

