/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluMachineInfo;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLException;
import ilog.jum.util.IluXMLString;
import ilog.jum.util.IluXMLTagNotFoundException;

public class IluMachine
extends IluXML {
    static final long serialVersionUID = -8777386506874691534L;
    protected static final String sToplevelMachineTag = "machine-info";
    private static IluMachine fCurrentMachine = null;
    protected String fMachineName;
    protected String fMachineIP;
    protected String fMachineCPU;
    protected static final String[] sDefaultMachineTagNames;

    public IluMachine(String machineName, String machineIP, String machineCPU) {
        super(sToplevelMachineTag);
        this.fMachineName = machineName;
        this.fMachineIP = machineIP;
        this.fMachineCPU = machineCPU;
    }

    public IluMachine(String machineName, String machineIP, int machineCPU) {
        this(machineName, machineIP, "" + machineCPU);
    }

    public IluMachine(String toplevelTag, IluXMLString xmlBlock) throws IluXMLException {
        super(toplevelTag, xmlBlock);
    }

    protected IluMachine(String[] value) {
        this(value[0], value[1], value[2]);
    }

    public static final IluMachine getCurrentInstance() {
        return fCurrentMachine;
    }

    protected IluMachine() {
        this(IluMachine.fCurrentMachine.fMachineName, IluMachine.fCurrentMachine.fMachineIP, IluMachine.fCurrentMachine.fMachineCPU);
    }

    public final String getMachineName() {
        return this.fMachineName;
    }

    public final String getMachineIP() {
        return this.fMachineIP;
    }

    public final String getMachineCPU() {
        return this.fMachineCPU;
    }

    public boolean match(String cmp) {
        return this.fMachineName.equals(cmp) || this.fMachineName.equals("*");
    }

    protected void parseXML(String xmlBlock) throws IluXMLTagNotFoundException {
        String[] tag = this.getTags();
        this.fMachineName = IluMachine.getFirstValue(tag[0], xmlBlock);
        this.fMachineIP = IluMachine.getFirstValue(tag[1], xmlBlock);
        this.fMachineCPU = IluMachine.getFirstValue(tag[2], xmlBlock);
    }

    public String toXML(int indent) {
        return this.toXML(sToplevelMachineTag, indent);
    }

    protected String toXML(String toplevelTag, int indent) {
        String prefix = IluXML.getIndent(indent);
        String[] tag = this.getTags();
        return "" + prefix + "<" + toplevelTag + ">\n" + prefix + " " + IluMachine.getTaggedValueln(tag[0], this.fMachineName) + prefix + " " + IluMachine.getTaggedValueln(tag[1], this.fMachineIP) + prefix + " " + IluMachine.getTaggedValueln(tag[2], this.fMachineCPU) + prefix + "</" + toplevelTag + ">\n";
    }

    protected String[] getTags() {
        return sDefaultMachineTagNames;
    }

    public boolean equals(IluMachine mach) {
        return this.fMachineName.equals(mach.fMachineName) && this.fMachineIP.equals(mach.fMachineIP);
    }

    static {
        IluMachineInfo currentMachine = IluMachineInfo.currentMachine();
        fCurrentMachine = new IluMachine(currentMachine.getMachineHost(), currentMachine.getMachineIp(), currentMachine.getGuessedCPUs());
        sDefaultMachineTagNames = new String[]{"machine-name", "machine-ip", "machine-cpus"};
    }
}

