/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluDateFormat;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;

public class IluMachineInfo
extends IluXML {
    static final long serialVersionUID = -1741069792359890233L;
    private static final String JOKER_HOST_NAME = "*";
    private static IluMachineInfo sCurrentMachine = null;
    private static final int IPV4PAD = 2;
    private static final int IPV6PAD = 4;
    private static final int IPV6LEN = 16;
    private static final int MAXNAME = 20;
    private static final int MAXASCII = 256;
    private static final int HEXABASE = 16;
    private final String fIP;
    private final String fHost;
    private final String fUnNomralizedHost;
    private final int fCPUs;
    private final Date fLocalDate;
    private static final String JAVA_VERSION = IluMachineInfo.getSystemProperty("java.version");
    private static final String JAVA_VENDOR = IluMachineInfo.getSystemProperty("java.vendor");
    private static final String OS_NAME = IluMachineInfo.getSystemProperty("os.name");
    private static final String OS_VERSION = IluMachineInfo.getSystemProperty("os.version");
    private static final String OS_ARCH = IluMachineInfo.getSystemProperty("os.arch");
    private static final String USER_NAME = IluMachineInfo.getSystemProperty("user.name");
    private static final String J2EE_VALUE = IluMachineInfo.getJ2EE();
    private static final String PROCESS_PID = Long.toString(Calendar.getInstance().getTime().getTime());

    public IluMachineInfo(String cookedIP, String unNomralizedHost, int nbCPUs, Date localDate) {
        super("computer-description");
        this.fIP = cookedIP;
        this.fUnNomralizedHost = unNomralizedHost;
        this.fCPUs = nbCPUs;
        this.fLocalDate = localDate;
        this.fHost = IluMachineInfo.normalizeHostname(unNomralizedHost);
    }

    public IluMachineInfo(String cookedIP, String unNomralizedHost, String nbCPUs, Date localDate) {
        this(cookedIP, unNomralizedHost, Integer.parseInt(nbCPUs), localDate);
    }

    public IluMachineInfo(String cookedIP, String unNomralizedHost, int nbCPUs) {
        this(cookedIP, unNomralizedHost, nbCPUs, new Date());
    }

    public IluMachineInfo(String cookedIP, String unNomralizedHost, String nbCPUs) {
        this(cookedIP, unNomralizedHost, nbCPUs, new Date());
    }

    public static final synchronized IluMachineInfo currentMachine() {
        if (sCurrentMachine == null) {
            sCurrentMachine = new IluMachineInfo("127.0.0.1", JOKER_HOST_NAME, "1");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return IluMachineInfo.computeCurrentMachine();
                    }
                    catch (SecurityException e) {
                        return sCurrentMachine;
                    }
                }
            });
        }
        return sCurrentMachine;
    }

    private static final IluMachineInfo computeCurrentMachine() {
        String dottedIP = "127.0.0.1";
        String unNomralizedHost = null;
        byte[] ip = null;
        int cpu = 1;
        InetAddress ia = IluMachineInfo.getLocalHost();
        if (ia != null) {
            dottedIP = ia.getHostAddress();
            unNomralizedHost = ia.getHostName();
            ip = ia.getAddress();
        } else {
            dottedIP = "127.0.0.1";
            unNomralizedHost = JOKER_HOST_NAME;
            ip = null;
        }
        boolean useInvoke = false;
        try {
            if (useInvoke) {
                Class<?> rt = Class.forName("java.lang.Runtime");
                Method m = rt.getDeclaredMethod("availableProcessors", new Class[0]);
                Object v = m.invoke((Object)Runtime.getRuntime(), new Object[0]);
                cpu = Integer.parseInt("" + v);
            } else {
                cpu = Runtime.getRuntime().availableProcessors();
            }
        }
        catch (SecurityException e) {
            cpu = 1;
        }
        catch (NoSuchMethodException e) {
            cpu = 1;
        }
        catch (Exception e) {
            cpu = 1;
        }
        sCurrentMachine = new IluMachineInfo(dottedIP, unNomralizedHost, cpu);
        return sCurrentMachine;
    }

    public static final synchronized IluMachineInfo currentMachine(Date localDate) {
        IluMachineInfo cur = IluMachineInfo.currentMachine();
        return new IluMachineInfo(cur.fIP, cur.fUnNomralizedHost, cur.fCPUs, localDate);
    }

    public static final String getSystemProperty(final String prop) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(prop);
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    private static InetAddress getLocalHost() {
        return (InetAddress)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    return null;
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    private static String getJ2EE() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String value = "unknown";
                try {
                    Class.forName("javax.ejb.EntityBean");
                    value = "true";
                }
                catch (ClassNotFoundException e) {
                    value = "false";
                }
                catch (ExceptionInInitializerError e) {
                    value = "unknown";
                }
                catch (SecurityException e) {
                    value = "unknown";
                }
                return value;
            }
        });
    }

    public static final String normalizeHostname(String host) {
        StringBuffer sb = new StringBuffer(host);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
        }
        String h = sb.toString().toLowerCase(Locale.US);
        int dotPos = h.indexOf(46);
        if (dotPos > 0) {
            h = h.substring(0, dotPos);
        }
        if (h.length() > 20) {
            h = h.substring(0, 10) + JOKER_HOST_NAME + h.substring(h.length() - 9);
        }
        return h;
    }

    public final String getMachineHost() {
        return this.fHost;
    }

    public final String getMachineIp() {
        return this.fIP;
    }

    public final String[] getAllMachineIp() {
        LinkedList<String> l = new LinkedList<String>();
        String name = null;
        try {
            name = InetAddress.getLocalHost().getHostName();
            InetAddress[] address = InetAddress.getAllByName(name);
            for (int i = 0; i < address.length; ++i) {
                InetAddress each = address[i];
                l.add(each.getHostAddress());
            }
            return l.toArray(new String[0]);
        }
        catch (UnknownHostException e) {
            String[] joker = new String[]{};
            return joker;
        }
    }

    public final String getUnNormalizedHost() {
        return this.fUnNomralizedHost;
    }

    public final int getGuessedCPUs() {
        return this.fCPUs;
    }

    public final Date getLocalDate() {
        return this.fLocalDate;
    }

    public static final String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static final String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static final String getOSName() {
        return OS_NAME;
    }

    public static final String getOSVersion() {
        return OS_VERSION;
    }

    public static final String getOSArch() {
        return OS_ARCH;
    }

    public static final String getUserName() {
        return USER_NAME;
    }

    public static final String getJavaEE() {
        return J2EE_VALUE;
    }

    public static final String getPID() {
        return PROCESS_PID;
    }

    private static final String computeApplicationServer() {
        try {
            Class.forName("oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory");
            return "OCJ4";
        }
        catch (Throwable t) {
            try {
                Class.forName("weblogic.management.MBeanHome");
                return "WebLogic";
            }
            catch (Throwable t2) {
                try {
                    Class.forName("com.ibm.websphere.management.AdminServiceFactory");
                    return "WebSphere";
                }
                catch (Throwable t3) {
                    try {
                        Class.forName("org.jboss.ha.framework.interfaces.HAPartition");
                        Class.forName("org.jboss.invocation.InvokerInterceptor");
                        return "JBoss";
                    }
                    catch (Throwable t4) {
                        try {
                            Class.forName("mx4j.tools.adaptor.http.HttpAdaptor");
                            Class.forName("mx4j.tools.adaptor.http.XSLTProcessor");
                            Class.forName("mx4j.tools.naming.NamingService");
                            return "MX4J";
                        }
                        catch (Throwable t5) {
                            try {
                                Class.forName("org.apache.catalina.startup.Catalina");
                                return "Tomcat";
                            }
                            catch (Throwable throwable) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    private static String getPreferedIPFormat(String dottedIP, byte[] ip) {
        String resIP;
        boolean usePreferedFormat = true;
        if (usePreferedFormat || ip == null) {
            resIP = dottedIP;
        } else {
            resIP = "";
            if (ip != null) {
                int len = ip.length;
                int pad = 2;
                if (len == 16) {
                    pad = 4;
                }
                for (int i = 0; i < ip.length; ++i) {
                    int val = ip[i];
                    if (val < 0) {
                        val = 256 + val;
                    }
                    String hex = Integer.toString(val, 16);
                    while (hex.length() < pad) {
                        hex = hex + "0" + Integer.toString(val, 16);
                    }
                    resIP = resIP + hex;
                }
            }
        }
        return resIP;
    }

    protected void parseXML(String xmlBlock) throws IluXMLTagNotFoundException {
        new RuntimeException("IluMachineInfo.parseXML(String) is not implemented.\n" + xmlBlock);
    }

    public final String toXML(int indent) {
        String prefix = IluMachineInfo.getIndent(indent);
        String date = IluDateFormat.formatSecZ(this.fLocalDate);
        return "" + prefix + this.fXmlToplevelStartTag + "\n" + this.machineToXML(indent + 1) + this.marketingToXML(indent + 1) + prefix + " " + IluMachineInfo.getTaggedValueln("local-date", date) + prefix + this.fXmlToplevelStopTag + "\n";
    }

    public final String machineToXML(int indent) {
        String prefix = IluMachineInfo.getIndent(indent);
        return "" + prefix + IluMachineInfo.getTaggedValueln("machine-name", this.fHost) + prefix + IluMachineInfo.getTaggedValueln("machine-ip", this.fIP) + prefix + IluMachineInfo.getTaggedValueln("machine-cpus", this.fCPUs) + prefix + IluMachineInfo.getTaggedValueln("machine-full-name", this.fUnNomralizedHost);
    }

    public final String marketingToXML(int indent) {
        String prefix = IluMachineInfo.getIndent(indent);
        String date = IluDateFormat.formatSecZ(this.fLocalDate);
        return "" + prefix + IluMachineInfo.getTaggedValueln("java-vendor", IluMachineInfo.getJavaVendor()) + prefix + IluMachineInfo.getTaggedValueln("java-version", IluMachineInfo.getJavaVersion()) + prefix + IluMachineInfo.getTaggedValueln("j2ee", IluMachineInfo.getJavaEE()) + prefix + IluMachineInfo.getTaggedValueln("os-name", IluMachineInfo.getOSName()) + prefix + IluMachineInfo.getTaggedValueln("os-arch", IluMachineInfo.getOSArch()) + prefix + IluMachineInfo.getTaggedValueln("os-version", IluMachineInfo.getOSVersion());
    }
}

