/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.IluProductAndModuleNames;
import ilog.jum.IluTags;
import ilog.jum.util.IluDateFormat;
import ilog.jum.util.IluModuleException;
import ilog.jum.util.IluModuleNameException;
import ilog.jum.util.IluModuleReleaseDateException;
import ilog.jum.util.IluModuleUseTypeException;
import ilog.jum.util.IluXML;
import ilog.jum.util.IluXMLParseException;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;

public class IluModule
extends IluXML
implements IluProductAndModuleNames,
IluTags {
    static final long serialVersionUID = -3937644743424987571L;
    private String fModName;
    private Date fModRelDate;
    private String fModRelId;
    private String fModUseType;
    private static Date sMinRelDate;
    private static Date sMaxRelDate;
    private static final String[] MODULE_TAG_NAMES;

    public IluModule(String modName, Date modRelDate, String modRelId, String modUseType) throws IluModuleReleaseDateException, IluModuleNameException, IluModuleUseTypeException {
        super("module");
        this.fModName = modName;
        this.fModRelDate = modRelDate;
        this.fModRelId = modRelId;
        this.fModUseType = modUseType;
        this.validateFields();
    }

    private void validateFields() throws IluModuleReleaseDateException, IluModuleNameException, IluModuleUseTypeException {
        if (!VALID_MODULES.contains(this.fModName)) {
            throw new IluModuleNameException(": License for ILOG module '" + this.fModName + "' is refused because licenses" + " are granted only for " + VALID_MODULES + ".");
        }
        if (!VALID_USAGES.contains(this.fModUseType)) {
            throw new IluModuleUseTypeException(": License for usage '" + this.fModUseType + "' is refused because licenses" + " are granted only for " + VALID_USAGES + ".");
        }
        if (this.fModRelDate == null) {
            throw new IluModuleReleaseDateException("Release date request is null");
        }
        if (this.fModRelDate.before(sMinRelDate)) {
            throw new IluModuleReleaseDateException("Release date request is before " + sMinRelDate);
        }
        if (this.fModRelDate.after(sMaxRelDate)) {
            throw new IluModuleReleaseDateException("Release date request is after " + sMaxRelDate);
        }
    }

    public static final IluModule[] getInstancesFromXML(String toplevelTag, String xmlText, int start) throws IluModuleException {
        String xmlToplevelModuleTagName = toplevelTag;
        String xmlToplevelModuleStartTag = "<" + xmlToplevelModuleTagName + ">";
        String xmlToplevelModuleStopTag = "</" + xmlToplevelModuleTagName + ">";
        LinkedList<IluModule> moduleList = new LinkedList<IluModule>();
        while ((start = xmlText.indexOf(xmlToplevelModuleStartTag, start)) >= 0) {
            try {
                IluModule lm = IluModule.getInstanceFromXML(xmlToplevelModuleTagName, xmlText, start);
                moduleList.add(lm);
            }
            catch (IluXMLTagNotFoundException e) {
                // empty catch block
            }
            start = xmlText.indexOf(xmlToplevelModuleStopTag, start);
        }
        return moduleList.toArray(new IluModule[0]);
    }

    public static final IluModule[] getInstancesFromXML(String toplevelTag, String xmlText) throws IluModuleException {
        return IluModule.getInstancesFromXML(toplevelTag, xmlText, 0);
    }

    public static IluModule getInstanceFromXML(String toplevelTag, String xmlText, int start) throws IluModuleReleaseDateException, IluModuleNameException, IluModuleUseTypeException, IluXMLTagNotFoundException {
        String[] tagVal = IluModule.getFirstSubTagsValues(toplevelTag, MODULE_TAG_NAMES, xmlText, start);
        Date date = null;
        if (tagVal[1] != null) {
            try {
                date = IluDateFormat.parseSecZ(tagVal[1]);
            }
            catch (ParseException e) {
                throw new IluModuleReleaseDateException(e.getMessage());
            }
        }
        return new IluModule(tagVal[0], date, tagVal[2], tagVal[3]);
    }

    public static IluModule getInstanceFromXML(String toplevelTag, String xmlText) throws IluModuleReleaseDateException, IluModuleNameException, IluModuleUseTypeException, IluXMLTagNotFoundException {
        return IluModule.getInstanceFromXML(toplevelTag, xmlText, 0);
    }

    public final String getName() {
        return this.fModName;
    }

    public final Date getReleaseDate() {
        return this.fModRelDate;
    }

    public final String getReleaseDateString() {
        if (this.fModRelDate != null) {
            return IluDateFormat.formatSecZ(this.fModRelDate);
        }
        return null;
    }

    public final String getReleaseDateForDB() {
        if (this.fModRelDate != null) {
            return IluDateFormat.formatRelease(this.fModRelDate);
        }
        return null;
    }

    public final String getReleaseId() {
        return this.fModRelId;
    }

    public final String getUsageType() {
        return this.fModUseType;
    }

    public final String toString() {
        return "" + this.fModName + "/" + this.fModUseType + " (release " + this.fModRelId + " " + this.getReleaseDateString() + ")";
    }

    public boolean equals(IluModule m) {
        return this.fModName.equals(m.fModName) && this.fModUseType.equals(m.fModUseType) && this.fModRelId.equals(m.fModRelId);
    }

    protected void parseXML(String xmlBlock) throws IluXMLParseException {
        try {
            String date = IluModule.getFirstValue("release-date", xmlBlock);
            this.fModRelDate = IluDateFormat.parseSecZ(date);
            this.fModName = IluModule.getFirstValue("module-name", xmlBlock);
            this.fModUseType = IluModule.getFirstValue("usage-type", xmlBlock);
            this.fModRelId = IluModule.getFirstValue("release-id", xmlBlock);
            this.validateFields();
        }
        catch (Exception e) {
            throw new IluXMLParseException(e.getMessage());
        }
    }

    public final String toXML(int indent) {
        String offset = IluModule.getIndent(indent);
        return "" + offset + IluModule.getTaggedValueln("module-name", this.fModName) + offset + IluModule.getTaggedValueln("usage-type", this.fModUseType) + offset + IluModule.getTaggedValueln("release-id", this.fModRelId) + offset + IluModule.getTaggedValueln("release-date", this.getReleaseDateString());
    }

    static {
        MODULE_TAG_NAMES = new String[]{"module-name", "release-date", "release-id", "usage-type"};
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
        cal.set(2000, 0, 1, 0, 0);
        sMinRelDate = cal.getTime();
        cal.set(2100, 0, 1, 0, 0);
        sMaxRelDate = cal.getTime();
    }
}

