/*
 * Decompiled with CFR 0.152.
 */
package ilog.jum.util;

import ilog.jum.util.IluXMLException;
import ilog.jum.util.IluXMLParseException;
import ilog.jum.util.IluXMLString;
import ilog.jum.util.IluXMLTagNotFoundException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public abstract class IluXML
implements Serializable {
    static final long serialVersionUID = -7513929130567003086L;
    protected String fXmlToplevelTag;
    protected String fXmlToplevelStartTag;
    protected String fXmlToplevelStopTag;

    public IluXML(String toplevelTag) {
        this.setToplevelTag(toplevelTag);
    }

    public IluXML(String toplevelTag, IluXMLString xmlBlock) throws IluXMLException {
        String xml = xmlBlock.toString();
        this.setToplevelTag(toplevelTag);
        int start = xml.indexOf(this.fXmlToplevelStartTag);
        int stop = xml.indexOf(this.fXmlToplevelStopTag);
        if (stop <= start) {
            throw new IluXMLParseException("Can't parse " + xmlBlock + " to build a " + this.getClass().getName() + " object.");
        }
        this.parseXML(IluXML.getFirstValue(this.fXmlToplevelTag, xml));
    }

    protected abstract void parseXML(String var1) throws IluXMLException;

    public static String getFirstValue(String tag, String text) throws IluXMLTagNotFoundException {
        return IluXML.getFirstValue(tag, text, 0);
    }

    public static String getFirstValue(String tag, String text, int pos) throws IluXMLTagNotFoundException {
        if (tag == null || text == null) {
            return null;
        }
        String startTag = "<" + tag + ">";
        String stopTag = "</" + tag + ">";
        int start = text.indexOf(startTag, pos);
        int stop = text.indexOf(stopTag, start);
        if (start == -1 || stop == -1) {
            throw new IluXMLTagNotFoundException("XML tag not found: " + tag);
        }
        return text.substring(start + startTag.length(), stop).trim();
    }

    public static List getFirstMultipleValues(String tag, String itemTag, String text) throws IluXMLTagNotFoundException {
        return IluXML.getFirstMultipleValues(tag, itemTag, text, 0);
    }

    public static List getFirstMultipleValues(String tag, String itemTag, String text, int pos) throws IluXMLTagNotFoundException {
        LinkedList<String> list = new LinkedList<String>();
        String tagValue = IluXML.getFirstValue(tag, text, pos);
        if (tagValue != null) {
            String startTag = "<" + itemTag + ">";
            String stopTag = "</" + itemTag + ">";
            int start = tagValue.indexOf(startTag);
            int stop = tagValue.indexOf(stopTag);
            while (start >= 0 && stop >= 0) {
                list.add(tagValue.substring(start + startTag.length(), stop));
                start = tagValue.indexOf(startTag, stop + stopTag.length());
                stop = tagValue.indexOf(stopTag, stop + stopTag.length());
            }
        }
        return list;
    }

    public static String[] getFirstSubTagsValues(String tag, String[] itemTags, String text, int pos) throws IluXMLTagNotFoundException {
        String tagValue = IluXML.getFirstValue(tag, text, pos);
        String[] resValues = new String[itemTags.length];
        if (tagValue != null) {
            for (int i = 0; i < itemTags.length; ++i) {
                try {
                    String itemValue;
                    resValues[i] = itemValue = IluXML.getFirstValue(itemTags[i], tagValue);
                    continue;
                }
                catch (IluXMLTagNotFoundException e) {
                    resValues[i] = null;
                }
            }
        }
        return resValues;
    }

    public static String[] getFirstSubTagsValues(String tag, String[] itemTags, String text) throws IluXMLTagNotFoundException {
        return IluXML.getFirstSubTagsValues(tag, itemTags, text, 0);
    }

    public static String setFirstValue(String tag, String text, String val) {
        if (tag == null || text == null) {
            return null;
        }
        String startTag = "<" + tag + ">";
        String stopTag = "</" + tag + ">";
        int start = text.indexOf(startTag);
        int stop = text.indexOf(stopTag);
        if (start == -1 || stop == -1) {
            return null;
        }
        return text.substring(0, start + startTag.length()) + val + text.substring(stop);
    }

    public static String tag2spaces(String tag, String val) {
        String text = "  <" + tag + ">";
        text = text + val;
        text = text + "</" + tag + ">\n";
        return text;
    }

    public static String valueXmlRepresentation(String text) {
        String val = text;
        if (val != null) {
            val = val.replaceAll("&", "&amp;");
            val = val.replaceAll("<", "&lt;");
            val = val.replaceAll(">", "&gt;");
        }
        return val;
    }

    public static String xmlRepresentationValue(String xmlText) {
        String repr = xmlText;
        repr = repr.replaceAll("&lt;", "<");
        repr = repr.replaceAll("&gt;", ">");
        repr = repr.replaceAll("&amp;", "&");
        return repr;
    }

    public static final String getTaggedValue(String xmlTag, Object value) {
        return "<" + xmlTag + ">" + (value != null ? IluXML.valueXmlRepresentation(value.toString()) : value) + "</" + xmlTag + ">";
    }

    public static final String getTaggedValue(String xmlTag, int value) {
        return "<" + xmlTag + ">" + Integer.toString(value) + "</" + xmlTag + ">";
    }

    public static final String getTaggedValue(String xmlTag, boolean value) {
        return "<" + xmlTag + ">" + "" + value + "</" + xmlTag + ">";
    }

    public static final String getTaggedValueln(String xmlTag, Object value) {
        return IluXML.getTaggedValue(xmlTag, value) + "\n";
    }

    public static final String getTaggedValueln(String xmlTag, boolean value) {
        return IluXML.getTaggedValueln(xmlTag, "" + value);
    }

    public static final String getTaggedValueln(String xmlTag, int value) {
        return IluXML.getTaggedValueln(xmlTag, Integer.toString(value));
    }

    public static final String getTaggedValueln(String xmlTag, long value) {
        return IluXML.getTaggedValueln(xmlTag, Long.toString(value));
    }

    public static final String getIndent(int indent) {
        String prefix = "";
        for (int i = 0; i < indent; ++i) {
            prefix = prefix + " ";
        }
        return prefix;
    }

    public abstract String toXML(int var1);

    public final String toXML() {
        return this.toXML(0);
    }

    protected void setToplevelTag(String toplevelTag) {
        this.fXmlToplevelTag = toplevelTag;
        this.fXmlToplevelStartTag = "<" + toplevelTag + ">";
        this.fXmlToplevelStopTag = "</" + toplevelTag + ">";
    }
}

