/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class RowMapperResultSetExtractor
implements ResultSetExtractor {
    private final RowMapper rowMapper;
    private final int rowsExpected;

    public RowMapperResultSetExtractor(RowMapper rowMapper) {
        this(rowMapper, 0);
    }

    public RowMapperResultSetExtractor(RowMapper rowMapper, int rowsExpected) {
        Assert.notNull((Object)rowMapper, (String)"RowMapper is required");
        this.rowMapper = rowMapper;
        this.rowsExpected = rowsExpected;
    }

    public Object extractData(ResultSet rs) throws SQLException {
        AbstractList results = this.rowsExpected > 0 ? new ArrayList(this.rowsExpected) : new LinkedList();
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.rowMapper.mapRow(rs, rowNum++));
        }
        return results;
    }
}

