/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.MatchException;
import com.p6spy.engine.common.StringMatcher;
import java.util.Hashtable;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class JakartaRegexMatcher
implements StringMatcher {
    private Hashtable expressionCache = new Hashtable(10);

    public boolean match(String expression, String value) throws MatchException {
        try {
            if (!this.expressionCache.contains(expression)) {
                this.expressionCache.put(expression, new RE(expression));
            }
            RE regex = (RE)this.expressionCache.get(expression);
            return regex.match(value);
        }
        catch (RESyntaxException e) {
            throw new MatchException("Bad syntax for expression: [" + expression + "]", e);
        }
    }
}

