/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import org.jCharts.axisChart.ScatterPlotAxisChart;
import org.jCharts.chartData.interfaces.IScatterPlotDataSet;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.properties.ScatterPlotProperties;

abstract class ScatterPlotChart {
    ScatterPlotChart() {
    }

    static void render(ScatterPlotAxisChart scatterPlotAxisChart, IScatterPlotDataSet iScatterPlotDataSet) {
        Shape shape;
        int n;
        float[][] fArray = new float[iScatterPlotDataSet.getNumberOfDataSets()][iScatterPlotDataSet.getNumberOfDataItems()];
        float[][] fArray2 = new float[iScatterPlotDataSet.getNumberOfDataSets()][iScatterPlotDataSet.getNumberOfDataItems()];
        int n2 = 0;
        while (n2 < iScatterPlotDataSet.getNumberOfDataItems()) {
            int n3 = 0;
            while (n3 < fArray2.length) {
                if (iScatterPlotDataSet.getValue(n3, n2) != null) {
                    fArray[n3][n2] = scatterPlotAxisChart.getXAxis().computeAxisCoordinate(scatterPlotAxisChart.getXAxis().getOrigin(), iScatterPlotDataSet.getValue(n3, n2).getX(), scatterPlotAxisChart.getXAxis().getScaleCalculator().getMinValue());
                    fArray2[n3][n2] = scatterPlotAxisChart.getYAxis().computeAxisCoordinate(scatterPlotAxisChart.getYAxis().getOrigin(), iScatterPlotDataSet.getValue(n3, n2).getY(), scatterPlotAxisChart.getYAxis().getScaleCalculator().getMinValue());
                    if (scatterPlotAxisChart.getGenerateImageMapFlag()) {
                        scatterPlotAxisChart.getImageMap().addImageMapArea(new CircleMapArea(fArray2[n3][n2], fArray2[n3][n2], iScatterPlotDataSet.getValue(n3, n2), iScatterPlotDataSet.getLegendLabel(n3)));
                    }
                } else {
                    fArray[n3][n2] = Float.NaN;
                    fArray2[n3][n2] = Float.NaN;
                }
                ++n3;
            }
            ++n2;
        }
        ScatterPlotProperties scatterPlotProperties = (ScatterPlotProperties)iScatterPlotDataSet.getChartTypeProperties();
        Graphics2D graphics2D = scatterPlotAxisChart.getGraphics2D();
        AffineTransform affineTransform = null;
        double[] dArray = null;
        double[] dArray2 = null;
        if (scatterPlotProperties.getShapes() != null) {
            dArray = new double[iScatterPlotDataSet.getNumberOfDataSets()];
            dArray2 = new double[iScatterPlotDataSet.getNumberOfDataSets()];
            affineTransform = graphics2D.getTransform();
            n = 0;
            while (n < iScatterPlotDataSet.getNumberOfDataSets()) {
                if (scatterPlotProperties.getShapes()[n] != null) {
                    shape = scatterPlotProperties.getShapes()[n].getBounds2D();
                    dArray[n] = ((RectangularShape)shape).getWidth() / 2.0;
                    dArray2[n] = ((RectangularShape)shape).getHeight() / 2.0;
                }
                ++n;
            }
        }
        shape = new Line2D.Float(fArray[0][0], fArray2[0][0], fArray[0][1], fArray2[0][1]);
        if (fArray2[0].length > 1) {
            ((Line2D.Float)shape).y2 = fArray2[0][1];
        }
        n = 0;
        while (n < fArray2.length) {
            ((Line2D.Float)shape).x1 = fArray[n][0];
            ((Line2D.Float)shape).y1 = fArray2[n][0];
            ((Line2D.Float)shape).x2 = ((Line2D.Float)shape).x1;
            int n4 = 1;
            while (n4 < fArray2[0].length) {
                if (!Float.isNaN(fArray2[n][n4])) {
                    if (Float.isNaN(fArray2[n][n4 - 1])) {
                        ((Line2D.Float)shape).x1 = fArray[n][n4];
                        ((Line2D.Float)shape).y1 = fArray2[n][n4];
                        ((Line2D.Float)shape).x2 = fArray[n][n4];
                        ((Line2D.Float)shape).y2 = fArray2[n][n4];
                    } else {
                        ((Line2D.Float)shape).x2 = fArray[n][n4];
                        ((Line2D.Float)shape).y2 = fArray2[n][n4];
                        graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                        graphics2D.setStroke(scatterPlotProperties.getLineStrokes()[n]);
                        graphics2D.draw(shape);
                        if (scatterPlotProperties.getShapes()[n] != null) {
                            graphics2D.translate((double)((Line2D.Float)shape).x1 - dArray[n], (double)((Line2D.Float)shape).y1 - dArray2[n]);
                            graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                            graphics2D.fill(scatterPlotProperties.getShapes()[n]);
                            graphics2D.setTransform(affineTransform);
                        }
                        ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                        ((Line2D.Float)shape).y1 = ((Line2D.Float)shape).y2;
                    }
                } else {
                    if (!Float.isNaN(fArray2[n][n4 - 1]) && scatterPlotProperties.getShapes()[n] != null) {
                        graphics2D.translate((double)((Line2D.Float)shape).x1 - dArray[n], (double)((Line2D.Float)shape).y1 - dArray2[n]);
                        graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                        graphics2D.fill(scatterPlotProperties.getShapes()[n]);
                        graphics2D.setTransform(affineTransform);
                    }
                    ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2 = scatterPlotAxisChart.getXAxis().getScalePixelWidth();
                }
                ++n4;
            }
            if (!Float.isNaN(fArray2[n][fArray2[n].length - 1]) && scatterPlotProperties.getShapes()[n] != null) {
                graphics2D.translate((double)((Line2D.Float)shape).x2 - dArray[n], (double)((Line2D.Float)shape).y2 - dArray2[n]);
                graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                graphics2D.fill(scatterPlotProperties.getShapes()[n]);
                graphics2D.setTransform(affineTransform);
            }
            ++n;
        }
    }
}

