/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelPosition;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelRenderer;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.BarChartProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LabelAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.util.ChartStroke;
import org.jCharts.test.AxisChartTestBase;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

public final class BarTestDriver
extends AxisChartTestBase {
    boolean supportsImageMap() {
        return true;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        BarChartProperties barChartProperties = new BarChartProperties();
        barChartProperties.setWidthPercentage(1.0f);
        return barChartProperties;
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(2.0, 5.0);
        int n2 = 1;
        DataSeries dataSeries = super.createDataSeries(n);
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.BAR, BarTestDriver.getChartTypeProperties(n2), n2, n, -2000, 2000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws PropertyException, ChartDataException {
        BarChartProperties barChartProperties = new BarChartProperties();
        double[][] dArrayArray = new double[][]{{280.0, 16.0, -150.0, 160.0, 90.0, 60.0, 150.0, 11.0, -23.0, 50.0, 89.0}};
        Paint[] paintArray = new Paint[]{Color.green};
        String[] stringArray2 = new String[]{"Test Legend Label"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.BAR, barChartProperties);
        String[] stringArray3 = new String[]{"1900", "195555510", "1920", "1935555555555550", "1940", "19555555550", "5555551960", "19755555550", "19855550", "19905555", "20005555"};
        DataSeries dataSeries = new DataSeries(stringArray3, "Wonka Bars", "Years", "Oompa Loompa Productivity");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(true);
        axisProperties.getYAxisProperties().setShowGridLines(1);
        axisProperties.getYAxisProperties().setGridLineChartStroke(new ChartStroke(new BasicStroke(1.5f), Color.red));
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getXAxisProperties();
        dataAxisProperties.setRoundToNearest(1);
        dataAxisProperties.setUserDefinedScale(-300.0, 200.0);
        LegendProperties legendProperties = null;
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "BarChartTest.png");
        BarTestDriver.bug();
    }

    public static void bug() throws ChartDataException, PropertyException {
        String[] stringArray = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};
        double[][] dArray = new double[1][12];
        int n = 0;
        while (n < 12) {
            double d;
            dArray[0][n] = d = 51.0;
            ++n;
        }
        String string = "CHART1_XAXIS";
        String string2 = "CHART1_YAXIS";
        String string3 = "CHART1_TITLE hhhhhhhhhhhhhhhhhhhhh hhhhhhhhh hhhhhhhhhhh hhhhhhhhhhh hhhhhhhh hhhhhhhh hhhh  hhhhh hhhh hhhh hhhh  hhhhh hhhhhhhh";
        DataSeries dataSeries = new DataSeries(stringArray, string, string2, string3);
        String[] stringArray2 = new String[]{"CHART1_LEGEND"};
        Paint[] paintArray = new Paint[]{new GradientPaint(0.0f, 0.0f, new Color(255, 213, 83, 150), 0.0f, 350.0f, new Color(243, 116, 0, 200))};
        BarChartProperties barChartProperties = new BarChartProperties();
        ValueLabelRenderer valueLabelRenderer = new ValueLabelRenderer(false, false, false, -1);
        valueLabelRenderer.setValueLabelPosition(ValueLabelPosition.ON_TOP);
        valueLabelRenderer.useVerticalLabels(false);
        barChartProperties.addPostRenderEventListener(valueLabelRenderer);
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArray, stringArray2, paintArray, ChartType.BAR, barChartProperties);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        LabelAxisProperties labelAxisProperties = new LabelAxisProperties();
        DataAxisProperties dataAxisProperties = new DataAxisProperties();
        dataAxisProperties.setRoundToNearest(0);
        AxisProperties axisProperties = new AxisProperties(labelAxisProperties, dataAxisProperties);
        LegendProperties legendProperties = new LegendProperties();
        axisProperties.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), 0.0f, 300.0f, new Color(167, 213, 255)));
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, null, 548, 350);
        ChartTestDriver.exportImage(axisChart, "Bug_BarChartTest.png");
    }
}

