/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler;

import java.util.StringTokenizer;

public class QueryEntry
implements Comparable {
    private long time = 0L;
    private long elapsedTime = 0L;
    private String preparedSQL;
    private String sqlStatement;
    private String category;
    private String connectionID;
    private int receptionRank = 0;

    public QueryEntry() {
    }

    public QueryEntry(String p6EncodedText) {
        this.parseP6Encoding(p6EncodedText);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public String getPreparedSQL() {
        return this.preparedSQL;
    }

    public void setPreparedSQL(String preparedSQL) {
        this.preparedSQL = preparedSQL;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public void setSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public int getReceptionRank() {
        return this.receptionRank;
    }

    public void setReceptionRank(int receptionRank) {
        this.receptionRank = receptionRank;
    }

    private void parseP6Encoding(String p6EncodedText) {
        StringTokenizer tokenizer = new StringTokenizer(p6EncodedText, "|", true);
        String now = tokenizer.nextToken();
        if (now.equals("|")) {
            now = null;
        } else {
            tokenizer.nextToken();
        }
        String elapsed = tokenizer.nextToken();
        if (elapsed.equals("|")) {
            elapsed = null;
        } else {
            tokenizer.nextToken();
        }
        String connectionID = tokenizer.nextToken();
        if (connectionID.equals("|")) {
            connectionID = null;
        } else {
            tokenizer.nextToken();
        }
        String category = tokenizer.nextToken();
        if (category.equals("|")) {
            category = null;
        } else {
            tokenizer.nextToken();
        }
        String prepared = tokenizer.nextToken();
        if (prepared.equals("|")) {
            prepared = null;
        } else {
            tokenizer.nextToken();
        }
        String sqlStatement = "";
        if (tokenizer.hasMoreTokens()) {
            sqlStatement = tokenizer.nextToken();
        }
        this.time = Long.parseLong(now);
        this.elapsedTime = Long.parseLong(elapsed);
        this.connectionID = connectionID;
        this.category = category;
        this.preparedSQL = prepared;
        this.sqlStatement = sqlStatement;
    }

    public int compareTo(Object o) {
        Long rightTime;
        QueryEntry right = (QueryEntry)o;
        Long leftTime = new Long(this.getTime());
        int timeCompare = leftTime.compareTo(rightTime = new Long(right.getTime()));
        if (timeCompare != 0) {
            return timeCompare;
        }
        return new Integer(this.receptionRank).compareTo(new Integer(right.getReceptionRank()));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return (Long.toString(this.time) + Integer.toString(this.receptionRank)).hashCode();
    }
}

