/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Category;
import org.jahia.sqlprofiler.QueryEntry;
import org.jahia.sqlprofiler.gui.ProfileStatementTableModel;

class ProfileDetailsPanel
extends JPanel
implements ListSelectionListener {
    private static final Category LOG = Category.getInstance(class$org$jahia$sqlprofiler$gui$ProfileDetailsPanel == null ? (class$org$jahia$sqlprofiler$gui$ProfileDetailsPanel = ProfileDetailsPanel.class$("org.jahia.sqlprofiler.gui.ProfileDetailsPanel")) : class$org$jahia$sqlprofiler$gui$ProfileDetailsPanel);
    private static final MessageFormat FORMATTER = new MessageFormat("<b>Time:</b> <code>{0,time,medium}</code>&nbsp;&nbsp;<b>Elapsed time:</b> <code>{1,time,medium}</code>&nbsp;&nbsp;<b>Category:</b> <code>{2}</code>&nbsp;&nbsp;<b>Connection ID:</b> <code>{3}</code><br><b>Prepared SQL:</b><br>{4}<br><b>SQL Statement:</b><br>{5}");
    private final ProfileStatementTableModel mModel;
    private final JEditorPane mDetails;
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$ProfileDetailsPanel;

    ProfileDetailsPanel(JTable aTable, ProfileStatementTableModel aModel) {
        this.mModel = aModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Details: "));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel rowSM = aTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent aEvent) {
        if (aEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)aEvent.getSource();
        if (lsm.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            QueryEntry queryEntry = this.mModel.getStatementDetails(selectedRow);
            Object[] args = new Object[]{new Date(queryEntry.getTime()), new Long(queryEntry.getElapsedTime()), this.escape(queryEntry.getCategory()), this.escape(queryEntry.getConnectionID()), this.escape(queryEntry.getPreparedSQL()), this.escape(queryEntry.getSqlStatement())};
            this.mDetails.setText(FORMATTER.format(args));
            this.mDetails.setCaretPosition(0);
        }
    }

    private String escape(String aStr) {
        if (aStr == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < aStr.length()) {
            char c = aStr.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

