/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.jahia.sqlprofiler.gui.ProfileReportResult;

public class ProfileResultTableModel
extends AbstractTableModel
implements Comparator {
    private ArrayList profileResults = new ArrayList();
    protected int currCol = 0;
    protected Vector ascendCol = new Vector();
    protected Integer one = new Integer(1);
    protected Integer minusOne = new Integer(-1);
    private static final String[] COLUMN_NAMES = new String[]{"%", "Time[ms]", "Count", "Table(s)", "Column(s)"};

    public ProfileResultTableModel() {
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            this.ascendCol.add(this.one);
            ++i;
        }
    }

    public int getRowCount() {
        return this.profileResults.size();
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int aCol) {
        return COLUMN_NAMES[aCol];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ProfileReportResult curResult = (ProfileReportResult)this.profileResults.get(rowIndex);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = nf.format(curResult.getPercentage());
                break;
            }
            case 1: {
                result = new Long(curResult.getTotalElapsedTime());
                break;
            }
            case 2: {
                result = new Integer(curResult.getOccurences());
                break;
            }
            case 3: {
                StringBuffer resultBuf = new StringBuffer();
                Iterator tableNameIter = curResult.getTableNames().iterator();
                while (tableNameIter.hasNext()) {
                    String curTableName = (String)tableNameIter.next();
                    resultBuf.append(curTableName);
                    if (!tableNameIter.hasNext()) continue;
                    resultBuf.append(",");
                }
                result = resultBuf.toString();
                break;
            }
            case 4: {
                StringBuffer resultBuf2 = new StringBuffer();
                Iterator columnNameIter = curResult.getColumnNames().iterator();
                while (columnNameIter.hasNext()) {
                    String curColumnName = (String)columnNameIter.next();
                    resultBuf2.append(curColumnName);
                    if (!columnNameIter.hasNext()) continue;
                    resultBuf2.append(",");
                }
                result = resultBuf2.toString();
            }
        }
        return result;
    }

    public void clear() {
        this.profileResults.clear();
        this.currCol = 0;
        this.fireTableDataChanged();
    }

    public void addProfileReportResult(ProfileReportResult profileReportResult) {
        this.profileResults.add(profileReportResult);
    }

    public int compare(Object v1, Object v2) {
        int ascending = (Integer)this.ascendCol.get(this.currCol);
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v2 == null) {
            return 1 * ascending;
        }
        if (v1 == null) {
            return -1 * ascending;
        }
        ProfileReportResult left = (ProfileReportResult)v1;
        ProfileReportResult right = (ProfileReportResult)v2;
        Serializable o1 = null;
        Serializable o2 = null;
        switch (this.currCol) {
            case 0: {
                o1 = new Double(left.getPercentage());
                o2 = new Double(right.getPercentage());
                break;
            }
            case 1: {
                o1 = new Long(left.getTotalElapsedTime());
                o2 = new Long(right.getTotalElapsedTime());
                break;
            }
            case 2: {
                o1 = new Integer(left.getOccurences());
                o2 = new Integer(right.getOccurences());
                break;
            }
            case 3: {
                o1 = left.getTableNames();
                o2 = right.getTableNames();
                break;
            }
            case 4: {
                o1 = left.getColumnNames();
                o2 = right.getColumnNames();
            }
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o2 == null) {
            return 1 * ascending;
        }
        if (o1 == null) {
            return -1 * ascending;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n2;
            double d2;
            Number n1 = (Number)o1;
            double d1 = n1.doubleValue();
            if (d1 == (d2 = (n2 = (Number)o2).doubleValue())) {
                return 0;
            }
            if (d1 > d2) {
                return 1 * ascending;
            }
            return -1 * ascending;
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)o1;
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1 * ascending;
            }
            return -1 * ascending;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)((Object)o1);
            Comparable c2 = (Comparable)((Object)o2);
            try {
                return c1.compareTo(c2) * ascending;
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2) * ascending;
    }

    public void sort() {
        Collections.sort(this.profileResults, this);
        Integer val = (Integer)this.ascendCol.get(this.currCol);
        this.ascendCol.remove(this.currCol);
        if (val.equals(this.one)) {
            this.ascendCol.add(this.currCol, this.minusOne);
        } else {
            this.ascendCol.add(this.currCol, this.one);
        }
    }

    public void sortByColumn(int column) {
        this.currCol = column;
        this.sort();
        this.fireTableDataChanged();
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final ProfileResultTableModel sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    sorter.sortByColumn(column);
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }
}

