/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;
import org.jahia.sqlprofiler.QueryEntry;
import org.jahia.sqlprofiler.QueryStatEntry;
import org.jahia.sqlprofiler.QueryStatistics;
import org.jahia.sqlprofiler.gui.LoggerTableModel;
import org.jahia.sqlprofiler.gui.ProfileReportResult;
import org.jahia.sqlprofiler.gui.ProfileResultTableModel;

public class ProfileStatementTableModel
extends AbstractTableModel
implements Comparator {
    private QueryStatistics queryStats = new QueryStatistics();
    private static final Logger logger = Logger.getLogger(class$org$jahia$sqlprofiler$gui$ProfileStatementTableModel == null ? (class$org$jahia$sqlprofiler$gui$ProfileStatementTableModel = ProfileStatementTableModel.class$("org.jahia.sqlprofiler.gui.ProfileStatementTableModel")) : class$org$jahia$sqlprofiler$gui$ProfileStatementTableModel);
    private LoggerTableModel loggerModel;
    private JLabel statementCountValueLabel = null;
    private ArrayList queryEntries = new ArrayList();
    private SortedSet sortedQueryEntries = new TreeSet();
    protected int currCol = 0;
    protected Vector ascendCol = new Vector();
    protected Integer one = new Integer(1);
    protected Integer minusOne = new Integer(-1);
    private long lowestQueryTime = Long.MAX_VALUE;
    private long highestQueryTime = Long.MIN_VALUE;
    private long totalQueryTime = 0L;
    private static final String[] COLUMN_NAMES = new String[]{"Date", "Time[ms]", "ID", "Category", "Prepared", "SQL"};
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss.SSS");
    private JLabel statementTimeValueLabel;
    private ProfileResultTableModel profileResultModel;
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$ProfileStatementTableModel;

    public ProfileStatementTableModel(LoggerTableModel loggerModel) {
        this.loggerModel = loggerModel;
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            if (i == 0) {
                this.ascendCol.add(this.minusOne);
            } else {
                this.ascendCol.add(this.one);
            }
            ++i;
        }
    }

    public void processP6Event(String eventText) {
        try {
            QueryEntry queryEntry = new QueryEntry(eventText);
            this.addQuery(queryEntry);
            this.queryStats.processSQL(queryEntry);
        }
        catch (NoSuchElementException nsee) {
            logger.error("Error while parsing p6spy format", nsee);
        }
    }

    public void displayOccurenceStats(boolean displayQueries) {
        StringWriter strWriter = new StringWriter();
        PrintWriter ptrWriter = new PrintWriter(strWriter);
        this.profileResultModel.clear();
        Set sortedQueryStats = this.queryStats.getQueryStatsByOccurence();
        Iterator queryStatByOccurenceIter = this.queryStats.getQueryStatsByOccurence().iterator();
        while (queryStatByOccurenceIter.hasNext()) {
            QueryStatEntry curQueryStat = (QueryStatEntry)queryStatByOccurenceIter.next();
            double curPercentage = 0.0;
            curPercentage = this.queryStats.getTotalElapsedQueryTime() > 0L ? 100.0 * (double)curQueryStat.getTotalElapsedTime() / (double)this.queryStats.getTotalElapsedQueryTime() : 100.0 * (double)curQueryStat.getOccurences() / (double)this.queryStats.getOccurenceCount();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            ProfileReportResult profileResult = new ProfileReportResult();
            profileResult.setPercentage(curPercentage);
            profileResult.setOccurences(curQueryStat.getOccurences());
            profileResult.setTotalElapsedTime(curQueryStat.getTotalElapsedTime());
            profileResult.setTableNames(curQueryStat.getTableNames());
            profileResult.setColumnNames(curQueryStat.getColumnNames());
            this.profileResultModel.addProfileReportResult(profileResult);
        }
        this.profileResultModel.fireTableDataChanged();
    }

    public void saveSQLIndexFile(String indexesFileName) {
        logger.debug("Writing indexes SQL to file [" + indexesFileName + "]...");
        try {
            FileWriter fileWriter = new FileWriter(indexesFileName);
            PrintWriter writer = new PrintWriter(fileWriter);
            Map generatedIndexes = this.queryStats.getGeneratedIndexes();
            Iterator indexNameIter = generatedIndexes.keySet().iterator();
            while (indexNameIter.hasNext()) {
                String curIndexName = (String)indexNameIter.next();
                String indexSql = (String)generatedIndexes.get(curIndexName);
                writer.println(indexSql);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        logger.debug("done.");
    }

    public void saveReportFile(String reportFileName) {
        logger.debug("Writing report to file [" + reportFileName + "]...");
        try {
            FileWriter fileWriter = new FileWriter(reportFileName);
            PrintWriter writer = new PrintWriter(fileWriter);
            Set sortedQueryStats = this.queryStats.getQueryStatsByOccurence();
            Iterator queryStatByOccurenceIter = this.queryStats.getQueryStatsByOccurence().iterator();
            while (queryStatByOccurenceIter.hasNext()) {
                QueryStatEntry curQueryStat = (QueryStatEntry)queryStatByOccurenceIter.next();
                double curPercentage = 0.0;
                curPercentage = this.queryStats.getTotalElapsedQueryTime() > 0L ? 100.0 * (double)curQueryStat.getTotalElapsedTime() / (double)this.queryStats.getTotalElapsedQueryTime() : 100.0 * (double)curQueryStat.getOccurences() / (double)this.queryStats.getOccurenceCount();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                Set setQueries = curQueryStat.getQueries();
                Iterator setQueriesIter = setQueries.iterator();
                QueryEntry querySQL = (QueryEntry)setQueriesIter.next();
                String strQuerySQL = querySQL.getPreparedSQL();
                if (strQuerySQL == null) {
                    strQuerySQL = querySQL.getSqlStatement();
                }
                writer.println(curPercentage + "," + curQueryStat.getTotalElapsedTime() + "," + curQueryStat.getOccurences() + ",\"" + curQueryStat.getTableNames() + "\",\"" + curQueryStat.getColumnNames() + "\",\"" + strQuerySQL + "\"");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        logger.debug("done.");
    }

    public int getRowCount() {
        return this.queryEntries.size();
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int aCol) {
        return COLUMN_NAMES[aCol];
    }

    public void addQuery(QueryEntry queryEntry) {
        queryEntry.setReceptionRank(this.queryEntries.size());
        this.queryEntries.add(queryEntry);
        this.sortedQueryEntries.add(queryEntry);
        long entryTime = queryEntry.getTime();
        if (entryTime > this.highestQueryTime) {
            this.highestQueryTime = entryTime;
        }
        if (entryTime < this.lowestQueryTime) {
            this.lowestQueryTime = entryTime;
        }
        if (queryEntry.getElapsedTime() > 0L) {
            this.totalQueryTime += queryEntry.getElapsedTime();
        }
    }

    public void updateQueryStatsDisplay() {
        if (this.statementCountValueLabel != null) {
            this.statementCountValueLabel.setText(Integer.toString(this.queryEntries.size()));
        }
        if (this.statementTimeValueLabel != null) {
            this.statementTimeValueLabel.setText(Long.toString(this.totalQueryTime));
        }
    }

    public void clear() {
        this.queryEntries.clear();
        this.sortedQueryEntries.clear();
        this.lowestQueryTime = Long.MAX_VALUE;
        this.highestQueryTime = Long.MIN_VALUE;
        this.totalQueryTime = 0L;
        this.currCol = 0;
        if (this.statementCountValueLabel != null) {
            this.statementCountValueLabel.setText(Integer.toString(this.queryEntries.size()));
        }
        if (this.statementTimeValueLabel != null) {
            this.statementTimeValueLabel.setText("0");
        }
        this.queryStats.clear();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        QueryEntry curQueryEntry = (QueryEntry)this.queryEntries.get(rowIndex);
        return this.getFormattedQueryEntryColumn(curQueryEntry, columnIndex);
    }

    private Object getFormattedQueryEntryColumn(QueryEntry curQueryEntry, int columnIndex) {
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = DATE_FORMATTER.format(new Date(curQueryEntry.getTime()));
                break;
            }
            case 1: {
                result = new Long(curQueryEntry.getElapsedTime());
                break;
            }
            case 2: {
                result = curQueryEntry.getConnectionID();
                break;
            }
            case 3: {
                result = curQueryEntry.getCategory();
                break;
            }
            case 4: {
                result = curQueryEntry.getPreparedSQL();
                break;
            }
            case 5: {
                result = curQueryEntry.getSqlStatement();
            }
        }
        return result;
    }

    private Object getRawQueryEntryColumn(QueryEntry curQueryEntry, int columnIndex) {
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = new Date(curQueryEntry.getTime());
                break;
            }
            case 1: {
                result = new Long(curQueryEntry.getElapsedTime());
                break;
            }
            case 2: {
                result = curQueryEntry.getConnectionID();
                break;
            }
            case 3: {
                result = curQueryEntry.getCategory();
                break;
            }
            case 4: {
                result = curQueryEntry.getPreparedSQL();
                break;
            }
            case 5: {
                result = curQueryEntry.getSqlStatement();
            }
        }
        return result;
    }

    public int compare(Object v1, Object v2) {
        int ascending = (Integer)this.ascendCol.get(this.currCol);
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v2 == null) {
            return 1 * ascending;
        }
        if (v1 == null) {
            return -1 * ascending;
        }
        QueryEntry left = (QueryEntry)v1;
        QueryEntry right = (QueryEntry)v2;
        Object o1 = this.getRawQueryEntryColumn(left, this.currCol);
        Object o2 = this.getRawQueryEntryColumn(right, this.currCol);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o2 == null) {
            return 1 * ascending;
        }
        if (o1 == null) {
            return -1 * ascending;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n2;
            double d2;
            Number n1 = (Number)o1;
            double d1 = n1.doubleValue();
            if (d1 == (d2 = (n2 = (Number)o2).doubleValue())) {
                return 0;
            }
            if (d1 > d2) {
                return 1 * ascending;
            }
            return -1 * ascending;
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)o1;
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1 * ascending;
            }
            return -1 * ascending;
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            Date date1 = (Date)o1;
            Date date2 = (Date)o2;
            return date1.compareTo(date2) * ascending;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            try {
                return c1.compareTo(c2) * ascending;
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2) * ascending;
    }

    public void sort() {
        Integer val = (Integer)this.ascendCol.get(this.currCol);
        this.ascendCol.remove(this.currCol);
        if (val.equals(this.one)) {
            this.ascendCol.add(this.currCol, this.minusOne);
        } else {
            this.ascendCol.add(this.currCol, this.one);
        }
        Collections.sort(this.queryEntries, this);
    }

    public void sortByColumn(int column) {
        this.currCol = column;
        this.sort();
        this.fireTableDataChanged();
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final ProfileStatementTableModel sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    sorter.sortByColumn(column);
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortAndUpdateTable() {
        Collections.sort(this.queryEntries, this);
        this.fireTableDataChanged();
    }

    public JLabel getStatementCountValueLabel() {
        return this.statementCountValueLabel;
    }

    public QueryEntry getStatementDetails(int rowIndex) {
        return (QueryEntry)this.queryEntries.get(rowIndex);
    }

    public void setStatementCountValueLabel(JLabel statementCountValueLabel) {
        this.statementCountValueLabel = statementCountValueLabel;
    }

    public JLabel getStatementTimeValueLabel() {
        return this.statementTimeValueLabel;
    }

    public void setStatementTimeValueLabel(JLabel statementTimeValueLabel) {
        this.statementTimeValueLabel = statementTimeValueLabel;
    }

    public ProfileResultTableModel getProfileResultModel() {
        return this.profileResultModel;
    }

    public void setProfileResultModel(ProfileResultTableModel profileResultModel) {
        this.profileResultModel = profileResultModel;
    }

    public long getLowestQueryTime() {
        return this.lowestQueryTime;
    }

    public long getHighestQueryTime() {
        return this.highestQueryTime;
    }

    public ArrayList getQueriesBetweenTime(long lowTime, long highTime) {
        ArrayList<QueryEntry> resultList = new ArrayList<QueryEntry>();
        int i = 0;
        while (i < this.queryEntries.size()) {
            QueryEntry curEntry = (QueryEntry)this.queryEntries.get(i);
            long entryTime = curEntry.getTime();
            if (entryTime >= lowTime && entryTime <= highTime) {
                resultList.add(curEntry);
            }
            ++i;
        }
        return resultList;
    }

    public ArrayList getQueryEntries() {
        return this.queryEntries;
    }

    public SortedSet getSortedQueryEntries() {
        return this.sortedQueryEntries;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

