/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.jahia.sqlprofiler.gui.LoggerTableModel;
import org.jahia.sqlprofiler.gui.ProfileStatementTableModel;

public class ToolbarPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(class$org$jahia$sqlprofiler$gui$ToolbarPanel == null ? (class$org$jahia$sqlprofiler$gui$ToolbarPanel = ToolbarPanel.class$("org.jahia.sqlprofiler.gui.ToolbarPanel")) : class$org$jahia$sqlprofiler$gui$ToolbarPanel);
    BorderLayout borderLayout1 = new BorderLayout();
    private JButton playButton;
    private JButton pauseButton;
    private JButton reportButton;
    private boolean playing = true;
    private LoggerTableModel loggerModel;
    private ProfileStatementTableModel profileStatementTableModel;
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$ToolbarPanel;

    public ToolbarPanel(LoggerTableModel loggerModel, ProfileStatementTableModel profileStatementTableModel) {
        this.loggerModel = loggerModel;
        this.profileStatementTableModel = profileStatementTableModel;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        JToolBar toolbar = new JToolBar();
        URL saveAsIconURL = ClassLoader.getSystemResource("toolbarButtonGraphics/general/SaveAs16.gif");
        ImageIcon saveAsIcon = new ImageIcon(saveAsIconURL, "Save As");
        JButton myButton = new JButton(saveAsIcon);
        myButton.setToolTipText("Save the generated SQL INDEX File as...");
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Save Index SQL File As...");
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal == 0) {
                    ToolbarPanel.this.profileStatementTableModel.saveSQLIndexFile(chooser.getSelectedFile().toString());
                }
            }
        });
        toolbar.add(myButton);
        toolbar.addSeparator();
        URL clearIconURL = ClassLoader.getSystemResource("toolbarButtonGraphics/general/Delete16.gif");
        ImageIcon clearIcon = new ImageIcon(clearIconURL, "Clear");
        myButton = new JButton(clearIcon);
        myButton.setToolTipText("Clear all the log entries from memory");
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                ToolbarPanel.this.loggerModel.clear();
            }
        });
        toolbar.add(myButton);
        toolbar.addSeparator();
        URL playIconURL = ClassLoader.getSystemResource("toolbarButtonGraphics/media/Play16.gif");
        ImageIcon playIcon = new ImageIcon(playIconURL, "Play");
        this.playButton = new JButton(playIcon);
        this.playButton.setEnabled(false);
        this.playButton.setToolTipText("Resume real-time display and gather SQL statistics");
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                ToolbarPanel.this.loggerModel.toggle();
                ToolbarPanel.this.togglePlayButtons();
            }
        });
        toolbar.add(this.playButton);
        URL pauseIconURL = ClassLoader.getSystemResource("toolbarButtonGraphics/media/Pause16.gif");
        ImageIcon pauseIcon = new ImageIcon(pauseIconURL, "Pause");
        this.pauseButton = new JButton(pauseIcon);
        this.pauseButton.setToolTipText("Pause real-time display and display SQL table profile statistics");
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                ToolbarPanel.this.loggerModel.toggle();
                ToolbarPanel.this.togglePlayButtons();
            }
        });
        toolbar.add(this.pauseButton);
        URL reportIconURL = ClassLoader.getSystemResource("toolbarButtonGraphics/general/Edit16.gif");
        ImageIcon reportIcon = new ImageIcon(reportIconURL, "Report");
        this.reportButton = new JButton(reportIcon);
        this.reportButton.setEnabled(false);
        this.reportButton.setToolTipText("Save SQL table profile statistics generated in a file ...");
        this.reportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Save Report File As...");
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal == 0) {
                    ToolbarPanel.this.profileStatementTableModel.saveReportFile(chooser.getSelectedFile().toString());
                }
            }
        });
        toolbar.addSeparator();
        toolbar.add(this.reportButton);
        this.add((Component)toolbar, "North");
    }

    public void togglePlayButtons() {
        boolean bl = this.playing = !this.playing;
        if (this.playing) {
            this.playButton.setEnabled(false);
            this.pauseButton.setEnabled(true);
            this.reportButton.setEnabled(false);
        } else {
            this.playButton.setEnabled(true);
            this.pauseButton.setEnabled(false);
            this.reportButton.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

