/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;

public class FileUtils {
    private static final File POOL_FILE = FileUtils.getUniqueFile(class$com$sinosoft$sysframework$common$util$FileUtils == null ? (class$com$sinosoft$sysframework$common$util$FileUtils = FileUtils.class$("com.sinosoft.sysframework.common.util.FileUtils")) : class$com$sinosoft$sysframework$common$util$FileUtils, ".deletefiles");
    private static ArrayList deleteFilesPool;
    static /* synthetic */ Class class$com$sinosoft$sysframework$common$util$FileUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initPool() {
        if (POOL_FILE.exists() && POOL_FILE.canRead()) {
            ObjectInputStream in = null;
            in = new ObjectInputStream(new FileInputStream(POOL_FILE));
            deleteFilesPool = (ArrayList)in.readObject();
            Object var3_1 = null;
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return;
            {
                catch (Exception e) {
                    deleteFilesPool = new ArrayList();
                    Object var3_2 = null;
                    if (in == null) return;
                    try {
                        in.close();
                        return;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        deleteFilesPool = new ArrayList();
    }

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fromFile, String toFile) throws IOException {
        FileOutputStream out;
        block6: {
            FileInputStream in = null;
            out = null;
            try {
                int len;
                in = new FileInputStream(fromFile);
                out = new FileOutputStream(toFile);
                byte[] b = new byte[1024];
                while ((len = in.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                Object var7_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
    }

    public static String getShortFileName(String fileName) {
        String shortFileName = "";
        int pos = fileName.lastIndexOf(92);
        if (pos == -1) {
            pos = fileName.lastIndexOf(47);
        }
        shortFileName = pos > -1 ? fileName.substring(pos + 1) : fileName;
        return shortFileName;
    }

    public static String getShortFileNameWithoutExt(String fileName) {
        String shortFileName = FileUtils.getShortFileName(fileName);
        shortFileName = FileUtils.getFileNameWithoutExt(shortFileName);
        return shortFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(String fileName) throws Exception {
        String fileContent = "";
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fileName);
            fileContent = FileUtils.read(fin);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws Exception {
        String fileContent = "";
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            fileContent = FileUtils.read(fin);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return fileContent;
    }

    public static String read(InputStream is) throws Exception {
        byte[] result = FileUtils.readBytes(is);
        return new String(result);
    }

    public static byte[] readBytes(String fileName) throws Exception {
        return FileUtils.readBytes(new FileInputStream(fileName));
    }

    public static byte[] readBytes(File file) throws Exception {
        return FileUtils.readBytes(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream is) throws Exception {
        if (is == null || is.available() < 1) {
            return new byte[0];
        }
        byte[] buff = new byte[8192];
        byte[] result = new byte[is.available()];
        BufferedInputStream in = null;
        try {
            int nch;
            in = new BufferedInputStream(is);
            int pos = 0;
            while ((nch = in.read(buff, 0, buff.length)) != -1) {
                System.arraycopy(buff, 0, result, pos, nch);
                pos += nch;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    public static void write(String content, File file) throws IOException {
        FileUtils.write(content.getBytes(), file);
    }

    public static void write(String content, String file) throws IOException {
        FileUtils.write(content, new File(file));
    }

    public static void write(byte[] bytes, String file) throws IOException {
        FileUtils.write(bytes, new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] bytes, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(bytes);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getFileNameWithoutExt(String fileName) {
        String shortFileName = fileName;
        if (fileName.indexOf(46) > -1) {
            shortFileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return shortFileName;
    }

    public static String getFileNameExt(String fileName) {
        String fileExt = "";
        if (fileName.indexOf(46) > -1) {
            fileExt = fileName.substring(fileName.lastIndexOf(46));
        }
        return fileExt;
    }

    public static synchronized File getUniqueFile(File repository, String fileName) {
        String shortFileName = FileUtils.getShortFileName(fileName);
        String tempFileName = FileUtils.getFileNameWithoutExt(shortFileName);
        File file = new File(repository, shortFileName);
        String fileExt = FileUtils.getFileNameExt(shortFileName);
        while (file.exists()) {
            file = new File(repository, tempFileName + "-" + Math.abs(new Random().nextInt()) + fileExt);
        }
        return file;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        file.delete();
        if (file.exists()) {
            deleteFilesPool.add(file);
        }
        FileUtils.checkDeletePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkDeletePool() {
        for (int i = deleteFilesPool.size() - 1; i >= 0; --i) {
            File file = (File)deleteFilesPool.get(i);
            file.delete();
            if (file.exists()) continue;
            deleteFilesPool.remove(i);
        }
        ObjectOutputStream out = null;
        new ObjectOutputStream(new FileOutputStream(POOL_FILE));
        out.writeObject(deleteFilesPool);
        Object var4_3 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var4_4 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public static File getUniqueFile(Class cl, String extension) {
        int key = 0;
        URL url = cl.getResource(FileUtils.getClassNameWithoutPackage(cl) + ".class");
        if (url != null) {
            key = url.getPath().hashCode();
        }
        File propFile = new File(System.getProperty("java.io.tmpdir"), FileUtils.getClassNameWithoutPackage(cl) + key + extension);
        return propFile;
    }

    private static String getClassNameWithoutPackage(Class cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        String name = className.substring(pos);
        return name;
    }

    public static boolean deleteFolder(File delFolder) {
        boolean hasDeleted = true;
        File[] allFiles = delFolder.listFiles();
        for (int i = 0; i < allFiles.length && hasDeleted; ++i) {
            if (allFiles[i].isDirectory()) {
                hasDeleted = FileUtils.deleteFolder(allFiles[i]);
                continue;
            }
            if (!allFiles[i].isFile()) continue;
            try {
                if (allFiles[i].delete()) continue;
                hasDeleted = false;
                continue;
            }
            catch (Exception e) {
                hasDeleted = false;
            }
        }
        if (hasDeleted) {
            delFolder.delete();
        }
        return hasDeleted;
    }

    public static String getRealPathName(Class cl) {
        URL url = cl.getResource(FileUtils.getClassNameWithoutPackage(cl) + ".class");
        if (url != null) {
            return url.getPath();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            FileUtils.initPool();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

