/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StringUtils {
    private StringUtils() {
    }

    public static String newString(String value, int length) {
        StringBuffer buffer = new StringBuffer();
        if (value == null) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static String newString(char ch, int length) {
        return StringUtils.newString(String.valueOf(ch), length);
    }

    public static String copyString(String str, int copyTimes) {
        StringBuffer buffer = new StringBuffer();
        if (str == null) {
            return null;
        }
        for (int i = 0; i < copyTimes; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static int getBytesLength(String str) {
        if (str == null) {
            return -1;
        }
        return str.getBytes().length;
    }

    public static int indexOf(String str, String subStr, int startIndex, int occurrenceTimes) {
        int foundCount = 0;
        int index = startIndex;
        int substrLength = subStr.length();
        if (occurrenceTimes <= 0) {
            return -1;
        }
        if (str.length() - 1 < startIndex) {
            return -1;
        }
        if (subStr.equals("")) {
            return 0;
        }
        while (foundCount < occurrenceTimes) {
            if ((index = str.indexOf(subStr, index)) == -1) {
                return -1;
            }
            ++foundCount;
            index += substrLength;
        }
        return index - substrLength;
    }

    public static int indexOf(String str, String subStr, int occurrenceTimes) {
        return StringUtils.indexOf(str, subStr, 0, occurrenceTimes);
    }

    public static int indexOf(String str, String subStr, int fromIndex, boolean caseSensitive) {
        if (!caseSensitive) {
            return str.toLowerCase().indexOf(subStr.toLowerCase(), fromIndex);
        }
        return str.indexOf(subStr, fromIndex);
    }

    public static String replace(String str, String searchStr, String replaceStr, boolean caseSensitive) {
        String result = "";
        int i = 0;
        int j = 0;
        if (str == null) {
            return null;
        }
        if (str.equals("")) {
            return "";
        }
        if (searchStr == null || searchStr.equals("")) {
            return str;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        while ((j = StringUtils.indexOf(str, searchStr, i, caseSensitive)) > -1) {
            result = result + str.substring(i, j) + replaceStr;
            i = j + searchStr.length();
        }
        result = result + str.substring(i, str.length());
        return result;
    }

    public static String replace(String str, String searchStr, String replaceStr) {
        return StringUtils.replace(str, searchStr, replaceStr, true);
    }

    public static String replace(String str, char searchChar, String replaceStr) {
        return StringUtils.replace(str, searchChar + "", replaceStr, true);
    }

    public static String replace(String str, int beginIndex, String replaceStr) {
        String result = null;
        if (str == null) {
            return null;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        result = str.substring(0, beginIndex) + replaceStr + str.substring(beginIndex + replaceStr.length());
        return result;
    }

    public static String[] split(String originalString, int splitByteLength) {
        ArrayList<String> vector = new ArrayList<String>();
        String strText = "";
        byte[] arrByte = null;
        int intStartIndex = 0;
        int intEndIndex = 0;
        int index = 0;
        int fixCount = 0;
        String[] arrReturn = null;
        if (originalString == null) {
            return new String[0];
        }
        if (originalString.equals("")) {
            return new String[0];
        }
        if (originalString.trim().equals("")) {
            return new String[]{""};
        }
        if (splitByteLength <= 1) {
            return new String[]{originalString};
        }
        arrByte = originalString.getBytes();
        intEndIndex = 0;
        while (true) {
            intStartIndex = intEndIndex;
            intEndIndex = intStartIndex + splitByteLength;
            if (intStartIndex >= arrByte.length) break;
            if (intEndIndex > arrByte.length) {
                intEndIndex = arrByte.length;
                strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
                vector.add(strText);
                break;
            }
            fixCount = 0;
            strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
            byte[] bytes = strText.getBytes();
            if (bytes.length < splitByteLength) {
                intEndIndex = intStartIndex + bytes.length;
            }
            for (index = intEndIndex - 1; index >= intStartIndex && arrByte[index] != bytes[index - intStartIndex]; --index) {
                ++fixCount;
            }
            if (fixCount > 0) {
                if (fixCount >= intEndIndex) {
                    fixCount = 0;
                    System.out.println("split length " + splitByteLength + " is too small.");
                }
                strText = new String(arrByte, intStartIndex, (intEndIndex -= fixCount) - intStartIndex);
            }
            if (intStartIndex == intEndIndex) {
                throw new IllegalStateException("Can't split(\"" + originalString + "\"," + splitByteLength + "). default charset is " + System.getProperty("file.encoding"));
            }
            vector.add(strText);
        }
        arrReturn = new String[vector.size()];
        vector.toArray(arrReturn);
        return arrReturn;
    }

    public static String[] split(String originalString, String delimiterString) {
        int index = 0;
        String[] returnArray = null;
        int length = 0;
        if (originalString == null || delimiterString == null || originalString.equals("")) {
            return new String[0];
        }
        if (originalString.equals("") || delimiterString.equals("") || originalString.length() < delimiterString.length()) {
            return new String[]{originalString};
        }
        for (String strTemp = originalString; strTemp != null && !strTemp.equals("") && (index = strTemp.indexOf(delimiterString)) != -1; strTemp = strTemp.substring(index + delimiterString.length())) {
            ++length;
        }
        returnArray = new String[++length];
        for (int i = 0; i < length - 1; ++i) {
            index = originalString.indexOf(delimiterString);
            returnArray[i] = originalString.substring(0, index);
            originalString = originalString.substring(index + delimiterString.length());
        }
        returnArray[length - 1] = originalString;
        return returnArray;
    }

    public static String rightTrim(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        for (int i = length - 1; i >= 0 && str.charAt(i) == ' '; --i) {
            --length;
        }
        return str.substring(0, length);
    }

    public static String leftTrim(String str) {
        if (str == null) {
            return "";
        }
        int start = 0;
        int n = str.length();
        for (int i = 0; i < n && str.charAt(i) == ' '; ++i) {
            ++start;
        }
        return str.substring(start);
    }

    public static String absoluteTrim(String str) {
        String result = StringUtils.replace(str, " ", "");
        return result;
    }

    public static String lowerCase(String str, int beginIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toLowerCase());
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String upperCase(String str, int beginIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toUpperCase());
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String lowerCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toLowerCase() + iString.substring(1);
        return newString;
    }

    public static String upperCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toUpperCase() + iString.substring(1);
        return newString;
    }

    public static int timesOf(String str, String subStr) {
        int foundCount = 0;
        if (subStr.equals("")) {
            return 0;
        }
        int fromIndex = str.indexOf(subStr);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(subStr, fromIndex + subStr.length());
        }
        return foundCount;
    }

    public static int timesOf(String str, char ch) {
        int foundCount = 0;
        int fromIndex = str.indexOf(ch);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(ch, fromIndex + 1);
        }
        return foundCount;
    }

    public static Map toMap(String str, String splitString) {
        Map<String, String> map = Collections.synchronizedMap(new HashMap());
        String[] values = StringUtils.split(str, splitString);
        for (int i = 0; i < values.length; ++i) {
            String tempValue = values[i];
            int pos = tempValue.indexOf("=");
            String key = "";
            String value = "";
            if (pos > -1) {
                key = tempValue.substring(0, pos);
                value = tempValue.substring(pos + splitString.length());
            } else {
                key = tempValue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static String native2ascii(String str) {
        char[] ca = str.toCharArray();
        StringBuffer buffer = new StringBuffer(ca.length * 6);
        for (int x = 0; x < ca.length; ++x) {
            char a = ca[x];
            if (a > '\u00ff') {
                buffer.append("\\u").append(Integer.toHexString(a));
                continue;
            }
            buffer.append(a);
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        String[] values = StringUtils.split(new String("\u4e2d\u56fd\u4eba\u6c11\u4fdd\u9669\u516c\u53f8\u4e24\u5343\u5e74\u7279\u522b\u6761\u6b3e".getBytes("GBK"), "GB18030"), 2);
        for (int i = 0; i < values.length; ++i) {
            System.out.println(i + ":\t" + values[i]);
        }
    }
}

